/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.br;
import sun.security.krb5.internal.ccache.a3;
import sun.security.krb5.internal.n;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class HostAddresses
implements Cloneable {
    private static boolean DEBUG = br.ed;
    private n[] addresses = null;
    private volatile int hashCode = 0;

    public int hashCode() {
        if (this.hashCode == 0) {
            int n2 = 17;
            if (this.addresses != null) {
                for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                    n2 = 37 * n2 + this.addresses[i2].hashCode();
                }
            }
            this.hashCode = n2;
        }
        return this.hashCode;
    }

    public HostAddresses() throws UnknownHostException {
        this.addresses = new n[1];
        this.addresses[0] = new n();
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.addresses != null && this.addresses.length > 0) {
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                derOutputStream.write(this.addresses[i2].c());
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    private HostAddresses(int n2) {
    }

    public Object clone() {
        HostAddresses hostAddresses = new HostAddresses(0);
        if (this.addresses != null) {
            hostAddresses.addresses = new n[this.addresses.length];
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                hostAddresses.addresses[i2] = (n)this.addresses[i2].clone();
            }
        }
        return hostAddresses;
    }

    public InetAddress[] getInetAddresses() {
        if (this.addresses == null || this.addresses.length == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(this.addresses.length);
        for (int i2 = 0; i2 < this.addresses.length; ++i2) {
            try {
                if (this.addresses[i2].a != 2) continue;
                arrayList.add(this.addresses[i2].b());
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        Object[] objectArray = new InetAddress[arrayList.size()];
        return (InetAddress[])arrayList.toArray(objectArray);
    }

    public HostAddresses(InetAddress[] inetAddressArray) {
        if (inetAddressArray == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new n[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            this.addresses[i2] = new n(inetAddressArray[i2]);
        }
    }

    public HostAddresses(PrincipalName principalName) throws UnknownHostException, KrbException {
        String[] stringArray = principalName.getNameStrings();
        if (principalName.getNameType() != 3 || stringArray.length < 2) {
            throw new KrbException("TBD: Bad name");
        }
        String string = stringArray[1];
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        n[] nArray = new n[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            nArray[i2] = new n(inetAddressArray[i2]);
        }
        this.addresses = nArray;
    }

    public static HostAddresses getLocalAddresses() throws IOException {
        String string = null;
        InetAddress[] inetAddressArray = null;
        try {
            int n2;
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
            inetAddressArray = InetAddress.getAllByName(string);
            n[] nArray = new n[inetAddressArray.length];
            for (n2 = 0; n2 < inetAddressArray.length; ++n2) {
                nArray[n2] = new n(inetAddressArray[n2]);
            }
            if (DEBUG) {
                System.out.println(">>> KrbKdcReq local addresses for " + string + " are: ");
                for (n2 = 0; n2 < inetAddressArray.length; ++n2) {
                    System.out.println("\n\t" + inetAddressArray[n2]);
                }
            }
            return new HostAddresses(nArray);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public boolean equals(HostAddresses hostAddresses) {
        if (this.addresses == null && hostAddresses.addresses != null || this.addresses != null && hostAddresses.addresses == null) {
            return false;
        }
        if (this.addresses != null && hostAddresses.addresses != null) {
            if (this.addresses.length != hostAddresses.addresses.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                if (this.addresses[i2].a(hostAddresses.addresses[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public void writeAddrs(a3 a32) throws IOException {
        a32.a(this.addresses.length);
        for (int i2 = 0; i2 < this.addresses.length; ++i2) {
            a32.b(this.addresses[i2].a);
            a32.a(this.addresses[i2].b.length);
            a32.write(this.addresses[i2].b, 0, this.addresses[i2].b.length);
        }
    }

    public boolean inList(n n2) {
        if (this.addresses != null) {
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                if (!this.addresses[i2].a(n2)) continue;
                return true;
            }
        }
        return false;
    }

    public HostAddresses(n[] nArray) throws IOException {
        if (nArray != null) {
            this.addresses = new n[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] == null) {
                    throw new IOException("Cannot create a HostAddress");
                }
                this.addresses[i2] = (n)nArray[i2].clone();
            }
        }
    }

    public HostAddresses(DerValue derValue) throws Asn1Exception, IOException {
        Vector vector = new Vector();
        DerValue derValue2 = null;
        while (derValue.getData().available() > 0) {
            derValue2 = derValue.getData().getDerValue();
            vector.addElement(new n(derValue2));
        }
        if (vector.size() > 0) {
            this.addresses = new n[vector.size()];
            vector.copyInto(this.addresses);
        }
    }

    public static HostAddresses parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddresses(derValue2);
    }
}

