/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.WindowPeer;
import java.util.Vector;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WPanelPeer;

public class WWindowPeer
extends WPanelPeer
implements WindowPeer {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$windows$WWindowPeer == null ? (class$sun$awt$windows$WWindowPeer = WWindowPeer.class$("sun.awt.windows.WWindowPeer")) : class$sun$awt$windows$WWindowPeer);
    protected boolean focusableWindow;
    static Vector allWindows;
    private volatile int sysX = 0;
    private volatile int sysY = 0;
    private volatile int sysW = 0;
    private volatile int sysH = 0;
    static Class class$sun$awt$windows$WWindowPeer;

    private native int getScreenImOn();

    static native int getSysMinHeight();

    static native int getSysMinWidth();

    static {
        WWindowPeer.initIDs();
        allWindows = new Vector();
    }

    native void _toFront();

    void clearLocalGC() {
    }

    public void displayChanged() {
        int n2 = this.getScreenImOn();
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)this.winGraphicsConfig.getDevice();
        Win32GraphicsDevice win32GraphicsDevice2 = (Win32GraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[n2];
        this.winGraphicsConfig = (Win32GraphicsConfig)win32GraphicsDevice2.getDefaultConfiguration();
        if (win32GraphicsDevice != win32GraphicsDevice2) {
            win32GraphicsDevice.removeDisplayChangedListener(this);
            win32GraphicsDevice2.addDisplayChangedListener(this);
        }
        super.displayChanged();
    }

    protected void disposeImpl() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        ((Win32GraphicsDevice)graphicsConfiguration.getDevice()).removeDisplayChangedListener(this);
        allWindows.removeElement(this);
        super.disposeImpl();
    }

    void draggedToNewScreen() {
        SunToolkit.executeOnEventHandlerThread((Component)this.target, new Runnable(this){
            private final WWindowPeer this$0;

            public void run() {
                this.this$0.displayChanged();
            }
            {
                this.this$0 = wWindowPeer;
            }
        });
    }

    private static native void initIDs();

    void initialize() {
        super.initialize();
        this.updateInsets(this.insets_);
        allWindows.addElement(this);
        Font font = ((Window)this.target).getFont();
        if (font == null) {
            font = defaultFont;
            ((Window)this.target).setFont(font);
            this.setFont(font);
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        ((Win32GraphicsDevice)graphicsConfiguration.getDevice()).addDisplayChangedListener(this);
    }

    native void resetTargetGC();

    public void show() {
        this.focusableWindow = ((Window)this.target).isFocusableWindow();
        super.show();
    }

    public native void toBack();

    public void toFront() {
        this.focusableWindow = ((Window)this.target).isFocusableWindow();
        this._toFront();
    }

    private final boolean hasWarningWindow() {
        return ((Window)this.target).getWarningString() != null;
    }

    boolean isTargetUndecorated() {
        return true;
    }

    synchronized native void reshapeFrame(int var1, int var2, int var3, int var4);

    public void setBounds(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.constrainBounds(n2, n3, n4, n5);
        this.sysX = rectangle.x;
        this.sysY = rectangle.y;
        this.sysW = rectangle.width;
        this.sysH = rectangle.height;
        super.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public native void _setResizable(boolean var1);

    public void setResizable(boolean bl2) {
        this._setResizable(bl2);
    }

    native void updateInsets(Insets var1);

    Rectangle constrainBounds(int n2, int n3, int n4, int n5) {
        if (!this.hasWarningWindow()) {
            return new Rectangle(n2, n3, n4, n5);
        }
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        GraphicsConfiguration graphicsConfiguration = ((Window)this.target).getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = ((Window)this.target).getToolkit().getScreenInsets(graphicsConfiguration);
        int n10 = rectangle.width - insets.left - insets.right;
        int n11 = rectangle.height - insets.top - insets.bottom;
        if (!((Window)this.target).isVisible() || this.isTargetUndecorated()) {
            int n12 = rectangle.x + insets.left;
            int n13 = rectangle.y + insets.top;
            if (n8 > n10) {
                n8 = n10;
            }
            if (n9 > n11) {
                n9 = n11;
            }
            if (n6 < n12) {
                n6 = n12;
            } else if (n6 + n8 > n12 + n10) {
                n6 = n12 + n10 - n8;
            }
            if (n7 < n13) {
                n7 = n13;
            } else if (n7 + n9 > n13 + n11) {
                n7 = n13 + n11 - n9;
            }
        } else {
            int n14 = Math.max(n10, this.sysW);
            int n15 = Math.max(n11, this.sysH);
            if (n8 > n14) {
                n8 = n14;
            }
            if (n9 > n15) {
                n9 = n15;
            }
        }
        return new Rectangle(n6, n7, n8, n9);
    }

    WWindowPeer(Window window) {
        super(window);
    }

    native void _setTitle(String var1);

    public void setTitle(String string) {
        if (string == null) {
            string = new String("");
        }
        this._setTitle(string);
    }

    void create(WComponentPeer wComponentPeer) {
        this.createAwtWindow(wComponentPeer);
    }

    native void createAwtWindow(WComponentPeer var1);

    private native Component getContainerElement(Container var1, int var2);

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

