/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.SunClipboard;

public class ClipboardTransferable
implements Transferable {
    private final HashMap flavorsToData = new HashMap();
    private DataFlavor[] flavors = new DataFlavor[0];
    private static final boolean RETRY_ON_FAILURE = true;
    private static final boolean BAIL_ON_FAILURE = false;

    private native long[] getClipboardFormats(long var1);

    private native byte[] getClipboardData(long var1, long var3) throws IOException;

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.flavorsToData.containsKey(dataFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClipboardTransferable(SunClipboard sunClipboard) {
        sunClipboard.openClipboard(null);
        try {
            long[] lArray = this.getClipboardFormats(sunClipboard.getID());
            if (lArray != null) {
                HashMap hashMap = new HashMap(lArray.length, 1.0f);
                Map map = DataTransferer.getInstance().getFlavorsForFormats(lArray, SunClipboard.flavorMap);
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    DataFlavor dataFlavor = (DataFlavor)iterator.next();
                    Long l2 = (Long)map.get(dataFlavor);
                    this.fetchOneFlavor(sunClipboard, dataFlavor, l2, hashMap, true);
                }
                DataTransferer.getInstance();
                this.flavors = DataTransferer.setToSortedDataFlavorArray(this.flavorsToData.keySet(), map);
            }
        }
        finally {
            sunClipboard.closeClipboard();
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        Object object = this.flavorsToData.get(dataFlavor);
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof DataFactory) {
            DataFactory dataFactory = (DataFactory)object;
            object = dataFactory.getTransferData(dataFlavor);
        }
        return object;
    }

    private boolean fetchOneFlavor(SunClipboard sunClipboard, DataFlavor dataFlavor, Long l2, HashMap hashMap, boolean bl2) {
        if (!this.flavorsToData.containsKey(dataFlavor)) {
            long l3 = l2;
            Object object = null;
            if (!hashMap.containsKey(l2)) {
                try {
                    object = this.getClipboardData(sunClipboard.getID(), l3);
                }
                catch (IOException iOException) {
                    object = iOException;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                hashMap.put(l2, object);
            } else {
                object = hashMap.get(l2);
            }
            if (object == null || object instanceof IOException) {
                if (!bl2) {
                    return false;
                }
                long[] lArray = DataTransferer.getInstance().getFormatsForFlavorAsArray(dataFlavor, SunClipboard.flavorMap);
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    if (lArray[i2] == l3 || !this.fetchOneFlavor(sunClipboard, dataFlavor, new Long(lArray[i2]), hashMap, false)) continue;
                    return true;
                }
            }
            if (object instanceof IOException) {
                this.flavorsToData.put(dataFlavor, object);
                return false;
            }
            if (object != null) {
                this.flavorsToData.put(dataFlavor, new DataFactory(this, l3, (byte[])object));
                return true;
            }
        }
        return false;
    }

    private final class DataFactory {
        final long format;
        final byte[] data;
        private final ClipboardTransferable this$0;

        DataFactory(ClipboardTransferable clipboardTransferable, long l2, byte[] byArray) {
            this.this$0 = clipboardTransferable;
            this.format = l2;
            this.data = byArray;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws IOException {
            return DataTransferer.getInstance().translateBytes(this.data, dataFlavor, this.format, this.this$0);
        }
    }
}

