/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import javax.swing.SpringLayout;

public abstract class Spring {
    public static final int UNSET = Integer.MIN_VALUE;

    double getStrain() {
        double d2 = this.getValue() - this.getPreferredValue();
        return d2 / this.range(this.getValue() < this.getPreferredValue());
    }

    public abstract int getMaximumValue();

    public abstract int getMinimumValue();

    public abstract int getPreferredValue();

    public abstract int getValue();

    protected Spring() {
    }

    void setStrain(double d2) {
        this.setValue(this.getPreferredValue() + (int)(d2 * this.range(d2 < 0.0)));
    }

    public abstract void setValue(int var1);

    private double range(boolean bl2) {
        return bl2 ? (double)(this.getPreferredValue() - this.getMinimumValue()) : (double)(this.getMaximumValue() - this.getPreferredValue());
    }

    public static Spring constant(int n2) {
        return Spring.constant(n2, n2, n2);
    }

    public static Spring constant(int n2, int n3, int n4) {
        return new StaticSpring(n2, n3, n4);
    }

    boolean isCyclic(SpringLayout springLayout) {
        return false;
    }

    public static Spring minus(Spring spring) {
        return new NegativeSpring(spring);
    }

    static Spring difference(Spring spring, Spring spring2) {
        return Spring.sum(spring, Spring.minus(spring2));
    }

    public static Spring max(Spring spring, Spring spring2) {
        return new MaxSpring(spring, spring2);
    }

    public static Spring sum(Spring spring, Spring spring2) {
        return new SumSpring(spring, spring2);
    }

    static abstract class AbstractSpring
    extends Spring {
        protected int size = Integer.MIN_VALUE;

        public int getValue() {
            return this.size != Integer.MIN_VALUE ? this.size : this.getPreferredValue();
        }

        AbstractSpring() {
        }

        protected void clear() {
            this.size = Integer.MIN_VALUE;
        }

        public void setValue(int n2) {
            if (n2 == Integer.MIN_VALUE) {
                this.clear();
                return;
            }
            this.size = n2;
        }
    }

    static abstract class CompoundSpring
    extends StaticSpring {
        protected Spring s1;
        protected Spring s2;

        public int getMaximumValue() {
            if (this.max == Integer.MIN_VALUE) {
                this.max = this.op(this.s1.getMaximumValue(), this.s2.getMaximumValue());
            }
            return this.max;
        }

        public int getMinimumValue() {
            if (this.min == Integer.MIN_VALUE) {
                this.min = this.op(this.s1.getMinimumValue(), this.s2.getMinimumValue());
            }
            return this.min;
        }

        public int getPreferredValue() {
            if (this.pref == Integer.MIN_VALUE) {
                this.pref = this.op(this.s1.getPreferredValue(), this.s2.getPreferredValue());
            }
            return this.pref;
        }

        public int getValue() {
            if (this.size == Integer.MIN_VALUE) {
                this.size = this.op(this.s1.getValue(), this.s2.getValue());
            }
            return this.size;
        }

        protected void clear() {
            this.size = Integer.MIN_VALUE;
            this.max = Integer.MIN_VALUE;
            this.pref = Integer.MIN_VALUE;
            this.min = Integer.MIN_VALUE;
        }

        public void setValue(int n2) {
            if (n2 == Integer.MIN_VALUE && this.size != Integer.MIN_VALUE) {
                super.setValue(n2);
                this.s1.setValue(Integer.MIN_VALUE);
                this.s2.setValue(Integer.MIN_VALUE);
                return;
            }
            super.setValue(n2);
        }

        protected abstract int op(int var1, int var2);

        public String toString() {
            return "CompoundSpring of " + this.s1 + " and " + this.s2;
        }

        boolean isCyclic(SpringLayout springLayout) {
            return springLayout.isCyclic(this.s1) || springLayout.isCyclic(this.s2);
        }

        public CompoundSpring(Spring spring, Spring spring2) {
            this.clear();
            this.s1 = spring;
            this.s2 = spring2;
        }
    }

    private static class MaxSpring
    extends CompoundSpring {
        public void setValue(int n2) {
            super.setValue(n2);
            if (n2 == Integer.MIN_VALUE) {
                return;
            }
            if (this.s1.getPreferredValue() < this.s2.getPreferredValue()) {
                this.s1.setValue(Math.min(n2, this.s1.getPreferredValue()));
                this.s2.setValue(n2);
            } else {
                this.s1.setValue(n2);
                this.s2.setValue(Math.min(n2, this.s2.getPreferredValue()));
            }
        }

        protected int op(int n2, int n3) {
            return Math.max(n2, n3);
        }

        public MaxSpring(Spring spring, Spring spring2) {
            super(spring, spring2);
        }
    }

    private static class NegativeSpring
    extends Spring {
        private Spring s;

        public int getMaximumValue() {
            return -this.s.getMinimumValue();
        }

        public int getMinimumValue() {
            return -this.s.getMaximumValue();
        }

        public int getPreferredValue() {
            return -this.s.getPreferredValue();
        }

        public int getValue() {
            return -this.s.getValue();
        }

        public void setValue(int n2) {
            this.s.setValue(-n2);
        }

        public NegativeSpring(Spring spring) {
            this.s = spring;
        }

        boolean isCyclic(SpringLayout springLayout) {
            return this.s.isCyclic(springLayout);
        }
    }

    private static class StaticSpring
    extends AbstractSpring {
        protected int min;
        protected int pref;
        protected int max;

        public int getMaximumValue() {
            return this.max;
        }

        public int getMinimumValue() {
            return this.min;
        }

        public int getPreferredValue() {
            return this.pref;
        }

        public StaticSpring() {
        }

        public StaticSpring(int n2) {
            this(n2, n2, n2);
        }

        public StaticSpring(int n2, int n3, int n4) {
            this.min = n2;
            this.pref = n3;
            this.max = n4;
            this.size = n3;
        }

        public String toString() {
            return "StaticSpring [" + this.min + ", " + this.pref + ", " + this.max + "]";
        }
    }

    private static class SumSpring
    extends CompoundSpring {
        public void setValue(int n2) {
            super.setValue(n2);
            if (n2 == Integer.MIN_VALUE) {
                return;
            }
            this.s1.setStrain(this.getStrain());
            this.s2.setValue(n2 - this.s1.getValue());
        }

        protected int op(int n2, int n3) {
            return n2 + n3;
        }

        public SumSpring(Spring spring, Spring spring2) {
            super(spring, spring2);
        }
    }
}

