/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.util.SecurityConstants;

public class ProtectionDomain {
    private CodeSource codesource;
    private ClassLoader classloader;
    private Principal[] principals;
    private PermissionCollection permissions;
    private boolean staticPermissions;

    private boolean seeAllp() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.security.debug"));
            if (string != null) {
                return true;
            }
            try {
                securityManager.checkPermission(SecurityConstants.GET_POLICY_PERMISSION);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    public String toString() {
        Serializable serializable;
        String string = "<no principals>";
        if (this.principals != null && this.principals.length > 0) {
            serializable = new StringBuffer("(principals ");
            for (int i2 = 0; i2 < this.principals.length; ++i2) {
                ((StringBuffer)serializable).append(this.principals[i2].getClass().getName() + " \"" + this.principals[i2].getName() + "\"");
                if (i2 < this.principals.length - 1) {
                    ((StringBuffer)serializable).append(",\n");
                    continue;
                }
                ((StringBuffer)serializable).append(")\n");
            }
            string = ((StringBuffer)serializable).toString();
        }
        serializable = Policy.isSet() && this.seeAllp() ? this.mergePermissions() : this.getPermissions();
        return "ProtectionDomain  " + this.codesource + "\n" + " " + this.classloader + "\n" + " " + string + "\n" + " " + serializable + "\n";
    }

    public final CodeSource getCodeSource() {
        return this.codesource;
    }

    public boolean implies(Permission permission) {
        if (!this.staticPermissions && Policy.getPolicyNoCheck().implies(this, permission)) {
            return true;
        }
        if (this.permissions != null) {
            return this.permissions.implies(permission);
        }
        return false;
    }

    public final PermissionCollection getPermissions() {
        return this.permissions;
    }

    private PermissionCollection mergePermissions() {
        Permission permission;
        Enumeration enumeration;
        if (this.staticPermissions) {
            return this.permissions;
        }
        PermissionCollection permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(this){
            private final ProtectionDomain this$0;

            public Object run() {
                Policy policy = Policy.getPolicyNoCheck();
                return policy.getPermissions(this.this$0);
            }
            {
                this.this$0 = protectionDomain;
            }
        });
        Permissions permissions = new Permissions();
        int n2 = 32;
        int n3 = 8;
        Vector vector = new Vector(n3);
        Vector vector2 = new Vector(n2);
        if (this.permissions != null) {
            enumeration = this.permissions.elements();
            while (enumeration.hasMoreElements()) {
                permission = (Permission)enumeration.nextElement();
                vector.add(permission);
            }
        }
        if (permissionCollection != null) {
            enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                vector2.add(enumeration.nextElement());
                ++n3;
            }
        }
        if (permissionCollection != null && this.permissions != null) {
            enumeration = this.permissions.elements();
            block2: while (enumeration.hasMoreElements()) {
                permission = (Permission)enumeration.nextElement();
                for (int i2 = 0; i2 < vector2.size(); ++i2) {
                    Permission permission2 = (Permission)vector2.elementAt(i2);
                    if (!permission.getClass().isInstance(permission2) || !permission.getName().equals(permission2.getName()) || !permission.getActions().equals(permission2.getActions())) continue;
                    vector2.remove(i2);
                    continue block2;
                }
            }
        }
        if (permissionCollection != null) {
            for (int i3 = vector2.size() - 1; i3 >= 0; --i3) {
                permissions.add((Permission)vector2.elementAt(i3));
            }
        }
        if (this.permissions != null) {
            for (int i4 = vector.size() - 1; i4 >= 0; --i4) {
                permissions.add((Permission)vector.elementAt(i4));
            }
        }
        return permissions;
    }

    public final Principal[] getPrincipals() {
        return (Principal[])this.principals.clone();
    }

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
        }
        this.classloader = null;
        this.principals = new Principal[0];
        this.staticPermissions = true;
    }

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection, ClassLoader classLoader, Principal[] principalArray) {
        this.codesource = codeSource;
        if (permissionCollection != null) {
            this.permissions = permissionCollection;
            this.permissions.setReadOnly();
        }
        this.classloader = classLoader;
        this.principals = principalArray != null ? (Principal[])principalArray.clone() : new Principal[]{};
        this.staticPermissions = false;
    }
}

