/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class GridLayout
implements LayoutManager,
Serializable {
    int hgap;
    int vgap;
    int rows;
    int cols;

    public int getColumns() {
        return this.cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getRows() {
        return this.rows;
    }

    public int getVgap() {
        return this.vgap;
    }

    public GridLayout() {
        this(1, 0, 0, 0);
    }

    public void setColumns(int n2) {
        if (n2 == 0 && this.rows == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.cols = n2;
    }

    public void setHgap(int n2) {
        this.hgap = n2;
    }

    public void setRows(int n2) {
        if (n2 == 0 && this.cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = n2;
    }

    public void setVgap(int n2) {
        this.vgap = n2;
    }

    public GridLayout(int n2, int n3) {
        this(n2, n3, 0, 0);
    }

    public GridLayout(int n2, int n3, int n4, int n5) {
        if (n2 == 0 && n3 == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = n2;
        this.cols = n3;
        this.hgap = n4;
        this.vgap = n5;
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = this.rows;
            int n4 = this.cols;
            boolean bl2 = container.getComponentOrientation().isLeftToRight();
            if (n2 == 0) {
                return;
            }
            if (n3 > 0) {
                n4 = (n2 + n3 - 1) / n3;
            } else {
                n3 = (n2 + n4 - 1) / n4;
            }
            int n5 = container.width - (insets.left + insets.right);
            int n6 = container.height - (insets.top + insets.bottom);
            n5 = (n5 - (n4 - 1) * this.hgap) / n4;
            n6 = (n6 - (n3 - 1) * this.vgap) / n3;
            if (bl2) {
                int n7 = 0;
                int n8 = insets.left;
                while (n7 < n4) {
                    int n9 = 0;
                    int n10 = insets.top;
                    while (n9 < n3) {
                        int n11 = n9 * n4 + n7;
                        if (n11 < n2) {
                            container.getComponent(n11).setBounds(n8, n10, n5, n6);
                        }
                        ++n9;
                        n10 += n6 + this.vgap;
                    }
                    ++n7;
                    n8 += n5 + this.hgap;
                }
            } else {
                int n12 = 0;
                int n13 = container.width - insets.right - n5;
                while (n12 < n4) {
                    int n14 = 0;
                    int n15 = insets.top;
                    while (n14 < n3) {
                        int n16 = n14 * n4 + n12;
                        if (n16 < n2) {
                            container.getComponent(n16).setBounds(n13, n15, n5, n6);
                        }
                        ++n14;
                        n15 += n6 + this.vgap;
                    }
                    ++n12;
                    n13 -= n5 + this.hgap;
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }

    public void addLayoutComponent(String string, Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = this.rows;
            int n4 = this.cols;
            if (n3 > 0) {
                n4 = (n2 + n3 - 1) / n3;
            } else {
                n3 = (n2 + n4 - 1) / n4;
            }
            int n5 = 0;
            int n6 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = container.getComponent(i2);
                Dimension dimension = component.getMinimumSize();
                if (n5 < dimension.width) {
                    n5 = dimension.width;
                }
                if (n6 >= dimension.height) continue;
                n6 = dimension.height;
            }
            return new Dimension(insets.left + insets.right + n4 * n5 + (n4 - 1) * this.hgap, insets.top + insets.bottom + n3 * n6 + (n3 - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = this.rows;
            int n4 = this.cols;
            if (n3 > 0) {
                n4 = (n2 + n3 - 1) / n3;
            } else {
                n3 = (n2 + n4 - 1) / n4;
            }
            int n5 = 0;
            int n6 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = container.getComponent(i2);
                Dimension dimension = component.getPreferredSize();
                if (n5 < dimension.width) {
                    n5 = dimension.width;
                }
                if (n6 >= dimension.height) continue;
                n6 = dimension.height;
            }
            return new Dimension(insets.left + insets.right + n4 * n5 + (n4 - 1) * this.hgap, insets.top + insets.bottom + n3 * n6 + (n3 - 1) * this.vgap);
        }
    }
}

