/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.CRLExtensions;
import sun.security.x509.CRLReasonCodeExtension;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.SerialNumber;

public class X509CRLEntryImpl
extends X509CRLEntry {
    private SerialNumber serialNumber = null;
    private Date revocationDate = null;
    private CRLExtensions extensions = null;
    private byte[] revokedCert = null;
    private static final boolean isExplicit = false;
    private static final long YR_2050 = 2524636800000L;

    private X509CRLEntryImpl() {
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    public byte[] getEncoded() throws CRLException {
        if (this.revokedCert == null) {
            this.encode(new DerOutputStream());
        }
        return (byte[])this.revokedCert.clone();
    }

    public X509CRLEntryImpl(byte[] byArray) throws CRLException {
        try {
            this.parse(new DerValue(byArray));
        }
        catch (IOException iOException) {
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    public Integer getReasonCode() throws IOException {
        Extension extension = this.getExtension(PKIXExtensions.ReasonCode_Id);
        if (extension == null) {
            return null;
        }
        CRLReasonCodeExtension cRLReasonCodeExtension = (CRLReasonCodeExtension)extension;
        return (Integer)cRLReasonCodeExtension.get("reason");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.serialNumber.toString());
        stringBuffer.append("  On: " + this.revocationDate.toString());
        if (this.extensions != null) {
            Collection collection = this.extensions.getAllExtensions();
            Object[] objectArray = collection.toArray();
            stringBuffer.append("\n    CRL Entry Extensions: " + objectArray.length);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                stringBuffer.append("\n    [" + (i2 + 1) + "]: ");
                Extension extension = (Extension)objectArray[i2];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuffer.append(extension.toString());
                        byte[] byArray = extension.getExtensionValue();
                        if (byArray == null) continue;
                        DerOutputStream derOutputStream = new DerOutputStream();
                        derOutputStream.putOctetString(byArray);
                        byArray = derOutputStream.toByteArray();
                        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                        stringBuffer.append("Extension unknown: DER encoded OCTET string =\n" + hexDumpEncoder.encodeBuffer(byArray) + "\n");
                        continue;
                    }
                    stringBuffer.append(extension.toString());
                    continue;
                }
                catch (Exception exception) {
                    stringBuffer.append(", Error parsing this extension");
                }
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public byte[] getExtensionValue(String string) {
        if (this.extensions == null) {
            return null;
        }
        try {
            Object object;
            Object object2;
            String string2 = OIDMap.getName(new ObjectIdentifier(string));
            Object object3 = null;
            if (string2 == null) {
                object2 = new ObjectIdentifier(string);
                object = null;
                Enumeration enumeration = this.extensions.getElements();
                while (enumeration.hasMoreElements()) {
                    object = (Extension)enumeration.nextElement();
                    ObjectIdentifier objectIdentifier = ((Extension)object).getExtensionId();
                    if (!objectIdentifier.equals((ObjectIdentifier)object2)) continue;
                    object3 = object;
                    break;
                }
            } else {
                object3 = this.extensions.get(string2);
            }
            if (object3 == null) {
                return null;
            }
            object2 = ((Extension)object3).getExtensionValue();
            if (object2 == null) {
                return null;
            }
            object = new DerOutputStream();
            ((DerOutputStream)object).putOctetString((byte[])object2);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber.getNumber();
    }

    public Date getRevocationDate() {
        return new Date(this.revocationDate.getTime());
    }

    public Set getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        HashSet hashSet = new HashSet(11);
        Enumeration enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (!extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        return hashSet;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        HashSet hashSet = new HashSet(11);
        Enumeration enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        return hashSet;
    }

    public void encode(DerOutputStream derOutputStream) throws CRLException {
        try {
            if (this.revokedCert == null) {
                DerOutputStream derOutputStream2 = new DerOutputStream();
                this.serialNumber.encode(derOutputStream2);
                if (this.revocationDate.getTime() < 2524636800000L) {
                    derOutputStream2.putUTCTime(this.revocationDate);
                } else {
                    derOutputStream2.putGeneralizedTime(this.revocationDate);
                }
                if (this.extensions != null) {
                    this.extensions.encode(derOutputStream2, false);
                }
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream2);
                this.revokedCert = derOutputStream3.toByteArray();
            }
            derOutputStream.write(this.revokedCert);
        }
        catch (IOException iOException) {
            throw new CRLException("Encoding error: " + iOException.toString());
        }
    }

    public X509CRLEntryImpl(DerValue derValue) throws CRLException {
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            this.revokedCert = null;
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    private void parse(DerValue derValue) throws CRLException, IOException {
        if (derValue.tag != 48) {
            throw new CRLException("Invalid encoded RevokedCertificate, starting sequence tag missing.");
        }
        if (derValue.data.available() == 0) {
            throw new CRLException("No data encoded for RevokedCertificates");
        }
        this.revokedCert = derValue.toByteArray();
        DerInputStream derInputStream = derValue.toDerInputStream();
        DerValue derValue2 = derInputStream.getDerValue();
        this.serialNumber = new SerialNumber(derValue2);
        int n2 = derValue.data.peekByte();
        if ((byte)n2 == 23) {
            this.revocationDate = derValue.data.getUTCTime();
        } else if ((byte)n2 == 24) {
            this.revocationDate = derValue.data.getGeneralizedTime();
        } else {
            throw new CRLException("Invalid encoding for revocation date");
        }
        if (derValue.data.available() == 0) {
            return;
        }
        this.extensions = new CRLExtensions(derValue.toDerInputStream());
    }

    public X509CRLEntryImpl(BigInteger bigInteger, Date date) {
        this.serialNumber = new SerialNumber(bigInteger);
        this.revocationDate = date;
    }

    public Extension getExtension(ObjectIdentifier objectIdentifier) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.get(OIDMap.getName(objectIdentifier));
    }

    public static X509CRLEntryImpl toImpl(X509CRLEntry x509CRLEntry) throws CRLException {
        if (x509CRLEntry instanceof X509CRLEntryImpl) {
            return (X509CRLEntryImpl)x509CRLEntry;
        }
        return new X509CRLEntryImpl(x509CRLEntry.getEncoded());
    }

    public X509CRLEntryImpl(BigInteger bigInteger, Date date, CRLExtensions cRLExtensions) {
        this.serialNumber = new SerialNumber(bigInteger);
        this.revocationDate = date;
        this.extensions = cRLExtensions;
    }
}

