/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.security.util.Cache;

class MemoryCache
extends Cache {
    private static final float LOAD_FACTOR = 0.75f;
    private static final boolean DEBUG = false;
    private final Map cacheMap;
    private final int maxSize;
    private final int lifetime;
    private final ReferenceQueue queue;

    public synchronized int size() {
        this.expungeExpiredEntries();
        return this.cacheMap.size();
    }

    public synchronized void clear() {
        if (this.queue != null) {
            Iterator iterator = this.cacheMap.values().iterator();
            while (iterator.hasNext()) {
                CacheEntry cacheEntry = (CacheEntry)iterator.next();
                cacheEntry.invalidate();
            }
            while (this.queue.poll() != null) {
            }
        }
        this.cacheMap.clear();
    }

    private void emptyQueue() {
        CacheEntry cacheEntry;
        if (this.queue == null) {
            return;
        }
        int n2 = this.cacheMap.size();
        while ((cacheEntry = (CacheEntry)((Object)this.queue.poll())) != null) {
            CacheEntry cacheEntry2;
            Object object = cacheEntry.getKey();
            if (object == null || (cacheEntry2 = (CacheEntry)this.cacheMap.remove(object)) == null || cacheEntry == cacheEntry2) continue;
            this.cacheMap.put(object, cacheEntry2);
        }
    }

    private void expungeExpiredEntries() {
        this.emptyQueue();
        if (this.lifetime == 0) {
            return;
        }
        int n2 = 0;
        long l2 = System.currentTimeMillis();
        Iterator iterator = this.cacheMap.values().iterator();
        while (iterator.hasNext()) {
            CacheEntry cacheEntry = (CacheEntry)iterator.next();
            if (cacheEntry.isValid(l2)) continue;
            iterator.remove();
            ++n2;
        }
    }

    public MemoryCache(boolean bl2, int n2) {
        this(bl2, n2, 0);
    }

    public MemoryCache(boolean bl2, int n2, int n3) {
        this.maxSize = n2;
        this.lifetime = n3 * 1000;
        this.queue = bl2 ? new ReferenceQueue() : null;
        int n4 = (int)((float)n2 / 0.75f) + 1;
        this.cacheMap = new LinkedHashMap(n4, 0.75f, true);
    }

    public synchronized void remove(Object object) {
        this.emptyQueue();
        CacheEntry cacheEntry = (CacheEntry)this.cacheMap.remove(object);
        if (cacheEntry != null) {
            cacheEntry.invalidate();
        }
    }

    public synchronized Object get(Object object) {
        long l2;
        this.emptyQueue();
        CacheEntry cacheEntry = (CacheEntry)this.cacheMap.get(object);
        if (cacheEntry == null) {
            return null;
        }
        long l3 = l2 = this.lifetime == 0 ? 0L : System.currentTimeMillis();
        if (!cacheEntry.isValid(l2)) {
            this.cacheMap.remove(object);
            return null;
        }
        return cacheEntry.getValue();
    }

    public synchronized void put(Object object, Object object2) {
        this.emptyQueue();
        long l2 = this.lifetime == 0 ? 0L : System.currentTimeMillis() + (long)this.lifetime;
        CacheEntry cacheEntry = this.newEntry(object, object2, l2, this.queue);
        CacheEntry cacheEntry2 = (CacheEntry)this.cacheMap.put(object, cacheEntry);
        if (cacheEntry2 != null) {
            cacheEntry2.invalidate();
            return;
        }
        if (this.cacheMap.size() > this.maxSize) {
            this.expungeExpiredEntries();
            if (this.cacheMap.size() > this.maxSize) {
                Iterator iterator = this.cacheMap.values().iterator();
                CacheEntry cacheEntry3 = (CacheEntry)iterator.next();
                iterator.remove();
                cacheEntry3.invalidate();
            }
        }
    }

    protected CacheEntry newEntry(Object object, Object object2, long l2, ReferenceQueue referenceQueue) {
        if (referenceQueue != null) {
            return new SoftCacheEntry(object, object2, l2, referenceQueue);
        }
        return new HardCacheEntry(object, object2, l2);
    }

    private static interface CacheEntry {
        public void invalidate();

        public boolean isValid(long var1);

        public Object getKey();

        public Object getValue();
    }

    private static class HardCacheEntry
    implements CacheEntry {
        private Object key;
        private Object value;
        private long expirationTime;

        public void invalidate() {
            this.key = null;
            this.value = null;
            this.expirationTime = -1L;
        }

        public boolean isValid(long l2) {
            boolean bl2;
            boolean bl3 = bl2 = l2 <= this.expirationTime;
            if (!bl2) {
                this.invalidate();
            }
            return bl2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        HardCacheEntry(Object object, Object object2, long l2) {
            this.key = object;
            this.value = object2;
            this.expirationTime = l2;
        }
    }

    private static class SoftCacheEntry
    extends SoftReference
    implements CacheEntry {
        private Object key;
        private long expirationTime;

        public void invalidate() {
            this.clear();
            this.key = null;
            this.expirationTime = -1L;
        }

        public boolean isValid(long l2) {
            boolean bl2;
            boolean bl3 = bl2 = l2 <= this.expirationTime && this.get() != null;
            if (!bl2) {
                this.invalidate();
            }
            return bl2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.get();
        }

        SoftCacheEntry(Object object, Object object2, long l2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
            this.expirationTime = l2;
        }
    }
}

