/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.InputStream;
import sun.net.www.MessageHeader;
import sun.net.www.http.HttpClient;
import sun.net.www.http.Hurryable;

public class ChunkedInputStream
extends InputStream
implements Hurryable {
    private InputStream in;
    private HttpClient hc;
    private MessageHeader responses;
    private int chunkSize;
    private int chunkRead;
    private byte[] chunkData = new byte[4096];
    private int chunkPos;
    private int chunkCount;
    private byte[] rawData = new byte[32];
    private int rawPos;
    private int rawCount;
    private boolean error;
    private boolean closed;
    static final int STATE_AWAITING_CHUNK_HEADER = 1;
    static final int STATE_READING_CHUNK = 2;
    static final int STATE_AWAITING_CHUNK_EOL = 3;
    static final int STATE_AWAITING_TRAILERS = 4;
    static final int STATE_DONE = 5;
    private int state;

    public synchronized int available() throws IOException {
        this.ensureOpen();
        int n2 = this.chunkCount - this.chunkPos;
        if (n2 > 0) {
            return n2;
        }
        n2 = this.readAhead(false);
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.chunkPos >= this.chunkCount && this.readAhead(true) <= 0) {
            return -1;
        }
        return this.chunkData[this.chunkPos++] & 0xFF;
    }

    private int readAheadBlocking() throws IOException {
        do {
            int n2;
            if (this.state == 5) {
                return -1;
            }
            this.ensureRawAvailable(32);
            try {
                n2 = this.in.read(this.rawData, this.rawCount, this.rawData.length - this.rawCount);
            }
            catch (IOException iOException) {
                this.error = true;
                throw iOException;
            }
            if (n2 < 0) {
                this.error = true;
                throw new IOException("Premature EOF");
            }
            this.rawCount += n2;
            this.processRaw();
        } while (this.chunkCount <= 0);
        return this.chunkCount - this.chunkPos;
    }

    private int readAheadNonBlocking() throws IOException {
        int n2 = this.in.available();
        if (n2 > 0) {
            int n3;
            this.ensureRawAvailable(n2);
            try {
                n3 = this.in.read(this.rawData, this.rawCount, n2);
            }
            catch (IOException iOException) {
                this.error = true;
                throw iOException;
            }
            if (n3 < 0) {
                this.error = true;
                return -1;
            }
            this.rawCount += n3;
            this.processRaw();
        }
        return this.chunkCount - this.chunkPos;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closeUnderlying();
        this.closed = true;
    }

    private void closeUnderlying() throws IOException {
        if (this.in == null) {
            return;
        }
        if (!this.error && this.state == 5) {
            this.hc.finished();
        } else if (!this.hurry()) {
            this.hc.closeServer();
        }
        this.in = null;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
    }

    private void processRaw() throws IOException {
        while (this.state != 5) {
            switch (this.state) {
                case 1: {
                    int n2;
                    int n3;
                    for (n3 = this.rawPos; n3 < this.rawCount && this.rawData[n3] != 10; ++n3) {
                    }
                    if (n3 >= this.rawCount) {
                        return;
                    }
                    String string = new String(this.rawData, this.rawPos, n3 - this.rawPos + 1);
                    for (n2 = 0; n2 < string.length() && Character.digit(string.charAt(n2), 16) != -1; ++n2) {
                    }
                    try {
                        this.chunkSize = Integer.parseInt(string.substring(0, n2), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.error = true;
                        throw new IOException("Bogus chunk size");
                    }
                    this.rawPos = n3 + 1;
                    this.chunkRead = 0;
                    if (this.chunkSize > 0) {
                        this.state = 2;
                        break;
                    }
                    this.state = 4;
                    break;
                }
                case 2: {
                    Object object;
                    if (this.rawPos >= this.rawCount) {
                        return;
                    }
                    int n4 = Math.min(this.chunkSize - this.chunkRead, this.rawCount - this.rawPos);
                    if (this.chunkData.length < this.chunkCount + n4) {
                        int n5 = this.chunkCount - this.chunkPos;
                        if (this.chunkData.length < n5 + n4) {
                            object = new byte[n5 + n4];
                            System.arraycopy(this.chunkData, this.chunkPos, object, 0, n5);
                            this.chunkData = object;
                        } else {
                            System.arraycopy(this.chunkData, this.chunkPos, this.chunkData, 0, n5);
                        }
                        this.chunkPos = 0;
                        this.chunkCount = n5;
                    }
                    System.arraycopy(this.rawData, this.rawPos, this.chunkData, this.chunkCount, n4);
                    this.rawPos += n4;
                    this.chunkCount += n4;
                    this.chunkRead += n4;
                    if (this.chunkSize - this.chunkRead <= 0) {
                        this.state = 3;
                        break;
                    }
                    return;
                }
                case 3: {
                    if (this.rawPos + 1 >= this.rawCount) {
                        return;
                    }
                    if (this.rawData[this.rawPos] != 13) {
                        this.error = true;
                        throw new IOException("missing CR");
                    }
                    if (this.rawData[this.rawPos + 1] != 10) {
                        this.error = true;
                        throw new IOException("missing LF");
                    }
                    this.rawPos += 2;
                    this.state = 1;
                    break;
                }
                case 4: {
                    int n3;
                    for (n3 = this.rawPos; n3 < this.rawCount && this.rawData[n3] != 10; ++n3) {
                    }
                    if (n3 >= this.rawCount) {
                        return;
                    }
                    if (n3 == this.rawPos) {
                        this.error = true;
                        throw new IOException("LF should be proceeded by CR");
                    }
                    if (this.rawData[n3 - 1] != 13) {
                        this.error = true;
                        throw new IOException("LF should be proceeded by CR");
                    }
                    if (n3 == this.rawPos + 1) {
                        this.state = 5;
                        this.closeUnderlying();
                        return;
                    }
                    String string = new String(this.rawData, this.rawPos, n3 - this.rawPos);
                    int n2 = string.indexOf(58);
                    if (n2 == -1) {
                        throw new IOException("Malformed tailer - format should be key:value");
                    }
                    Object object = string.substring(0, n2).trim();
                    String string2 = string.substring(n2 + 1, string.length()).trim();
                    this.responses.add((String)object, string2);
                    this.rawPos = n3 + 1;
                }
            }
        }
    }

    public synchronized boolean hurry() {
        if (this.in == null || this.error) {
            return false;
        }
        try {
            this.readAhead(false);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.error) {
            return false;
        }
        return this.state == 5;
    }

    private void ensureRawAvailable(int n2) {
        if (this.rawCount + n2 > this.rawData.length) {
            int n3 = this.rawCount - this.rawPos;
            if (n3 + n2 > this.rawData.length) {
                byte[] byArray = new byte[n3 + n2];
                if (n3 > 0) {
                    System.arraycopy(this.rawData, this.rawPos, byArray, 0, n3);
                }
                this.rawData = byArray;
            } else if (n3 > 0) {
                System.arraycopy(this.rawData, this.rawPos, this.rawData, 0, n3);
            }
            this.rawCount = n3;
            this.rawPos = 0;
        }
    }

    private int readAhead(boolean bl2) throws IOException {
        if (this.state == 5) {
            return -1;
        }
        if (this.chunkPos >= this.chunkCount) {
            this.chunkCount = 0;
            this.chunkPos = 0;
        }
        if (bl2) {
            return this.readAheadBlocking();
        }
        return this.readAheadNonBlocking();
    }

    private int fastRead(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = this.chunkSize - this.chunkRead;
        int n6 = n4 = n5 < n3 ? n5 : n3;
        if (n4 > 0) {
            int n7;
            try {
                n7 = this.in.read(byArray, n2, n4);
            }
            catch (IOException iOException) {
                this.error = true;
                throw iOException;
            }
            if (n7 > 0) {
                this.chunkRead += n7;
                if (this.chunkRead >= this.chunkSize) {
                    this.state = 3;
                }
                return n7;
            }
            this.error = true;
            throw new IOException("Premature EOF");
        }
        return 0;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.chunkCount - this.chunkPos;
        if (n4 <= 0) {
            if (this.state == 2) {
                return this.fastRead(byArray, n2, n3);
            }
            n4 = this.readAhead(true);
            if (n4 < 0) {
                return -1;
            }
        }
        int n5 = n4 < n3 ? n4 : n3;
        System.arraycopy(this.chunkData, this.chunkPos, byArray, n2, n5);
        this.chunkPos += n5;
        return n5;
    }

    public ChunkedInputStream(InputStream inputStream, HttpClient httpClient, MessageHeader messageHeader) throws IOException {
        this.in = inputStream;
        this.responses = messageHeader;
        this.hc = httpClient;
        this.state = 1;
    }
}

