/*
 * Decompiled with CFR 0.152.
 */
package sun.net.dns;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import sun.net.dns.OptionsImpl;
import sun.net.dns.ResolverConfiguration;
import sun.security.action.LoadLibraryAction;

public class ResolverConfigurationImpl
extends ResolverConfiguration {
    private static Object lock;
    private static long lastRefresh;
    private static final int TIMEOUT = 300000;
    private final ResolverConfiguration.Options opts = new OptionsImpl();
    private LinkedList searchlist;
    private LinkedList nameservers;
    static final boolean $assertionsDisabled;
    static Class class$sun$net$dns$ResolverConfigurationImpl;

    static {
        $assertionsDisabled = !(class$sun$net$dns$ResolverConfigurationImpl == null ? (class$sun$net$dns$ResolverConfigurationImpl = ResolverConfigurationImpl.class$("sun.net.dns.ResolverConfigurationImpl")) : class$sun$net$dns$ResolverConfigurationImpl).desiredAssertionStatus();
        lock = new Object();
        lastRefresh = -1L;
        AccessController.doPrivileged(new LoadLibraryAction("net"));
    }

    ResolverConfigurationImpl() {
    }

    private void loadConfig() {
        long l2;
        if (!$assertionsDisabled && !Thread.holdsLock(lock)) {
            throw new AssertionError();
        }
        if (lastRefresh >= 0L && (l2 = System.currentTimeMillis()) - lastRefresh < 300000L) {
            return;
        }
        this.nameservers = (LinkedList)AccessController.doPrivileged(new PrivilegedAction(this){
            private final ResolverConfigurationImpl this$0;

            public Object run() {
                return ResolverConfigurationImpl.access$000(this.this$0, "nameserver", 1, 5);
            }
            {
                this.this$0 = resolverConfigurationImpl;
            }
        });
        this.searchlist = this.getSearchList();
        lastRefresh = System.currentTimeMillis();
    }

    static native String fallbackDomain0();

    static native String localDomain0();

    private LinkedList getSearchList() {
        LinkedList linkedList = (LinkedList)AccessController.doPrivileged(new PrivilegedAction(this){
            private final ResolverConfigurationImpl this$0;

            public Object run() {
                LinkedList linkedList = ResolverConfigurationImpl.access$000(this.this$0, "search", 6, 1);
                if (linkedList.size() > 0) {
                    return linkedList;
                }
                return null;
            }
            {
                this.this$0 = resolverConfigurationImpl;
            }
        });
        if (linkedList != null) {
            return linkedList;
        }
        String string = ResolverConfigurationImpl.localDomain0();
        if (string != null && string.length() > 0) {
            linkedList = new LinkedList();
            linkedList.add(string);
            return linkedList;
        }
        linkedList = (LinkedList)AccessController.doPrivileged(new PrivilegedAction(this){
            private final ResolverConfigurationImpl this$0;

            public Object run() {
                LinkedList linkedList = ResolverConfigurationImpl.access$000(this.this$0, "domain", 1, 1);
                if (linkedList.size() > 0) {
                    return linkedList;
                }
                return null;
            }
            {
                this.this$0 = resolverConfigurationImpl;
            }
        });
        if (linkedList != null) {
            return linkedList;
        }
        linkedList = new LinkedList();
        String string2 = ResolverConfigurationImpl.fallbackDomain0();
        if (string2 != null && string2.length() > 0) {
            linkedList.add(string2);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List nameservers() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)this.nameservers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List searchlist() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)this.searchlist.clone();
        }
    }

    public ResolverConfiguration.Options options() {
        return this.opts;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private LinkedList resolvconf(String string, int n2, int n3) {
        LinkedList linkedList = new LinkedList();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader("/etc/resolv.conf"));
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                String string4;
                int n4 = n2;
                if (string2.length() == 0 || string2.charAt(0) == '#' || string2.charAt(0) == ';' || !string2.startsWith(string) || (string4 = string2.substring(string.length())).length() == 0 || string4.charAt(0) != ' ' && string4.charAt(0) != '\t') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, " \t");
                while (stringTokenizer.hasMoreTokens() && (string3 = stringTokenizer.nextToken()).charAt(0) != '#' && string3.charAt(0) != ';') {
                    linkedList.add(string3);
                    if (--n4 != 0) continue;
                }
                if (--n3 != 0) continue;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return linkedList;
    }

    static LinkedList access$000(ResolverConfigurationImpl resolverConfigurationImpl, String string, int n2, int n3) {
        return resolverConfigurationImpl.resolvconf(string, n2, n3);
    }
}

