/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.ScrollPaneAdjustable;
import java.awt.peer.ScrollPanePeer;
import sun.awt.DebugHelper;
import sun.awt.PeerEvent;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MToolkit;

class MScrollPanePeer
extends MPanelPeer
implements ScrollPanePeer {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$motif$MScrollPanePeer == null ? (class$sun$awt$motif$MScrollPanePeer = MScrollPanePeer.class$("sun.awt.motif.MScrollPanePeer")) : class$sun$awt$motif$MScrollPanePeer);
    static final int UNIT_INCREMENT = 0;
    static final int BLOCK_INCREMENT = 1;
    boolean ignore;
    static final int MARGIN = 1;
    static final int SCROLLBAR = 16;
    int hsbSpace;
    int vsbSpace;
    int vval;
    int hval;
    int vmax;
    int hmax;
    static Class class$sun$awt$motif$MScrollPanePeer;

    public int getHScrollbarHeight() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        if (scrollPane.getScrollbarDisplayPolicy() == 2) {
            return 0;
        }
        return this.pGetScrollbarSpace(0);
    }

    public int getVScrollbarWidth() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        if (scrollPane.getScrollbarDisplayPolicy() == 2) {
            return 0;
        }
        return this.pGetScrollbarSpace(1);
    }

    native int pGetShadow();

    static {
        MScrollPanePeer.initIDs();
    }

    private static native void initIDs();

    void scrollPaneInit() {
        Adjustable adjustable;
        this.ignore = false;
        ScrollPane scrollPane = (ScrollPane)this.target;
        Adjustable adjustable2 = scrollPane.getVAdjustable();
        if (adjustable2 != null) {
            this.pSetIncrement(1, 0, adjustable2.getUnitIncrement());
        }
        if ((adjustable = scrollPane.getHAdjustable()) != null) {
            this.pSetIncrement(0, 0, adjustable.getUnitIncrement());
        }
        super.pSetScrollbarBackground(scrollPane.getBackground());
    }

    native int pGetBlockIncrement(int var1);

    native int pGetScrollbarSpace(int var1);

    public void childResized(int n2, int n3) {
        if (((ScrollPane)this.target).getScrollbarDisplayPolicy() != 2) {
            ScrollPane scrollPane = (ScrollPane)this.target;
            Adjustable adjustable = scrollPane.getVAdjustable();
            Adjustable adjustable2 = scrollPane.getHAdjustable();
            this.pSetIncrement(1, 0, adjustable.getUnitIncrement());
            this.pSetIncrement(0, 0, adjustable2.getUnitIncrement());
            this.pSetIncrement(1, 1, adjustable.getBlockIncrement());
            this.pSetIncrement(0, 1, adjustable2.getBlockIncrement());
        }
    }

    public native void setScrollPosition(int var1, int var2);

    native void pSetIncrement(int var1, int var2, int var3);

    private void postScrollEvent(int n2, int n3, int n4, boolean bl2) {
        Adjustor adjustor = new Adjustor(this, n2, n3, n4, bl2);
        MToolkit.executeOnEventHandlerThread(new ScrollEvent(this, this.target, adjustor));
    }

    public void setUnitIncrement(Adjustable adjustable, int n2) {
        ScrollPane scrollPane = (ScrollPane)this.target;
        if (scrollPane.getScrollbarDisplayPolicy() != 2) {
            this.pSetIncrement(adjustable.getOrientation(), 0, n2);
        }
    }

    public void setValue(Adjustable adjustable, int n2) {
        if (!this.ignore) {
            Component component = this.getScrollChild();
            Point point = component.getLocation();
            switch (adjustable.getOrientation()) {
                case 1: {
                    this.setScrollPosition(-point.x, n2);
                    break;
                }
                case 0: {
                    this.setScrollPosition(n2, -point.y);
                }
            }
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.pSetScrollbarBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.pSetInnerForeground(color);
    }

    private Component getScrollChild() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        if (scrollPane.countComponents() > 0) {
            return scrollPane.getComponent(0);
        }
        throw new NullPointerException("child is null");
    }

    MScrollPanePeer(Component component) {
        this.init(component);
        this.scrollPaneInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        Graphics graphics2;
        int n2;
        ScrollPane scrollPane = (ScrollPane)this.target;
        Dimension dimension = scrollPane.size();
        Color color = scrollPane.getBackground();
        Color color2 = scrollPane.getForeground();
        Point point = scrollPane.getScrollPosition();
        Component component = this.getScrollChild();
        Dimension dimension2 = component.size();
        int n3 = scrollPane.getScrollbarDisplayPolicy();
        switch (n3) {
            case 2: {
                this.vsbSpace = 0;
                this.hsbSpace = 0;
                break;
            }
            case 1: {
                this.vsbSpace = 16;
                this.hsbSpace = 16;
                break;
            }
            case 0: {
                this.hsbSpace = dimension2.width <= dimension.width - 2 ? 0 : 16;
                int n4 = this.vsbSpace = dimension2.height <= dimension.height - 2 ? 0 : 16;
                if (this.hsbSpace == 0 && this.vsbSpace != 0) {
                    int n5 = this.hsbSpace = dimension2.width <= dimension.width - 16 - 2 ? 0 : 16;
                }
                if (this.vsbSpace != 0 || this.hsbSpace == 0) break;
                this.vsbSpace = dimension2.height <= dimension.height - 16 - 2 ? 0 : 16;
            }
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (this.vsbSpace > 0) {
            n11 = 0;
            n13 = dimension.height - 2 - this.hsbSpace;
            n9 = Math.max(dimension2.height - n13, 0);
            n7 = point.y;
        }
        if (this.hsbSpace > 0) {
            n10 = 0;
            n12 = dimension.width - 2 - this.vsbSpace;
            n8 = Math.max(dimension2.width - n12, 0);
            n6 = point.x;
        }
        int n14 = dimension.width - this.vsbSpace;
        int n15 = dimension.height - this.hsbSpace;
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.hsbSpace > 0) {
            n2 = dimension.width - this.vsbSpace;
            graphics.fillRect(1, dimension.height - 16 - 3, n2 - 1, 13);
            graphics2 = graphics.create();
            try {
                graphics2.translate(0, dimension.height - 14);
                this.drawScrollbar(graphics2, color, 14, n2, n10, n8, n6, n12, true);
            }
            finally {
                graphics2.dispose();
            }
        }
        if (this.vsbSpace > 0) {
            n2 = dimension.height - this.hsbSpace;
            graphics.fillRect(dimension.width - 16 - 3, 1, 13, n2 - 1);
            graphics2 = graphics.create();
            try {
                graphics2.translate(dimension.width - 14, 0);
                this.drawScrollbar(graphics2, color, 14, n2, n11, n9, n7, n13, false);
            }
            finally {
                graphics2.dispose();
            }
        }
        this.draw3DRect(graphics, color, 0, 0, n14 - 1, n15 - 1, false);
        this.target.print(graphics);
        scrollPane.printComponents(graphics);
    }

    public Insets insets() {
        Dimension dimension;
        ScrollPane scrollPane = (ScrollPane)this.target;
        Dimension dimension2 = scrollPane.size();
        try {
            Component component = this.getScrollChild();
            dimension = component.size();
        }
        catch (NullPointerException nullPointerException) {
            dimension = new Dimension(0, 0);
        }
        return this.pInsets(dimension2.width, dimension2.height, dimension.width, dimension.height);
    }

    native Insets pInsets(int var1, int var2, int var3, int var4);

    static DebugHelper access$000() {
        return dbg;
    }

    native void create(MComponentPeer var1);

    native void pSetScrollChild(MComponentPeer var1);

    public void setScrollChild(MComponentPeer mComponentPeer) {
        this.pSetScrollChild(mComponentPeer);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    MScrollPanePeer(Component component, Object object) {
        this.init(component, object);
        this.scrollPaneInit();
    }

    class Adjustor
    implements Runnable {
        int orient;
        int type;
        int pos;
        boolean isAdjusting;
        private final MScrollPanePeer this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ScrollPane scrollPane = (ScrollPane)this.this$0.target;
            ScrollPaneAdjustable scrollPaneAdjustable = null;
            if (this.orient == 1) {
                scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getVAdjustable();
            } else if (this.orient == 0) {
                scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getHAdjustable();
            } else {
                MScrollPanePeer.access$000();
            }
            if (scrollPaneAdjustable == null) {
                return;
            }
            int n2 = scrollPaneAdjustable.getValue();
            switch (this.type) {
                case 2: {
                    n2 -= scrollPaneAdjustable.getUnitIncrement();
                    break;
                }
                case 1: {
                    n2 += scrollPaneAdjustable.getUnitIncrement();
                    break;
                }
                case 3: {
                    n2 -= scrollPaneAdjustable.getBlockIncrement();
                    break;
                }
                case 4: {
                    n2 += scrollPaneAdjustable.getBlockIncrement();
                    break;
                }
                case 5: {
                    n2 = this.pos;
                    break;
                }
                default: {
                    MScrollPanePeer.access$000();
                    return;
                }
            }
            n2 = Math.max(scrollPaneAdjustable.getMinimum(), n2);
            n2 = Math.min(scrollPaneAdjustable.getMaximum(), n2);
            try {
                this.this$0.ignore = true;
                scrollPaneAdjustable.setValueIsAdjusting(this.isAdjusting);
                scrollPaneAdjustable.setValue(n2);
            }
            finally {
                this.this$0.ignore = false;
            }
        }

        Adjustor(MScrollPanePeer mScrollPanePeer, int n2, int n3, int n4, boolean bl2) {
            this.this$0 = mScrollPanePeer;
            this.orient = n2;
            this.type = n3;
            this.pos = n4;
            this.isAdjusting = bl2;
        }
    }

    class ScrollEvent
    extends PeerEvent {
        private final MScrollPanePeer this$0;

        public PeerEvent coalesceEvents(PeerEvent peerEvent) {
            MScrollPanePeer.access$000();
            if (peerEvent instanceof ScrollEvent) {
                return peerEvent;
            }
            return null;
        }

        ScrollEvent(MScrollPanePeer mScrollPanePeer, Object object, Runnable runnable) {
            this.this$0 = mScrollPanePeer;
            super(object, runnable, 0L);
        }
    }
}

