/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.List;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.peer.ListPeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;

class MListPeer
extends MComponentPeer
implements ListPeer {
    static final int MARGIN = 2;
    static final int SPACE = 1;
    static final int SCROLLBAR = 16;
    int fontHeight;
    int fontAscent;
    int fontLeading;
    int vval;
    int hval;
    int vmax;
    int hmax;

    public void clear() {
        List list = (List)this.target;
        int n2 = list.countItems();
        if (n2 > 0) {
            this.delItems(0, n2 - 1);
        }
    }

    void initialize() {
        int n2;
        List list = (List)this.target;
        int n3 = list.countItems();
        for (n2 = 0; n2 < n3; ++n2) {
            this.addItem(list.getItem(n2), -1);
        }
        this.setMultipleSelections(list.allowsMultipleSelections());
        n2 = list.getVisibleIndex();
        if (n2 >= 0) {
            this.makeVisible(n2);
        }
        int[] nArray = list.getSelectedIndexes();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.select(nArray[i2]);
        }
        if (n3 == 0) {
            this.addItem(" ", 0);
            this.delItems(0, 0);
        }
        super.pSetScrollbarBackground(MListPeer.getParent_NoClientCode(list).getBackground());
        if (!this.target.isBackgroundSet()) {
            this.target.setBackground(SystemColor.text);
        }
        if (!this.target.isForegroundSet()) {
            this.target.setForeground(SystemColor.textText);
        }
        super.initialize();
    }

    public void removeAll() {
        this.clear();
    }

    public boolean handlesWheelScrolling() {
        return true;
    }

    public boolean isFocusable() {
        return true;
    }

    public int[] getSelectedIndexes() {
        List list = (List)this.target;
        int n2 = list.countItems();
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.isSelected(i2)) continue;
            nArray[n3++] = i2;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public native void deselect(int var1);

    public void handleListChanged(int n2) {
        MListPeer mListPeer = this;
        List list = (List)this.target;
        int n3 = n2;
        MToolkit.executeOnEventHandlerThread(list, new Runnable(this, mListPeer, n3, list){
            private final MListPeer val$listPeer;
            private final int val$listIndex;
            private final List val$list;
            private final MListPeer this$0;

            public void run() {
                int[] nArray = this.val$listPeer.getSelectedIndexes();
                boolean bl2 = false;
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    if (this.val$listIndex != nArray[i2]) continue;
                    bl2 = true;
                    break;
                }
                this.this$0.postEvent(new ItemEvent(this.val$list, 701, new Integer(this.val$listIndex), bl2 ? 1 : 2));
            }
            {
                this.this$0 = mListPeer;
                this.val$listPeer = mListPeer2;
                this.val$listIndex = n2;
                this.val$list = list;
            }
        });
    }

    public native void makeVisible(int var1);

    public native void select(int var1);

    public native boolean isSelected(int var1);

    public native void delItems(int var1, int var2);

    native void nativeHandleMouseWheel(int var1, int var2, int var3);

    public void action(int n2, long l2, int n3) {
        List list = (List)this.target;
        int n4 = n2;
        MToolkit.executeOnEventHandlerThread(list, new Runnable(this, list, n4, l2, n3){
            private final List val$list;
            private final int val$selectIndex;
            private final long val$when;
            private final int val$modifiers;
            private final MListPeer this$0;

            public void run() {
                this.val$list.select(this.val$selectIndex);
                this.this$0.postEvent(new ActionEvent(this.this$0.target, 1001, this.val$list.getItem(this.val$selectIndex), this.val$when, this.val$modifiers));
            }
            {
                this.this$0 = mListPeer;
                this.val$list = list;
                this.val$selectIndex = n2;
                this.val$when = l2;
                this.val$modifiers = n3;
            }
        });
    }

    int itemsInWindow(boolean bl2) {
        Dimension dimension = this.target.size();
        int n2 = bl2 ? dimension.height - 20 : dimension.height - 4;
        int n3 = this.fontHeight - this.fontLeading;
        return n2 / (n3 + 2);
    }

    public void setMultipleMode(boolean bl2) {
        this.setMultipleSelections(bl2);
    }

    public native void setMultipleSelections(boolean var1);

    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 507) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
            this.nativeHandleMouseWheel(mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        } else {
            super.handleEvent(aWTEvent);
        }
    }

    public native void setBackground(Color var1);

    public void setForeground(Color color) {
        this.pSetInnerForeground(color);
    }

    public Dimension minimumSize() {
        return this.minimumSize(4);
    }

    public Dimension getMinimumSize(int n2) {
        return this.minimumSize(n2);
    }

    public Dimension getPreferredSize(int n2) {
        return this.preferredSize(n2);
    }

    public Dimension minimumSize(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(((List)this.target).getFont());
        return new Dimension(20 + fontMetrics.stringWidth("0123456789abcde"), (fontMetrics.getHeight() + 2) * n2 + 4);
    }

    public Dimension preferredSize(int n2) {
        return this.minimumSize(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        List list = (List)this.target;
        Dimension dimension = list.size();
        Color color = list.getBackground();
        Color color2 = list.getForeground();
        int n5 = list.getItemCount();
        FontMetrics fontMetrics = this.getFontMetrics(list.getFont());
        int n6 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            int n7 = fontMetrics.stringWidth(list.getItem(n4));
            n6 = Math.max(n6, n7);
        }
        this.fontHeight = fontMetrics.getHeight();
        this.fontAscent = fontMetrics.getAscent();
        this.fontLeading = fontMetrics.getLeading();
        int n8 = 0;
        int n9 = 0;
        int n10 = this.itemsInWindow(true);
        this.vmax = Math.max(n5 - n10, 0);
        int n11 = dimension.height - 16;
        if (this.vmax != 0) {
            n3 = dimension.width - 16;
            n2 = n3 - 6;
            this.hmax = Math.max(n6 - n2, 0);
        } else {
            n3 = dimension.width;
            n2 = n3 - 6;
            this.hmax = Math.max(n6 - n2, 0);
        }
        if (this.hmax == 0) {
            n11 = dimension.height;
            n10 = this.itemsInWindow(false);
            this.vmax = Math.max(n5 - n10, 0);
        }
        if (this.vmax == 0) {
            n3 = dimension.width;
            n2 = n3 - 6;
            this.hmax = Math.max(n6 - n2, 0);
        }
        this.hval = 0;
        this.vval = 0;
        graphics.setColor(color);
        graphics.fillRect(0, 0, n3, n11);
        if (this.hmax != 0) {
            n4 = dimension.width - (this.vmax == 0 ? 0 : 16);
            graphics.fillRect(1, dimension.height - 16 - 3, n4 - 1, 13);
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(0, dimension.height - 14);
                this.drawScrollbar(graphics2, color, 14, n4, n9, this.hmax, this.hval, n2, true);
            }
            finally {
                graphics2.dispose();
            }
        }
        if (this.vmax != 0) {
            n4 = dimension.height - (this.hmax == 0 ? 0 : 16);
            graphics.fillRect(dimension.width - 16 - 3, 1, 13, n4 - 1);
            Graphics graphics3 = graphics.create();
            try {
                graphics3.translate(dimension.width - 14, 0);
                this.drawScrollbar(graphics3, color, 14, n4, n8, this.vmax, this.vval, n10, false);
            }
            finally {
                graphics3.dispose();
            }
        }
        this.draw3DRect(graphics, color, 0, 0, n3 - 1, n11 - 1, false);
        if (n5 > 0) {
            n4 = this.itemsInWindow(this.hmax != 0);
            int n12 = Math.min(n5 - 1, this.vval + n4 - 1);
            this.paintItems(graphics, color, color2, this.vval, n12);
        }
        this.target.print(graphics);
    }

    MListPeer(List list) {
        super(list);
    }

    public void add(String string, int n2) {
        this.addItem(string, n2);
    }

    public native void addItem(String var1, int var2);

    native void create(MComponentPeer var1);

    void paintItems(Graphics graphics, Color color, Color color2, int n2, int n3) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.paintItem(graphics, color, color2, i2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintItem(Graphics graphics, Color color, Color color2, int n2, boolean bl2) {
        List list = (List)this.target;
        Dimension dimension = list.size();
        int n3 = list.getItemCount();
        Color color3 = color.darker();
        if (n2 < this.vval || n2 >= this.vval + this.itemsInWindow(this.hmax != 0)) {
            return;
        }
        int n4 = dimension.width - (4 + (this.vmax != 0 ? 16 : 0));
        int n5 = this.fontHeight - this.fontLeading;
        int n6 = n5 + 2;
        int n7 = 2 + n2 * n6 + 1;
        int n8 = n7 - this.vval * n6;
        int n9 = 3;
        Graphics graphics2 = graphics.create();
        try {
            if (n2 > n3 - 1) {
                graphics2.setColor(color);
                graphics2.fillRect(n9 - 2, n8 - 2, n4, n5 + 4);
                return;
            }
            if (bl2) {
                graphics2.setColor(color3);
                graphics2.fillRect(n9 - 1, n8 - 1, n4 - 2, n5 + 2);
            } else {
                graphics2.setColor(color);
                graphics2.fillRect(n9 - 1, n8 - 1, n4 - 2, n5 + 2);
            }
            graphics2.setColor(color);
            graphics2.drawRect(n9 - 2, n8 - 2, n4 - 1, n5 + 3);
            graphics2.setColor(color2);
            String string = list.getItem(n2);
            graphics2.clipRect(n9, n8, n4 - 2, n5);
            graphics2.drawString(string, n9 - this.hval, n8 + this.fontAscent);
        }
        finally {
            graphics2.dispose();
        }
    }
}

