/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Enumeration;
import java.util.Stack;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class ElementIterator
implements Cloneable {
    private Element root;
    private Stack elementStack = null;

    public int depth() {
        if (this.elementStack == null) {
            return 0;
        }
        return this.elementStack.size();
    }

    private void dumpTree() {
        Element element;
        while ((element = this.next()) != null) {
            System.out.println("elem: " + element.getName());
            AttributeSet attributeSet = element.getAttributes();
            String string = "";
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = attributeSet.getAttribute(object);
                if (object2 instanceof AttributeSet) {
                    string = string + object + "=**AttributeSet** ";
                    continue;
                }
                string = string + object + "=" + object2 + " ";
            }
            System.out.println("attributes: " + string);
        }
    }

    public synchronized Object clone() {
        try {
            ElementIterator elementIterator = new ElementIterator(this.root);
            if (this.elementStack != null) {
                elementIterator.elementStack = new Stack();
                for (int i2 = 0; i2 < this.elementStack.size(); ++i2) {
                    StackItem stackItem = (StackItem)this.elementStack.elementAt(i2);
                    StackItem stackItem2 = (StackItem)stackItem.clone();
                    elementIterator.elementStack.push(stackItem2);
                }
            }
            return elementIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public ElementIterator(Document document) {
        this.root = document.getDefaultRootElement();
    }

    public Element current() {
        if (this.elementStack == null) {
            return this.first();
        }
        if (!this.elementStack.empty()) {
            StackItem stackItem = (StackItem)this.elementStack.peek();
            Element element = StackItem.access$100(stackItem);
            int n2 = StackItem.access$200(stackItem);
            if (n2 == -1) {
                return element;
            }
            return element.getElement(n2);
        }
        return null;
    }

    public Element first() {
        if (this.root == null) {
            return null;
        }
        this.elementStack = new Stack();
        if (this.root.getElementCount() != 0) {
            this.elementStack.push(new StackItem(this, this.root, null));
        }
        return this.root;
    }

    public Element next() {
        if (this.elementStack == null) {
            return this.first();
        }
        if (this.elementStack.isEmpty()) {
            return null;
        }
        StackItem stackItem = (StackItem)this.elementStack.peek();
        Element element = StackItem.access$100(stackItem);
        int n2 = StackItem.access$200(stackItem);
        if (n2 + 1 < element.getElementCount()) {
            Element element2 = element.getElement(n2 + 1);
            if (element2.isLeaf()) {
                StackItem.access$300(stackItem);
            } else {
                this.elementStack.push(new StackItem(this, element2, null));
            }
            return element2;
        }
        this.elementStack.pop();
        if (!this.elementStack.isEmpty()) {
            StackItem stackItem2 = (StackItem)this.elementStack.peek();
            StackItem.access$300(stackItem2);
            return this.next();
        }
        return null;
    }

    public Element previous() {
        int n2;
        if (this.elementStack == null || (n2 = this.elementStack.size()) == 0) {
            return null;
        }
        StackItem stackItem = (StackItem)this.elementStack.peek();
        Element element = StackItem.access$100(stackItem);
        int n3 = StackItem.access$200(stackItem);
        if (n3 > 0) {
            return this.getDeepestLeaf(element.getElement(--n3));
        }
        if (n3 == 0) {
            return element;
        }
        if (n3 == -1) {
            if (n2 == 1) {
                return null;
            }
            Object object = this.elementStack.pop();
            stackItem = (StackItem)this.elementStack.peek();
            this.elementStack.push(object);
            element = StackItem.access$100(stackItem);
            n3 = StackItem.access$200(stackItem);
            return n3 == -1 ? element : this.getDeepestLeaf(element.getElement(n3));
        }
        return null;
    }

    public ElementIterator(Element element) {
        this.root = element;
    }

    private Element getDeepestLeaf(Element element) {
        if (element.isLeaf()) {
            return element;
        }
        int n2 = element.getElementCount();
        if (n2 == 0) {
            return element;
        }
        return this.getDeepestLeaf(element.getElement(n2 - 1));
    }

    static class 1 {
    }

    private class StackItem
    implements Cloneable {
        Element item;
        int childIndex;
        private final ElementIterator this$0;

        private int getIndex() {
            return this.childIndex;
        }

        private void incrementIndex() {
            ++this.childIndex;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        private Element getElement() {
            return this.item;
        }

        static int access$200(StackItem stackItem) {
            return stackItem.getIndex();
        }

        static void access$300(StackItem stackItem) {
            stackItem.incrementIndex();
        }

        private StackItem(ElementIterator elementIterator, Element element) {
            this.this$0 = elementIterator;
            this.item = element;
            this.childIndex = -1;
        }

        static Element access$100(StackItem stackItem) {
            return stackItem.getElement();
        }

        StackItem(ElementIterator elementIterator, Element element, 1 var3_3) {
            this(elementIterator, element);
        }
    }
}

