/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyImpl;

public class KerberosKey
implements SecretKey,
Destroyable {
    private KerberosPrincipal principal;
    private int versionNum;
    private KeyImpl key;
    private transient boolean destroyed = false;

    public final int getKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getKeyType();
    }

    public final int getVersionNumber() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.versionNum;
    }

    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.key.destroy();
            this.principal = null;
            this.destroyed = true;
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getEncoded();
    }

    public final String getAlgorithm() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getAlgorithm();
    }

    public final String getFormat() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getFormat();
    }

    public String toString() {
        return "Kerberos Principal " + this.principal.toString() + "Key Version " + this.versionNum + "key " + this.key.toString();
    }

    public final KerberosPrincipal getPrincipal() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.principal;
    }

    public KerberosKey(KerberosPrincipal kerberosPrincipal, byte[] byArray, int n2, int n3) {
        this.principal = kerberosPrincipal;
        this.versionNum = n3;
        this.key = new KeyImpl(byArray, n2);
    }

    public KerberosKey(KerberosPrincipal kerberosPrincipal, char[] cArray, String string) {
        this.principal = kerberosPrincipal;
        this.key = new KeyImpl(kerberosPrincipal, cArray, string);
    }
}

