/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.DirectAudioDeviceProvider;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

class DirectAudioDevice
extends AbstractMixer {
    private static final int CLIP_BUFFER_TIME = 1000;
    private static final int DEFAULT_LINE_BUFFER_TIME = 500;
    private int deviceCountOpened = 0;
    private int deviceCountStarted = 0;
    static Class class$javax$sound$sampled$Clip;
    static Class class$javax$sound$sampled$SourceDataLine;
    static Class class$javax$sound$sampled$TargetDataLine;
    static Class class$com$sun$media$sound$DirectAudioDevice$DirectSDL;
    static Class class$com$sun$media$sound$DirectAudioDevice$DirectClip;
    static Class class$com$sun$media$sound$DirectAudioDevice$DirectTDL;

    int getDeviceID() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getDeviceID();
    }

    int getMaxSimulLines() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getMaxSimulLines();
    }

    int getMixerIndex() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getIndex();
    }

    protected void implClose() {
    }

    protected void implOpen() throws LineUnavailableException {
    }

    protected void implStart() {
    }

    protected void implStop() {
    }

    static long access$400(int n2, int n3, boolean bl2, int n4, float f2, int n5, int n6, int n7, boolean bl3, boolean bl4, int n8) throws LineUnavailableException {
        return DirectAudioDevice.nOpen(n2, n3, bl2, n4, f2, n5, n6, n7, bl3, bl4, n8);
    }

    private static native long nOpen(int var0, int var1, boolean var2, int var3, float var4, int var5, int var6, int var7, boolean var8, boolean var9, int var10) throws LineUnavailableException;

    static int access$500(long l2, boolean bl2) {
        return DirectAudioDevice.nGetBufferSize(l2, bl2);
    }

    static int access$900(long l2, boolean bl2) {
        return DirectAudioDevice.nAvailable(l2, bl2);
    }

    private static native int nAvailable(long var0, boolean var2);

    private static native int nGetBufferSize(long var0, boolean var2);

    static void access$1100(long l2, boolean bl2) {
        DirectAudioDevice.nFlush(l2, bl2);
    }

    static void access$600(long l2, boolean bl2) {
        DirectAudioDevice.nStart(l2, bl2);
    }

    static void access$700(long l2, boolean bl2) {
        DirectAudioDevice.nStop(l2, bl2);
    }

    static void access$800(long l2, boolean bl2) {
        DirectAudioDevice.nClose(l2, bl2);
    }

    private static native void nClose(long var0, boolean var2);

    private static native void nFlush(long var0, boolean var2);

    private static native void nStart(long var0, boolean var2);

    private static native void nStop(long var0, boolean var2);

    static boolean access$1000(long l2, boolean bl2) {
        return DirectAudioDevice.nIsStillDraining(l2, bl2);
    }

    private static native boolean nIsStillDraining(long var0, boolean var2);

    static long access$1200(long l2, boolean bl2, long l3) {
        return DirectAudioDevice.nGetBytePosition(l2, bl2, l3);
    }

    private static native long nGetBytePosition(long var0, boolean var2, long var3);

    static int access$1300(long l2, byte[] byArray, int n2, int n3, int n4) {
        return DirectAudioDevice.nWrite(l2, byArray, n2, n3, n4);
    }

    static int access$1400(long l2, byte[] byArray, int n2, int n3, int n4) {
        return DirectAudioDevice.nRead(l2, byArray, n2, n3, n4);
    }

    private static native int nRead(long var0, byte[] var2, int var3, int var4, int var5);

    private static native int nWrite(long var0, byte[] var2, int var3, int var4, int var5);

    DirectAudioDevice(DirectAudioDeviceProvider.DirectAudioDeviceInfo directAudioDeviceInfo) {
        super(directAudioDeviceInfo, null, null, null);
        DataLine.Info info = this.createDataLineInfo(true);
        if (info != null) {
            this.sourceLineInfo = new Line.Info[2];
            this.sourceLineInfo[0] = info;
            this.sourceLineInfo[1] = new DirectDLI(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = DirectAudioDevice.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, info.getFormats(), 32, -1, null);
        } else {
            this.sourceLineInfo = new Line.Info[0];
        }
        DataLine.Info info2 = this.createDataLineInfo(false);
        if (info2 != null) {
            this.targetLineInfo = new Line.Info[1];
            this.targetLineInfo[0] = info2;
        } else {
            this.targetLineInfo = new Line.Info[0];
        }
    }

    private static native void nGetFormats(int var0, int var1, boolean var2, Vector var3);

    private static void addFormat(Vector vector, int n2, int n3, int n4, float f2, int n5, boolean bl2, boolean bl3) {
        AudioFormat.Encoding encoding = null;
        switch (n5) {
            case 0: {
                encoding = bl2 ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
                break;
            }
            case 1: {
                encoding = AudioFormat.Encoding.ULAW;
                if (n2 == 8) break;
                n2 = 8;
                n3 = n4;
                break;
            }
            case 2: {
                encoding = AudioFormat.Encoding.ALAW;
                if (n2 == 8) break;
                n2 = 8;
                n3 = n4;
            }
        }
        if (encoding == null) {
            return;
        }
        if (n3 <= 0) {
            n3 = (n2 + 7) / 8 * n4;
        }
        vector.add(new AudioFormat(encoding, f2, n2, n4, n3, f2, bl3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataLine.Info createDataLineInfo(boolean bl2) {
        Vector vector = new Vector();
        AudioFormat[] audioFormatArray = null;
        Vector vector2 = vector;
        synchronized (vector2) {
            DirectAudioDevice.nGetFormats(this.getMixerIndex(), this.getDeviceID(), bl2, vector);
            if (vector.size() > 0) {
                audioFormatArray = new AudioFormat[vector.size()];
                for (int i2 = 0; i2 < audioFormatArray.length; ++i2) {
                    audioFormatArray[i2] = (AudioFormat)vector.elementAt(i2);
                }
            }
        }
        if (audioFormatArray != null) {
            Class clazz = bl2 ? (class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = DirectAudioDevice.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine) : (class$javax$sound$sampled$TargetDataLine == null ? (class$javax$sound$sampled$TargetDataLine = DirectAudioDevice.class$("javax.sound.sampled.TargetDataLine")) : class$javax$sound$sampled$TargetDataLine);
            return new DirectDLI(clazz, audioFormatArray, 32, -1, null);
        }
        return null;
    }

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof DataLine.Info) {
            return this.getMaxSimulLines();
        }
        return 0;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected static AudioFormat getSignOrEndianChangedFormat(AudioFormat audioFormat) {
        boolean bl2 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        boolean bl3 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
        if (audioFormat.getFrameSize() > 1 && bl2) {
            return new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), !audioFormat.isBigEndian());
        }
        if (audioFormat.getFrameSize() == 1 && (bl2 || bl3)) {
            return new AudioFormat(bl2 ? AudioFormat.Encoding.PCM_UNSIGNED : AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian());
        }
        return null;
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info2 instanceof DataLine.Info) {
            DataLine.Info info3 = (DataLine.Info)info;
            DataLine.Info info4 = (DataLine.Info)info2;
            if (info3.getLineClass().isAssignableFrom(class$com$sun$media$sound$DirectAudioDevice$DirectSDL == null ? (class$com$sun$media$sound$DirectAudioDevice$DirectSDL = DirectAudioDevice.class$("com.sun.media.sound.DirectAudioDevice$DirectSDL")) : class$com$sun$media$sound$DirectAudioDevice$DirectSDL)) {
                return new DirectSDL(info4, this, null);
            }
            if (info3.getLineClass().isAssignableFrom(class$com$sun$media$sound$DirectAudioDevice$DirectClip == null ? (class$com$sun$media$sound$DirectAudioDevice$DirectClip = DirectAudioDevice.class$("com.sun.media.sound.DirectAudioDevice$DirectClip")) : class$com$sun$media$sound$DirectAudioDevice$DirectClip)) {
                return new DirectClip(info4, this, null);
            }
            if (info3.getLineClass().isAssignableFrom(class$com$sun$media$sound$DirectAudioDevice$DirectTDL == null ? (class$com$sun$media$sound$DirectAudioDevice$DirectTDL = DirectAudioDevice.class$("com.sun.media.sound.DirectAudioDevice$DirectTDL")) : class$com$sun$media$sound$DirectAudioDevice$DirectTDL)) {
                return new DirectTDL(info4, this, null);
            }
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    static class 1 {
    }

    private static class DirectBAOS
    extends ByteArrayOutputStream {
        public byte[] getInternalBuffer() {
            return this.buf;
        }
    }

    private static class DirectClip
    extends DirectDL
    implements Clip,
    Runnable,
    AutoClosingClip {
        private Thread thread;
        private byte[] audioData = null;
        private int frameSize;
        private int m_lengthInFrames;
        private int loopCount;
        private int clipBytePosition;
        private int newFramePosition;
        private int loopStartFrame;
        private int loopEndFrame;
        private boolean autoclosing = false;

        public int getFrameLength() {
            return this.m_lengthInFrames;
        }

        public int getFramePosition() {
            return super.getFramePosition();
        }

        public long getMicrosecondLength() {
            return Toolkit.frames2micros(this.getFormat(), this.getFrameLength());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void implClose() {
            Thread thread = this.thread;
            this.thread = null;
            this.doIO = false;
            if (thread != null) {
                DirectClip directClip = this;
                synchronized (directClip) {
                    this.notifyAll();
                }
                try {
                    thread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.implClose();
            this.audioData = null;
            this.newFramePosition = -1;
            this.getEventDispatcher().autoClosingClipClosed(this);
        }

        void implStart() {
            super.implStart();
            if (this.thread != null && !this.thread.isAlive()) {
                this.thread.start();
            }
        }

        void implStop() {
            super.implStop();
            this.loopCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.thread != null) {
                if (!this.doIO) {
                    DirectClip directClip = this;
                    synchronized (directClip) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                while (this.doIO) {
                    long l2;
                    int n2;
                    int n3;
                    if (this.newFramePosition >= 0) {
                        this.clipBytePosition = this.newFramePosition * this.frameSize;
                        this.newFramePosition = -1;
                    }
                    int n4 = this.getFrameLength() - 1;
                    if (this.loopCount > 0 || this.loopCount == -1) {
                        n4 = this.loopEndFrame;
                    }
                    if ((n3 = (n2 = (int)((long)n4 - (l2 = (long)(this.clipBytePosition / this.frameSize)) + 1L)) * this.frameSize) > this.getBufferSize()) {
                        n3 = Toolkit.align(this.getBufferSize(), this.frameSize);
                    }
                    int n5 = this.write(this.audioData, this.clipBytePosition, n3);
                    if (!this.doIO || this.newFramePosition >= 0 || n5 < 0) continue;
                    this.clipBytePosition += n5;
                    l2 = this.clipBytePosition / this.frameSize;
                    if (l2 <= (long)n4) continue;
                    if (this.loopCount > 0 || this.loopCount == -1) {
                        --this.loopCount;
                        this.newFramePosition = this.loopStartFrame;
                        continue;
                    }
                    this.drain();
                    this.stop();
                }
            }
        }

        public synchronized boolean isAutoClosing() {
            return this.autoclosing;
        }

        public void loop(int n2) {
            this.loopCount = n2;
            this.start();
        }

        public void setFramePosition(int n2) {
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= this.getFrameLength()) {
                n2 = this.getFrameLength();
            }
            if (this.doIO) {
                this.newFramePosition = n2;
            } else {
                this.bytePosition = n2 * this.frameSize;
            }
            this.flush();
        }

        public void setLoopPoints(int n2, int n3) {
            if (n2 < 0) {
                throw new IllegalArgumentException("illegal value for start: " + n2);
            }
            if (n3 >= this.getFrameLength()) {
                throw new IllegalArgumentException("illegal value for end: " + n3);
            }
            if (n3 == -1) {
                n3 = this.getFrameLength() - 1;
            }
            if (n3 < n2) {
                throw new IllegalArgumentException("End position " + n3 + "  preceeds start position " + n2);
            }
            this.loopStartFrame = n2;
            this.loopEndFrame = n3;
        }

        public synchronized void setMicrosecondPosition(long l2) {
            long l3 = Toolkit.micros2frames(this.getFormat(), l2);
            this.setFramePosition((int)l3);
        }

        public synchronized void setAutoClosing(boolean bl2) {
            if (bl2 != this.autoclosing) {
                if (this.isOpen()) {
                    if (bl2) {
                        this.getEventDispatcher().autoClosingClipOpened(this);
                    } else {
                        this.getEventDispatcher().autoClosingClipClosed(this);
                    }
                }
                this.autoclosing = bl2;
            }
        }

        void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
            if (this.audioData == null) {
                throw new IllegalArgumentException("Illegal call to open() in interface Clip");
            }
            super.implOpen(audioFormat, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void open(AudioFormat audioFormat, byte[] byArray, int n2) throws LineUnavailableException {
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                if (this.isOpen()) {
                    throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
                }
                this.audioData = byArray;
                this.frameSize = audioFormat.getFrameSize();
                this.m_lengthInFrames = n2;
                this.bytePosition = 0L;
                this.clipBytePosition = 0;
                this.newFramePosition = -1;
                this.loopStartFrame = 0;
                this.loopEndFrame = n2 - 1;
                this.loopCount = 0;
                try {
                    this.open(audioFormat, (int)Toolkit.millis2bytes(audioFormat, 1000L));
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.audioData = null;
                    throw lineUnavailableException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.audioData = null;
                    throw illegalArgumentException;
                }
                if (this.autoclosing) {
                    this.getEventDispatcher().autoClosingClipOpened(this);
                }
                this.thread = new Thread(this, "Direct Clip");
                try {
                    this.thread.setDaemon(true);
                    this.thread.setPriority(6);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }

        public void open(AudioFormat audioFormat, byte[] byArray, int n2, int n3) throws LineUnavailableException {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            this.open(audioFormat, byArray, n3 / audioFormat.getFrameSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                byte[] byArray = null;
                if (this.isOpen()) {
                    throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
                }
                int n2 = (int)audioInputStream.getFrameLength();
                int n3 = 0;
                if (n2 != -1) {
                    int n4 = n2 * audioInputStream.getFormat().getFrameSize();
                    byArray = new byte[n4];
                    int n5 = n4;
                    int n6 = 0;
                    while (n5 > 0 && n6 >= 0) {
                        n6 = audioInputStream.read(byArray, n3, n5);
                        if (n6 > 0) {
                            n3 += n6;
                            n5 -= n6;
                            continue;
                        }
                        if (n6 != 0) continue;
                        Thread.yield();
                    }
                } else {
                    int n7 = 16384;
                    DirectBAOS directBAOS = new DirectBAOS();
                    byte[] byArray2 = new byte[n7];
                    int n8 = 0;
                    while (n8 >= 0) {
                        n8 = audioInputStream.read(byArray2, 0, byArray2.length);
                        if (n8 > 0) {
                            directBAOS.write(byArray2, 0, n8);
                            n3 += n8;
                            continue;
                        }
                        if (n8 != 0) continue;
                        Thread.yield();
                    }
                    byArray = directBAOS.getInternalBuffer();
                }
                n2 = n3 / audioInputStream.getFormat().getFrameSize();
                this.open(audioInputStream.getFormat(), byArray, n2);
            }
        }

        private DirectClip(DataLine.Info info, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), true);
        }

        DirectClip(DataLine.Info info, DirectAudioDevice directAudioDevice, 1 var3_3) {
            this(info, directAudioDevice);
        }
    }

    private static class DirectDL
    extends AbstractDataLine {
        protected int mixerIndex;
        protected int deviceID;
        protected long id;
        protected int waitTime;
        protected volatile boolean flushing = false;
        protected boolean isSource;
        protected long bytePosition;
        protected volatile boolean doIO = false;
        protected volatile boolean activeIO = false;
        protected volatile boolean stoppedWritten = false;
        protected int softwareConversionSize = 0;
        protected AudioFormat hardwareFormat;
        private JSSecurity jsSecurity = null;

        public int available() {
            if (this.id == 0L) {
                return 0;
            }
            return DirectAudioDevice.access$900(this.id, this.isSource);
        }

        public int getFramePosition() {
            long l2 = DirectAudioDevice.access$1200(this.id, this.isSource, this.bytePosition);
            if (l2 < 0L) {
                l2 = 0L;
            }
            return (int)(l2 / (long)this.getFormat().getFrameSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drain() {
            while (this.id != 0L && DirectAudioDevice.access$1000(this.id, this.isSource)) {
                DirectDL directDL = this;
                synchronized (directDL) {
                    try {
                        this.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            if (this.id != 0L) {
                this.flushing = true;
                DirectDL directDL = this;
                synchronized (directDL) {
                    this.notifyAll();
                }
                DirectAudioDevice.access$1100(this.id, this.isSource);
            }
        }

        void implClose() {
            if (!this.isSource && this.jsSecurity != null) {
                this.jsSecurity.checkRecordPermission();
            }
            this.doIO = false;
            long l2 = this.id;
            this.id = 0L;
            while (this.activeIO) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            DirectAudioDevice.access$800(l2, this.isSource);
            this.bytePosition = 0L;
            this.softwareConversionSize = 0;
        }

        void implStart() {
            if (!this.isSource && this.jsSecurity != null) {
                this.jsSecurity.checkRecordPermission();
            }
            DirectAudioDevice.access$600(this.id, this.isSource);
            this.doIO = true;
            if (this.isSource && this.stoppedWritten) {
                this.setStarted(true);
                this.setActive(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void implStop() {
            if (!this.isSource && this.jsSecurity != null) {
                this.jsSecurity.checkRecordPermission();
            }
            DirectAudioDevice.access$700(this.id, this.isSource);
            this.doIO = false;
            DirectDL directDL = this;
            synchronized (directDL) {
                this.notifyAll();
            }
            this.setActive(false);
            this.setStarted(false);
            this.stoppedWritten = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(byte[] byArray, int n2, int n3) {
            this.flushing = false;
            if (n3 == 0) {
                return 0;
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("illegal len: " + n3);
            }
            if (n3 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + n3 + " bytes, " + "frameSize = " + this.getFormat().getFrameSize() + " bytes)");
            }
            if (n2 < 0) {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
            if (n2 + n3 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException(byArray.length);
            }
            if (!this.isActive() && this.doIO) {
                this.setActive(true);
                this.setStarted(true);
            }
            int n4 = 0;
            while (!this.flushing) {
                this.activeIO = true;
                int n5 = DirectAudioDevice.access$1300(this.id, byArray, n2, n3, this.softwareConversionSize);
                this.activeIO = false;
                if (n5 < 0) break;
                this.bytePosition += (long)n5;
                n4 += n5;
                if (!this.doIO || (n3 -= n5) <= 0) break;
                n2 += n5;
                DirectDL directDL = this;
                synchronized (directDL) {
                    try {
                        this.wait(this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (n4 > 0 && !this.doIO) {
                this.stoppedWritten = true;
            }
            return n4;
        }

        void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
            AudioFormat audioFormat2;
            if (!this.isSource && this.jsSecurity != null) {
                this.jsSecurity.checkRecordPermission();
            }
            int n3 = 0;
            if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
                n3 = 1;
            } else if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
                n3 = 2;
            }
            if (n2 == -1) {
                n2 = (int)Toolkit.millis2bytes(audioFormat, 500L);
            }
            DirectDLI directDLI = null;
            if (this.info instanceof DirectDLI) {
                directDLI = (DirectDLI)this.info;
            }
            this.hardwareFormat = audioFormat;
            this.softwareConversionSize = 0;
            if (directDLI != null && !directDLI.isFormatSupportedInHardware(audioFormat) && directDLI.isFormatSupportedInHardware(audioFormat2 = DirectAudioDevice.getSignOrEndianChangedFormat(audioFormat))) {
                this.hardwareFormat = audioFormat2;
                this.softwareConversionSize = audioFormat.getFrameSize() / audioFormat.getChannels();
            }
            n2 = n2 / audioFormat.getFrameSize() * audioFormat.getFrameSize();
            this.id = DirectAudioDevice.access$400(this.mixerIndex, this.deviceID, this.isSource, n3, this.hardwareFormat.getSampleRate(), this.hardwareFormat.getSampleSizeInBits(), this.hardwareFormat.getFrameSize(), this.hardwareFormat.getChannels(), this.hardwareFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED), this.hardwareFormat.isBigEndian(), n2);
            if (this.id == 0L) {
                throw new LineUnavailableException("line with format " + audioFormat + " not supported.");
            }
            this.bufferSize = DirectAudioDevice.access$500(this.id, this.isSource);
            if (this.bufferSize < 1) {
                this.bufferSize = n2;
            }
            this.format = audioFormat;
            this.waitTime = (int)Toolkit.bytes2millis(audioFormat, this.bufferSize) / 4;
            if (this.waitTime < 1) {
                this.waitTime = 1;
            } else if (this.waitTime > 1000) {
                this.waitTime = 1000;
            }
            this.bytePosition = 0L;
            this.stoppedWritten = false;
            this.doIO = false;
        }

        protected DirectDL(DataLine.Info info, DirectAudioDevice directAudioDevice, int n2, int n3, boolean bl2) {
            super(info, (AbstractMixer)directAudioDevice, null);
            this.mixerIndex = n2;
            this.deviceID = n3;
            this.waitTime = 10;
            this.isSource = bl2;
            if (!bl2) {
                this.jsSecurity = JSSecurityManager.getJSSecurity();
            }
        }
    }

    private static class DirectDLI
    extends DataLine.Info {
        public boolean isFormatSupported(AudioFormat audioFormat) {
            return this.isFormatSupportedInHardware(audioFormat) || this.isFormatSupportedInHardware(DirectAudioDevice.getSignOrEndianChangedFormat(audioFormat));
        }

        public boolean isFormatSupportedInHardware(AudioFormat audioFormat) {
            if (audioFormat == null) {
                return false;
            }
            return super.isFormatSupported(audioFormat);
        }

        private DirectDLI(Class clazz, AudioFormat[] audioFormatArray, int n2, int n3) {
            super(clazz, audioFormatArray, n2, n3);
        }

        DirectDLI(Class clazz, AudioFormat[] audioFormatArray, int n2, int n3, 1 var5_5) {
            this(clazz, audioFormatArray, n2, n3);
        }
    }

    private static class DirectSDL
    extends DirectDL
    implements SourceDataLine {
        private DirectSDL(DataLine.Info info, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), true);
        }

        DirectSDL(DataLine.Info info, DirectAudioDevice directAudioDevice, 1 var3_3) {
            this(info, directAudioDevice);
        }
    }

    private static class DirectTDL
    extends DirectDL
    implements TargetDataLine {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n2, int n3) {
            this.flushing = false;
            if (n3 == 0) {
                return 0;
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("illegal len: " + n3);
            }
            if (n3 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("Illegal request to read non-integral number of frames (" + n3 + " bytes )");
            }
            if (n2 < 0) {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
            if (n2 + n3 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException(byArray.length);
            }
            if (!this.isActive() && this.doIO) {
                this.setActive(true);
                this.setStarted(true);
            }
            int n4 = 0;
            while (this.doIO && !this.flushing) {
                this.activeIO = true;
                int n5 = DirectAudioDevice.access$1400(this.id, byArray, n2, n3, this.softwareConversionSize);
                this.activeIO = false;
                if (n5 < 0) break;
                this.bytePosition += (long)n5;
                n4 += n5;
                if ((n3 -= n5) <= 0) break;
                n2 += n5;
                DirectTDL directTDL = this;
                synchronized (directTDL) {
                    try {
                        this.wait(this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return n4;
        }

        private DirectTDL(DataLine.Info info, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), false);
        }

        DirectTDL(DataLine.Info info, DirectAudioDevice directAudioDevice, 1 var3_3) {
            this(info, directAudioDevice);
        }
    }
}

