/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;
import sun.awt.shell.ShellFolder;

public class WindowsFileChooserUI
extends BasicFileChooserUI {
    private static final String[] OS_NAMES = new String[]{"Windows 3.1", "Windows 95", "Windows NT", "Windows 98", "Windows 2000", "Windows Me", "Windows XP"};
    private static int WIN_31 = 0;
    private static int WIN_95 = 1;
    private static int WIN_NT = 2;
    private static int WIN_98 = 3;
    private static int WIN_2k = 4;
    private static int WIN_Me = 5;
    private static int WIN_XP = 6;
    private static String osName = System.getProperty("os.name");
    private static String osVersion = System.getProperty("os.version");
    private static final String OS_NAME = osName.equals(OS_NAMES[WIN_98]) && osVersion.startsWith("4.9") ? "Windows Me" : osName;
    private static final int OS_LEVEL = Arrays.asList(OS_NAMES).indexOf(OS_NAME);
    private JPanel centerPanel;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private ActionListener directoryComboBoxAction = new DirectoryComboBoxAction(this);
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField filenameTextField;
    private ShortCutPanel shortCutPanel;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private JPanel listViewPanel;
    private JPanel detailsViewPanel;
    private JPanel currentViewPanel;
    private FocusListener editorFocusListener = new FocusAdapter(this){
        private final WindowsFileChooserUI this$0;
        {
            this.this$0 = windowsFileChooserUI;
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                WindowsFileChooserUI.access$000(this.this$0);
            }
        }
    };
    private boolean smallIconsView = false;
    private Border listViewBorder;
    private boolean useShellFolder;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private JTable detailsTable;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension hstrut25 = new Dimension(25, 1);
    private static final Dimension vstrut1 = new Dimension(1, 1);
    private static final Dimension vstrut4 = new Dimension(1, 4);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Dimension vstrut6 = new Dimension(1, 6);
    private static final Dimension vstrut8 = new Dimension(1, 8);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 425;
    private static int PREF_HEIGHT = 245;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 425;
    private static int MIN_HEIGHT = 245;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 444;
    private static int LIST_PREF_HEIGHT = 138;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    private Action newFolderAction = new WindowsNewFolderAction(this);
    private File newFolderFile;
    private BasicFileChooserUI.BasicFileView fileView = new WindowsFileView(this);
    int lastIndex = -1;
    File editFile = null;
    int editX = 20;
    JTextField editCell = null;
    static final int space = 10;
    static Class class$java$io$File;
    static Class class$java$util$Date;
    static Class class$java$lang$Object;

    private int getEditIndex() {
        return this.lastIndex;
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    private void applyEdit() {
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser jFileChooser = this.getFileChooser();
            String string = jFileChooser.getName(this.editFile);
            String string2 = this.editFile.getName();
            String string3 = this.editCell.getText().trim();
            if (!string3.equals(string)) {
                FileSystemView fileSystemView;
                File file;
                int n2;
                String string4 = string3;
                int n3 = string2.length();
                if (n3 > (n2 = string.length()) && string2.charAt(n2) == '.') {
                    string4 = string3 + string2.substring(n2);
                }
                if (!(file = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), string4)).exists() && this.getModel().renameFile(this.editFile, file) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file)) {
                    if (jFileChooser.isMultiSelectionEnabled()) {
                        jFileChooser.setSelectedFiles(new File[]{file});
                    } else {
                        jFileChooser.setSelectedFile(file);
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    private void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.centerPanel.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            Object[] objectArray = this.getFileChooser().getSelectedFiles();
            Object[] objectArray2 = this.list.getSelectedValues();
            if (ShellFolder.disableFileChooserSpeedFix()) {
                int n2;
                boolean bl2;
                int n3;
                for (n3 = 0; n3 < objectArray2.length; ++n3) {
                    bl2 = false;
                    for (n2 = 0; n2 < objectArray.length; ++n2) {
                        if (!((File)objectArray[n2]).equals(objectArray2[n3])) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2 || (n2 = this.getModel().indexOf(objectArray2[n3])) < 0) continue;
                    this.listSelectionModel.removeSelectionInterval(n2, n2);
                }
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    bl2 = false;
                    for (n2 = 0; n2 < objectArray2.length; ++n2) {
                        if (!((File)objectArray[n3]).equals(objectArray2[n2])) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2 || (n2 = this.getModel().indexOf(objectArray[n3])) < 0) continue;
                    this.listSelectionModel.addSelectionInterval(n2, n2);
                }
            } else {
                this.listSelectionModel.setValueIsAdjusting(true);
                try {
                    int n4;
                    Arrays.sort(objectArray);
                    Arrays.sort(objectArray2);
                    int n5 = 0;
                    int n6 = 0;
                    while (n5 < objectArray.length && n6 < objectArray2.length) {
                        int n7;
                        n4 = ((File)objectArray[n5]).compareTo(objectArray2[n6]);
                        if (n4 < 0) {
                            n7 = this.getModel().indexOf(objectArray[n5]);
                            this.listSelectionModel.addSelectionInterval(n7, n7);
                            ++n5;
                            continue;
                        }
                        if (n4 > 0) {
                            n7 = this.getModel().indexOf(objectArray2[n6]);
                            this.listSelectionModel.removeSelectionInterval(n7, n7);
                            ++n6;
                            continue;
                        }
                        ++n5;
                        ++n6;
                    }
                    while (n5 < objectArray.length) {
                        n4 = this.getModel().indexOf(objectArray[n5]);
                        this.listSelectionModel.addSelectionInterval(n4, n4);
                        ++n5;
                    }
                    while (n6 < objectArray2.length) {
                        n4 = this.getModel().indexOf(objectArray2[n6]);
                        this.listSelectionModel.removeSelectionInterval(n4, n4);
                        ++n6;
                    }
                }
                finally {
                    this.listSelectionModel.setValueIsAdjusting(false);
                }
            }
        } else {
            int n8;
            JFileChooser jFileChooser = this.getFileChooser();
            File file = null;
            file = this.isDirectorySelected() ? this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null && (n8 = this.getModel().indexOf(file)) >= 0) {
                this.listSelectionModel.setSelectionInterval(n8, n8);
                this.ensureIndexIsVisible(n8);
            } else {
                this.listSelectionModel.clearSelection();
            }
        }
    }

    private void updateListRowCount() {
        if (this.smallIconsView) {
            this.list.setVisibleRowCount(this.getModel().getSize() / 3);
        } else {
            this.list.setVisibleRowCount(-1);
        }
    }

    private void updateUseShellFolder() {
        JFileChooser jFileChooser = this.getFileChooser();
        Boolean bl2 = (Boolean)jFileChooser.getClientProperty("FileChooser.useShellFolder");
        this.useShellFolder = bl2 != null ? bl2.booleanValue() : jFileChooser.getFileSystemView().equals(FileSystemView.getFileSystemView());
        if (OS_LEVEL >= WIN_2k) {
            if (this.useShellFolder) {
                if (this.shortCutPanel == null) {
                    this.shortCutPanel = new ShortCutPanel(this);
                    jFileChooser.add((Component)this.shortCutPanel, "Before");
                }
            } else if (this.shortCutPanel != null) {
                jFileChooser.remove(this.shortCutPanel);
                this.shortCutPanel = null;
            }
        }
    }

    private void editFileName(int n2) {
        this.ensureIndexIsVisible(n2);
        if (this.listViewPanel.isVisible()) {
            this.editFile = (File)this.getModel().getElementAt(n2);
            Rectangle rectangle = this.list.getCellBounds(n2, n2);
            if (this.editCell == null) {
                this.editCell = new JTextField();
                this.editCell.addActionListener(new EditActionListener(this));
                this.editCell.addFocusListener(this.editorFocusListener);
                this.editCell.setNextFocusableComponent(this.list);
            }
            this.list.add(this.editCell);
            this.editCell.setText(this.getFileChooser().getName(this.editFile));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                this.editCell.setBounds(this.editX + rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            } else {
                this.editCell.setBounds(rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            }
            this.editCell.requestFocus();
            this.editCell.selectAll();
        } else if (this.detailsViewPanel.isVisible()) {
            this.detailsTable.editCellAt(n2, 0);
        }
    }

    private void ensureIndexIsVisible(int n2) {
        if (n2 >= 0) {
            this.list.ensureIndexIsVisible(n2);
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(n2, 0, true));
            }
        }
    }

    private void fixNameColumnWidth(int n2) {
        TableColumn tableColumn = this.detailsTable.getColumnModel().getColumn(0);
        int n3 = this.detailsTable.getPreferredSize().width;
        if (n3 < n2) {
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n2 - n3);
        }
    }

    private void setEditIndex(int n2) {
        this.lastIndex = n2;
    }

    protected void setDirectorySelected(boolean bl2) {
        super.setDirectorySelected(bl2);
        JFileChooser jFileChooser = this.getFileChooser();
        if (bl2) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
            this.approveButton.setMnemonic(this.directoryOpenButtonMnemonic);
        } else {
            this.approveButton.setText(this.getApproveButtonText(jFileChooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        }
    }

    static int access$2500(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.getEditIndex();
    }

    static void access$000(WindowsFileChooserUI windowsFileChooserUI) {
        windowsFileChooserUI.applyEdit();
    }

    static void access$1000(WindowsFileChooserUI windowsFileChooserUI) {
        windowsFileChooserUI.cancelEdit();
    }

    static void access$1300(WindowsFileChooserUI windowsFileChooserUI) {
        windowsFileChooserUI.updateListRowCount();
    }

    static void access$2700(WindowsFileChooserUI windowsFileChooserUI) {
        windowsFileChooserUI.resetEditIndex();
    }

    static void access$4000(WindowsFileChooserUI windowsFileChooserUI) {
        windowsFileChooserUI.updateUseShellFolder();
    }

    static boolean access$4300(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.useShellFolder;
    }

    static void access$2100(WindowsFileChooserUI windowsFileChooserUI, int n2) {
        windowsFileChooserUI.fixNameColumnWidth(n2);
    }

    static void access$2200(WindowsFileChooserUI windowsFileChooserUI, int n2) {
        windowsFileChooserUI.editFileName(n2);
    }

    static void access$2600(WindowsFileChooserUI windowsFileChooserUI, int n2) {
        windowsFileChooserUI.setEditIndex(n2);
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel(this);
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer(this);
    }

    static Dimension access$1200() {
        return vstrut1;
    }

    static Dimension access$400() {
        return LIST_PREF_SIZE;
    }

    private void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
    }

    private void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    private void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        if (jFileChooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        this.ensureIndexIsVisible(0);
        File file = jFileChooser.getCurrentDirectory();
        if (this.shortCutPanel != null) {
            this.shortCutPanel.doDirectoryChanged(file);
        }
        if (file != null) {
            DirectoryComboBoxModel.access$2800(this.directoryComboBoxModel, file);
            this.getNewFolderAction().setEnabled(file.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fileSystemView.isRoot(file));
            if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
                if (fileSystemView.isFileSystem(file)) {
                    this.setFileName(file.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
    }

    private void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.listSelectionModel.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileName(this.fileNameString(fileArray));
            this.setFileSelected();
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public void setDirectoryName(String string) {
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    protected ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(this){
            private final WindowsFileChooserUI this$0;

            public boolean isEnabled() {
                return this.this$0.getFileChooser().isEnabled();
            }
            {
                this.this$0 = windowsFileChooserUI;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.this$0.editFile != null) {
                    WindowsFileChooserUI.access$1000(this.this$0);
                } else {
                    this.this$0.getFileChooser().cancelSelection();
                }
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", abstractAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        return actionMapUIResource;
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(jComponent);
    }

    public WindowsFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public void installComponents(JFileChooser jFileChooser) {
        JButton jButton;
        Object object;
        Serializable serializable;
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        XPStyle xPStyle = XPStyle.getXP();
        this.listViewBorder = xPStyle != null ? xPStyle.getBorder("listview") : new BevelBorder(1, UIManager.getColor("ToolBar.highlight"), UIManager.getColor("ToolBar.background"), UIManager.getColor("ToolBar.darkShadow"), UIManager.getColor("ToolBar.shadow"));
        jFileChooser.setBorder(new EmptyBorder(4, 10, 10, 10));
        jFileChooser.setLayout(new BorderLayout(8, 8));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        if (OS_LEVEL >= WIN_2k) {
            jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        }
        jFileChooser.add((Component)jToolBar, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        this.lookInLabel.setAlignmentX(0.0f);
        this.lookInLabel.setAlignmentY(0.5f);
        jToolBar.add(Box.createRigidArea(new Dimension(14, 0)));
        jToolBar.add(this.lookInLabel);
        jToolBar.add(Box.createRigidArea(new Dimension(29, 0)));
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        this.directoryComboBox.setMaximumRowCount(8);
        jToolBar.add(this.directoryComboBox);
        jToolBar.add(Box.createRigidArea(hstrut10));
        JButton jButton2 = new JButton(this.getChangeToParentDirectoryAction());
        jButton2.setText(null);
        jButton2.setIcon(this.upFolderIcon);
        jButton2.setToolTipText(this.upFolderToolTipText);
        jButton2.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jButton2.setFocusPainted(false);
        jToolBar.add(jButton2);
        if (OS_LEVEL < WIN_2k) {
            jToolBar.add(Box.createRigidArea(hstrut10));
        }
        if (OS_LEVEL == WIN_98) {
            serializable = fileSystemView.getHomeDirectory();
            object = this.homeFolderToolTipText;
            if (fileSystemView.isRoot((File)serializable)) {
                object = this.getFileView(jFileChooser).getName((File)serializable);
            }
            jButton = new JButton(this.getFileView(jFileChooser).getIcon((File)serializable));
            jButton.setToolTipText((String)object);
            jButton.getAccessibleContext().setAccessibleName((String)object);
            jButton.setAlignmentX(0.0f);
            jButton.setAlignmentY(0.5f);
            jButton.setMargin(shrinkwrap);
            jButton.setFocusPainted(false);
            jButton.addActionListener(this.getGoHomeAction());
            jToolBar.add(jButton);
            jToolBar.add(Box.createRigidArea(hstrut10));
        }
        jButton = new JButton(this.getNewFolderAction());
        jButton.setText(null);
        jButton.setIcon(this.newFolderIcon);
        jButton.setToolTipText(this.newFolderToolTipText);
        jButton.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jButton.setFocusPainted(false);
        jToolBar.add(jButton);
        if (OS_LEVEL < WIN_2k) {
            jToolBar.add(Box.createRigidArea(hstrut10));
        }
        serializable = new ButtonGroup();
        class ViewButtonListener
        implements ActionListener {
            JFileChooser fc;
            private final WindowsFileChooserUI this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                JPanel jPanel = WindowsFileChooserUI.access$100(this.this$0);
                if (jToggleButton == WindowsFileChooserUI.access$200(this.this$0)) {
                    if (WindowsFileChooserUI.access$300(this.this$0) == null) {
                        WindowsFileChooserUI.access$302(this.this$0, this.this$0.createDetailsView(this.fc));
                        WindowsFileChooserUI.access$300(this.this$0).setPreferredSize(WindowsFileChooserUI.access$400());
                    }
                    WindowsFileChooserUI.access$102(this.this$0, WindowsFileChooserUI.access$300(this.this$0));
                } else {
                    WindowsFileChooserUI.access$102(this.this$0, WindowsFileChooserUI.access$500(this.this$0));
                }
                if (WindowsFileChooserUI.access$100(this.this$0) != jPanel) {
                    WindowsFileChooserUI.access$600(this.this$0).remove(jPanel);
                    WindowsFileChooserUI.access$600(this.this$0).add((Component)WindowsFileChooserUI.access$100(this.this$0), "Center");
                    WindowsFileChooserUI.access$600(this.this$0).revalidate();
                    WindowsFileChooserUI.access$600(this.this$0).repaint();
                }
            }

            ViewButtonListener(WindowsFileChooserUI windowsFileChooserUI, JFileChooser jFileChooser) {
                this.this$0 = windowsFileChooserUI;
                this.fc = jFileChooser;
            }
        }
        object = new ViewButtonListener(this, jFileChooser);
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setFocusPainted(false);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener((ActionListener)object);
        jToolBar.add(this.listViewButton);
        ((ButtonGroup)serializable).add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setFocusPainted(false);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener((ActionListener)object);
        jToolBar.add(this.detailsViewButton);
        ((ButtonGroup)serializable).add(this.detailsViewButton);
        this.updateUseShellFolder();
        this.centerPanel = new JPanel(new BorderLayout());
        this.listViewPanel = this.createList(jFileChooser);
        this.listSelectionModel = this.list.getSelectionModel();
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        JComponent jComponent = jFileChooser.getAccessory();
        if (jComponent != null) {
            this.getAccessoryPanel().add(jComponent);
        }
        jFileChooser.add((Component)this.centerPanel, "Center");
        this.getBottomPanel().setLayout(new BoxLayout(this.getBottomPanel(), 2));
        this.centerPanel.add((Component)this.getBottomPanel(), "South");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(Box.createRigidArea(vstrut4));
        JLabel jLabel = new JLabel(this.fileNameLabelText);
        jLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        jLabel.setAlignmentY(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(1, 12)));
        JLabel jLabel2 = new JLabel(this.filesOfTypeLabelText);
        jLabel2.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        jPanel.add(jLabel2);
        this.getBottomPanel().add(jPanel);
        this.getBottomPanel().add(Box.createRigidArea(new Dimension(15, 0)));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(Box.createRigidArea(vstrut8));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.filenameTextField = new JTextField(this, 35){
            private final WindowsFileChooserUI this$0;
            {
                this.this$0 = windowsFileChooserUI;
                super(n2);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        jLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addFocusListener(new FocusAdapter(this){
            private final WindowsFileChooserUI this$0;
            {
                this.this$0 = windowsFileChooserUI;
            }

            public void focusGained(FocusEvent focusEvent) {
                if (!this.this$0.getFileChooser().isMultiSelectionEnabled()) {
                    WindowsFileChooserUI.access$700(this.this$0).clearSelection();
                }
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFile()));
        }
        jPanel2.add(this.filenameTextField);
        jPanel2.add(Box.createRigidArea(vstrut8));
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        jLabel2.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jPanel2.add(this.filterComboBox);
        this.getBottomPanel().add(jPanel2);
        this.getBottomPanel().add(Box.createRigidArea(hstrut10));
        this.getButtonPanel().setLayout(new BoxLayout(this.getButtonPanel(), 1));
        this.approveButton = new JButton(this, this.getApproveButtonText(jFileChooser)){
            private final WindowsFileChooserUI this$0;

            public Dimension getMaximumSize() {
                return WindowsFileChooserUI.access$800((WindowsFileChooserUI)this.this$0).getPreferredSize().width > WindowsFileChooserUI.access$900((WindowsFileChooserUI)this.this$0).getPreferredSize().width ? WindowsFileChooserUI.access$800(this.this$0).getPreferredSize() : WindowsFileChooserUI.access$900(this.this$0).getPreferredSize();
            }
            {
                this.this$0 = windowsFileChooserUI;
                super(string);
            }
        };
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.getButtonPanel().add(Box.createRigidArea(vstrut4));
        this.getButtonPanel().add(this.approveButton);
        this.getButtonPanel().add(Box.createRigidArea(vstrut6));
        this.cancelButton = new JButton(this, this.cancelButtonText){
            private final WindowsFileChooserUI this$0;

            public Dimension getMaximumSize() {
                return WindowsFileChooserUI.access$800((WindowsFileChooserUI)this.this$0).getPreferredSize().width > WindowsFileChooserUI.access$900((WindowsFileChooserUI)this.this$0).getPreferredSize().width ? WindowsFileChooserUI.access$800(this.this$0).getPreferredSize() : WindowsFileChooserUI.access$900(this.this$0).getPreferredSize();
            }
            {
                this.this$0 = windowsFileChooserUI;
                super(string);
            }
        };
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (jFileChooser.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", locale);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", locale);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", locale);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", locale);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", locale);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", locale);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", locale);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", locale);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", locale);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", locale);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", locale);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", locale);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", locale);
        this.fileNameHeaderText = UIManager.getString((Object)"FileChooser.fileNameHeaderText", locale);
        this.fileSizeHeaderText = UIManager.getString((Object)"FileChooser.fileSizeHeaderText", locale);
        this.fileTypeHeaderText = UIManager.getString((Object)"FileChooser.fileTypeHeaderText", locale);
        this.fileDateHeaderText = UIManager.getString((Object)"FileChooser.fileDateHeaderText", locale);
        this.fileAttrHeaderText = UIManager.getString((Object)"FileChooser.fileAttrHeaderText", locale);
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().validateFileCache();
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.fileNameString(file));
        }
    }

    static DirectoryComboBoxModel access$4200(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.directoryComboBoxModel;
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel(this);
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer(this);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n2 = WindowsFileChooserUI.PREF_SIZE.width;
        Dimension dimension = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension != null) {
            return new Dimension(dimension.width < n2 ? n2 : dimension.width, dimension.height < WindowsFileChooserUI.PREF_SIZE.height ? WindowsFileChooserUI.PREF_SIZE.height : dimension.height);
        }
        return new Dimension(n2, WindowsFileChooserUI.PREF_SIZE.height);
    }

    static void access$2900(WindowsFileChooserUI windowsFileChooserUI, PropertyChangeEvent propertyChangeEvent) {
        windowsFileChooserUI.doSelectedFileChanged(propertyChangeEvent);
    }

    static void access$3000(WindowsFileChooserUI windowsFileChooserUI, PropertyChangeEvent propertyChangeEvent) {
        windowsFileChooserUI.doSelectedFilesChanged(propertyChangeEvent);
    }

    static void access$3100(WindowsFileChooserUI windowsFileChooserUI, PropertyChangeEvent propertyChangeEvent) {
        windowsFileChooserUI.doDirectoryChanged(propertyChangeEvent);
    }

    static void access$3200(WindowsFileChooserUI windowsFileChooserUI, PropertyChangeEvent propertyChangeEvent) {
        windowsFileChooserUI.doFilterChanged(propertyChangeEvent);
    }

    static void access$3300(WindowsFileChooserUI windowsFileChooserUI, PropertyChangeEvent propertyChangeEvent) {
        windowsFileChooserUI.doFileSelectionModeChanged(propertyChangeEvent);
    }

    static void access$3400(WindowsFileChooserUI windowsFileChooserUI, PropertyChangeEvent propertyChangeEvent) {
        windowsFileChooserUI.doMultiSelectionChanged(propertyChangeEvent);
    }

    static void access$3500(WindowsFileChooserUI windowsFileChooserUI, PropertyChangeEvent propertyChangeEvent) {
        windowsFileChooserUI.doAccessoryChanged(propertyChangeEvent);
    }

    static void access$3600(WindowsFileChooserUI windowsFileChooserUI, PropertyChangeEvent propertyChangeEvent) {
        windowsFileChooserUI.doApproveButtonTextChanged(propertyChangeEvent);
    }

    static void access$3700(WindowsFileChooserUI windowsFileChooserUI, PropertyChangeEvent propertyChangeEvent) {
        windowsFileChooserUI.doDialogTypeChanged(propertyChangeEvent);
    }

    static void access$3800(WindowsFileChooserUI windowsFileChooserUI, PropertyChangeEvent propertyChangeEvent) {
        windowsFileChooserUI.doApproveButtonMnemonicChanged(propertyChangeEvent);
    }

    static void access$3900(WindowsFileChooserUI windowsFileChooserUI, PropertyChangeEvent propertyChangeEvent) {
        windowsFileChooserUI.doControlButtonsChanged(propertyChangeEvent);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(this){
            private final WindowsFileChooserUI this$0;
            {
                this.this$0 = windowsFileChooserUI;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    WindowsFileChooserUI.access$2900(this.this$0, propertyChangeEvent);
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    WindowsFileChooserUI.access$3000(this.this$0, propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    WindowsFileChooserUI.access$3100(this.this$0, propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    WindowsFileChooserUI.access$3200(this.this$0, propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    WindowsFileChooserUI.access$3300(this.this$0, propertyChangeEvent);
                } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
                    WindowsFileChooserUI.access$3400(this.this$0, propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    WindowsFileChooserUI.access$3500(this.this$0, propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                    WindowsFileChooserUI.access$3600(this.this$0, propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    WindowsFileChooserUI.access$3700(this.this$0, propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    WindowsFileChooserUI.access$3800(this.this$0, propertyChangeEvent);
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    WindowsFileChooserUI.access$3900(this.this$0, propertyChangeEvent);
                } else if (string.equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jFileChooser.applyComponentOrientation(componentOrientation);
                    }
                    if (WindowsFileChooserUI.access$2000(this.this$0) != null) {
                        WindowsFileChooserUI.access$2000(this.this$0).setComponentOrientation(componentOrientation);
                        WindowsFileChooserUI.access$2000(this.this$0).getParent().getParent().setComponentOrientation(componentOrientation);
                    }
                } else if (string == "FileChooser.useShellFolder") {
                    WindowsFileChooserUI.access$4000(this.this$0);
                    WindowsFileChooserUI.access$3100(this.this$0, propertyChangeEvent);
                } else if (string.equals("ancestor") && propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                    WindowsFileChooserUI.access$4100(this.this$0).selectAll();
                    WindowsFileChooserUI.access$4100(this.this$0).requestFocus();
                }
            }
        };
    }

    static File access$1400(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.newFolderFile;
    }

    static void access$2300(WindowsFileChooserUI windowsFileChooserUI, File file) {
        windowsFileChooserUI.setDirectory(file);
    }

    static void access$2400(WindowsFileChooserUI windowsFileChooserUI, File file) {
        windowsFileChooserUI.setDirectory(file);
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        this.ensureIndexIsVisible(this.getModel().indexOf(file));
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static String access$1500(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.fileNameHeaderText;
    }

    static String access$1600(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.fileSizeHeaderText;
    }

    static String access$1700(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.fileTypeHeaderText;
    }

    static String access$1800(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.fileDateHeaderText;
    }

    static String access$1900(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.fileAttrHeaderText;
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.fileNameString(fileArray[i2]));
            if (fileArray.length <= 1) continue;
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    static JButton access$800(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.approveButton;
    }

    static JButton access$900(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.cancelButton;
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    static JComboBox access$4400(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.directoryComboBox;
    }

    static JPanel access$100(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.currentViewPanel;
    }

    static JPanel access$300(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.detailsViewPanel;
    }

    static JPanel access$500(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.listViewPanel;
    }

    static JPanel access$600(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.centerPanel;
    }

    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        Color color;
        JFileChooser jFileChooser2 = jFileChooser;
        JPanel jPanel = new JPanel(new BorderLayout());
        DetailsTableModel detailsTableModel = new DetailsTableModel(this, jFileChooser2);
        this.detailsTable = new JTable(this, detailsTableModel, jFileChooser2){
            private final JFileChooser val$chooser;
            private final WindowsFileChooserUI this$0;

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
                if (keyEvent.getKeyCode() == 27 && this.getCellEditor() == null) {
                    this.val$chooser.dispatchEvent(keyEvent);
                    return true;
                }
                return super.processKeyBinding(keyStroke, keyEvent, n2, bl2);
            }
            {
                this.this$0 = windowsFileChooserUI;
                this.val$chooser = jFileChooser;
                super(tableModel);
            }
        };
        this.detailsTable.setComponentOrientation(jFileChooser2.getComponentOrientation());
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        Font font = this.detailsTable.getFont();
        this.detailsTable.setRowHeight(Math.max(font.getSize(), 19) + 3);
        TableColumnModel tableColumnModel = this.detailsTable.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            tableColumnArray[i2] = tableColumnModel.getColumn(i2);
            tableColumnArray[i2].setPreferredWidth(this.COLUMN_WIDTHS[i2]);
        }
        DetailsTableCellRenderer detailsTableCellRenderer = new DetailsTableCellRenderer(this, jFileChooser2);
        this.detailsTable.setDefaultRenderer(class$java$io$File == null ? (class$java$io$File = WindowsFileChooserUI.class$("java.io.File")) : class$java$io$File, detailsTableCellRenderer);
        this.detailsTable.setDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = WindowsFileChooserUI.class$("java.util.Date")) : class$java$util$Date, detailsTableCellRenderer);
        this.detailsTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = WindowsFileChooserUI.class$("java.lang.Object")) : class$java$lang$Object, detailsTableCellRenderer);
        JTextField jTextField = new JTextField();
        jTextField.addFocusListener(this.editorFocusListener);
        tableColumnArray[0].setCellEditor(new DefaultCellEditor(this, jTextField, jTextField, jFileChooser2){
            private final JTextField val$tf;
            private final JFileChooser val$chooser;
            private final WindowsFileChooserUI this$0;

            public boolean isCellEditable(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    int n2 = WindowsFileChooserUI.access$2000(this.this$0).rowAtPoint(mouseEvent.getPoint());
                    return mouseEvent.getClickCount() == 1 && WindowsFileChooserUI.access$2000(this.this$0).isRowSelected(n2);
                }
                return super.isCellEditable(eventObject);
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
                Component component = super.getTableCellEditorComponent(jTable, object, bl2, n2, n3);
                if (object instanceof File) {
                    this.val$tf.setText(this.val$chooser.getName((File)object));
                    this.val$tf.requestFocus();
                    this.val$tf.selectAll();
                }
                return component;
            }
            {
                this.this$0 = windowsFileChooserUI;
                this.val$tf = jTextField2;
                this.val$chooser = jFileChooser;
                super(jTextField);
            }
        });
        JList jList = new JList(this, detailsTableModel.listModel){
            JTable table;
            private final WindowsFileChooserUI this$0;

            public void repaint() {
                if (this.table != null) {
                    this.table.repaint();
                }
            }

            public boolean getDragEnabled() {
                if (this.table != null) {
                    return this.table.getDragEnabled();
                }
                return super.getDragEnabled();
            }

            public void setDragEnabled(boolean bl2) {
                if (this.table != null) {
                    this.table.setDragEnabled(bl2);
                } else {
                    super.setDragEnabled(bl2);
                }
            }

            public int locationToIndex(Point point) {
                return this.table.rowAtPoint(point);
            }

            public Rectangle getCellBounds(int n2, int n3) {
                Rectangle rectangle = this.table.getCellRect(n2, 0, false);
                Rectangle rectangle2 = this.table.getCellRect(n3, 0, false);
                return rectangle.union(rectangle2);
            }

            public Object getSelectedValue() {
                return this.table.getValueAt(this.table.getSelectedRow(), 0);
            }

            public TransferHandler getTransferHandler() {
                if (this.table != null) {
                    return this.table.getTransferHandler();
                }
                return super.getTransferHandler();
            }

            public void setTransferHandler(TransferHandler transferHandler) {
                if (this.table != null) {
                    this.table.setTransferHandler(transferHandler);
                } else {
                    super.setTransferHandler(transferHandler);
                }
            }

            public Component add(Component component) {
                if (component instanceof JTextField) {
                    return this.table.add(component);
                }
                return super.add(component);
            }
            {
                this.this$0 = windowsFileChooserUI;
                super(listModel);
                this.table = WindowsFileChooserUI.access$2000(this.this$0);
            }
        };
        jList.setSelectionModel(this.listSelectionModel);
        this.detailsTable.addMouseListener(this.createDoubleClickListener(jFileChooser2, jList));
        JScrollPane jScrollPane = new JScrollPane(this.detailsTable);
        jScrollPane.setComponentOrientation(jFileChooser2.getComponentOrientation());
        LookAndFeel.installColors(jScrollPane.getViewport(), "Table.background", "Table.foreground");
        jScrollPane.addComponentListener(new ComponentAdapter(this){
            private final WindowsFileChooserUI this$0;
            {
                this.this$0 = windowsFileChooserUI;
            }

            public void componentResized(ComponentEvent componentEvent) {
                JScrollPane jScrollPane = (JScrollPane)componentEvent.getComponent();
                WindowsFileChooserUI.access$2100(this.this$0, jScrollPane.getViewport().getSize().width);
                jScrollPane.removeComponentListener(this);
            }
        });
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null && (color = xPStyle.getColor("listview.fillcolor", null)) != null) {
            this.list.setBackground(color);
        }
        if (this.listViewBorder != null) {
            jScrollPane.setBorder(this.listViewBorder);
        }
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        Color color;
        JPanel jPanel = new JPanel(new BorderLayout());
        JFileChooser jFileChooser2 = jFileChooser;
        this.list = new JList(this, jFileChooser2){
            private final JFileChooser val$fileChooser;
            private final WindowsFileChooserUI this$0;
            {
                this.this$0 = windowsFileChooserUI;
                this.val$fileChooser = jFileChooser;
            }

            public int getNextMatch(String string, int n2, Position.Bias bias) {
                ListModel listModel = this.getModel();
                int n3 = listModel.getSize();
                if (string == null || n2 < 0 || n2 >= n3) {
                    throw new IllegalArgumentException();
                }
                boolean bl2 = bias == Position.Bias.Backward;
                int n4 = n2;
                while (bl2 ? n4 >= 0 : n4 < n3) {
                    String string2 = this.val$fileChooser.getName((File)listModel.getElementAt(n4));
                    if (string2.regionMatches(true, 0, string, 0, string.length())) {
                        return n4;
                    }
                    n4 += bl2 ? -1 : 1;
                }
                return -1;
            }
        };
        this.list.setCellRenderer(new FileRenderer(this));
        this.list.setLayoutOrientation(1);
        this.updateListRowCount();
        this.getModel().addListDataListener(new ListDataListener(this){
            private final WindowsFileChooserUI this$0;
            {
                this.this$0 = windowsFileChooserUI;
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                WindowsFileChooserUI.access$1300(this.this$0);
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                WindowsFileChooserUI.access$1300(this.this$0);
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                WindowsFileChooserUI.access$1300(this.this$0);
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this.list.addMouseListener(this.createDoubleClickListener(jFileChooser, this.list));
        this.list.addMouseListener(this.createSingleClickListener(jFileChooser, this.list));
        this.getModel().addListDataListener(new ListDataListener(this){
            private final WindowsFileChooserUI this$0;
            {
                this.this$0 = windowsFileChooserUI;
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater(this.this$0);
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                File file;
                int n2;
                int n3 = listDataEvent.getIndex0();
                if (n3 == (n2 = listDataEvent.getIndex1()) && (file = (File)this.this$0.getModel().getElementAt(n3)).equals(WindowsFileChooserUI.access$1400(this.this$0))) {
                    new DelayedSelectionUpdater(this.this$0, file);
                    WindowsFileChooserUI.access$1402(this.this$0, null);
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null && (color = xPStyle.getColor("listview.fillcolor", null)) != null) {
            this.list.setBackground(color);
        }
        if (this.listViewBorder != null) {
            jScrollPane.setBorder(this.listViewBorder);
        }
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    static JTable access$2000(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.detailsTable;
    }

    static JTextField access$4100(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.filenameTextField;
    }

    static JToggleButton access$200(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.detailsViewButton;
    }

    static ListSelectionModel access$700(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.listSelectionModel;
    }

    static Border access$1100(WindowsFileChooserUI windowsFileChooserUI) {
        return windowsFileChooserUI.listViewBorder;
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new BasicFileChooserUI.SelectionListener(this){
            private final WindowsFileChooserUI this$0;
            {
                this.this$0 = windowsFileChooserUI;
                super(windowsFileChooserUI);
            }

            /*
             * Enabled aggressive block sorting
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                File[] fileArray;
                JFileChooser jFileChooser;
                block7: {
                    int n2;
                    Object[] objectArray;
                    FileSystemView fileSystemView;
                    block9: {
                        JList jList;
                        block6: {
                            block8: {
                                if (listSelectionEvent.getValueIsAdjusting()) return;
                                jFileChooser = this.this$0.getFileChooser();
                                fileSystemView = jFileChooser.getFileSystemView();
                                jList = (JList)listSelectionEvent.getSource();
                                if (!jFileChooser.isMultiSelectionEnabled()) break block6;
                                fileArray = null;
                                objectArray = jList.getSelectedValues();
                                if (objectArray == null) break block7;
                                if (objectArray.length != 1 || !((File)objectArray[0]).isDirectory() || !jFileChooser.isTraversable((File)objectArray[0])) break block8;
                                if (jFileChooser.getFileSelectionMode() != 0 && fileSystemView.isFileSystem((File)objectArray[0])) break block8;
                                this.this$0.setDirectorySelected(true);
                                WindowsFileChooserUI.access$2300(this.this$0, (File)objectArray[0]);
                                break block7;
                            }
                            fileArray = new File[objectArray.length];
                            n2 = 0;
                            break block9;
                        }
                        File file = (File)jList.getSelectedValue();
                        if (file != null && file.isDirectory() && jFileChooser.isTraversable(file)) {
                            if (jFileChooser.getFileSelectionMode() == 0 || !fileSystemView.isFileSystem(file)) {
                                this.this$0.setDirectorySelected(true);
                                WindowsFileChooserUI.access$2400(this.this$0, file);
                                jFileChooser.setSelectedFile(null);
                                return;
                            }
                        }
                        this.this$0.setDirectorySelected(false);
                        if (file == null) return;
                        jFileChooser.setSelectedFile(file);
                        return;
                    }
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        boolean bl2;
                        File file = (File)objectArray[i2];
                        boolean bl3 = file.isDirectory();
                        boolean bl4 = ShellFolder.disableFileChooserSpeedFix() ? file.isFile() : (bl2 = !bl3);
                        if ((!jFileChooser.isFileSelectionEnabled() || !bl2) && (!jFileChooser.isDirectorySelectionEnabled() || !fileSystemView.isFileSystem(file) || !bl3)) continue;
                        fileArray[n2++] = file;
                    }
                    if (n2 == 0) {
                        fileArray = null;
                    } else if (n2 < objectArray.length) {
                        File[] fileArray2 = new File[n2];
                        System.arraycopy(fileArray, 0, fileArray2, 0, n2);
                        fileArray = fileArray2;
                    }
                    this.this$0.setDirectorySelected(false);
                }
                jFileChooser.setSelectedFiles(fileArray);
            }
        };
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsFileChooserUI((JFileChooser)jComponent);
    }

    private MouseListener createSingleClickListener(JFileChooser jFileChooser, JList jList) {
        return new SingleClickListener(this, jList);
    }

    static File access$1402(WindowsFileChooserUI windowsFileChooserUI, File file) {
        windowsFileChooserUI.newFolderFile = file;
        return windowsFileChooserUI.newFolderFile;
    }

    static JPanel access$102(WindowsFileChooserUI windowsFileChooserUI, JPanel jPanel) {
        windowsFileChooserUI.currentViewPanel = jPanel;
        return windowsFileChooserUI.currentViewPanel;
    }

    static JPanel access$302(WindowsFileChooserUI windowsFileChooserUI, JPanel jPanel) {
        windowsFileChooserUI.detailsViewPanel = jPanel;
        return windowsFileChooserUI.detailsViewPanel;
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        File editFile;
        private final WindowsFileChooserUI this$0;

        public void run() {
            this.this$0.setFileSelected();
            if (this.editFile != null) {
                WindowsFileChooserUI.access$2200(this.this$0, this.this$0.getModel().indexOf(this.editFile));
                this.editFile = null;
            }
        }

        DelayedSelectionUpdater(WindowsFileChooserUI windowsFileChooserUI) {
            this(windowsFileChooserUI, null);
        }

        DelayedSelectionUpdater(WindowsFileChooserUI windowsFileChooserUI, File file) {
            this.this$0 = windowsFileChooserUI;
            this.editFile = file;
            SwingUtilities.invokeLater(this);
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;
        private final WindowsFileChooserUI this$0;

        public void setBounds(int n2, int n3, int n4, int n5) {
            super.setBounds(n2, n3, Math.min(n4, this.getPreferredSize().width + 4), n5);
        }

        public void setValue(Object object) {
            this.setIcon(null);
            if (object instanceof File) {
                File file = (File)object;
                String string = this.chooser.getName(file);
                this.setText(string);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (object instanceof Date) {
                this.setText(object == null ? "" : this.df.format((Date)object));
            } else {
                super.setValue(object);
            }
        }

        DetailsTableCellRenderer(WindowsFileChooserUI windowsFileChooserUI, JFileChooser jFileChooser) {
            this.this$0 = windowsFileChooserUI;
            this.chooser = jFileChooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, jFileChooser.getLocale());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (n3 == 1 || n3 == 4) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            if (n3 == 0 && jTable.isRowSelected(n2) && jTable.isFocusOwner()) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(jTable.getForeground());
                super.setBackground(jTable.getBackground());
            }
            this.setFont(jTable.getFont());
            this.setValue(object);
            return this;
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;
        private final WindowsFileChooserUI this$0;

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return this.listModel.getSize();
        }

        public boolean isCellEditable(int n2, int n3) {
            return n3 == 0;
        }

        public Class getColumnClass(int n2) {
            switch (n2) {
                case 0: {
                    return class$java$io$File == null ? (class$java$io$File = WindowsFileChooserUI.class$("java.io.File")) : class$java$io$File;
                }
                case 3: {
                    return class$java$util$Date == null ? (class$java$util$Date = WindowsFileChooserUI.class$("java.util.Date")) : class$java$util$Date;
                }
            }
            return super.getColumnClass(n2);
        }

        public Object getValueAt(int n2, int n3) {
            File file = (File)this.listModel.getElementAt(n2);
            switch (n3) {
                case 0: {
                    return file;
                }
                case 1: {
                    if (!file.exists() || file.isDirectory()) {
                        return null;
                    }
                    return file.length() / 1024L + 1L + "KB";
                }
                case 2: {
                    if (!file.exists()) {
                        return null;
                    }
                    return this.chooser.getFileSystemView().getSystemTypeDescription(file);
                }
                case 3: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    long l2 = file.lastModified();
                    return l2 == 0L ? null : new Date(l2);
                }
                case 4: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    String string = "";
                    if (!file.canWrite()) {
                        string = string + "R";
                    }
                    if (file.isHidden()) {
                        string = string + "H";
                    }
                    return string;
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n2, int n3) {
            if (n3 == 0) {
                JFileChooser jFileChooser = this.this$0.getFileChooser();
                File file = (File)this.getValueAt(n2, n3);
                String string = jFileChooser.getName(file);
                String string2 = file.getName();
                String string3 = ((String)object).trim();
                if (!string3.equals(string)) {
                    FileSystemView fileSystemView;
                    File file2;
                    int n4;
                    String string4 = string3;
                    int n5 = string2.length();
                    if (n5 > (n4 = string.length()) && string2.charAt(n4) == '.') {
                        string4 = string3 + string2.substring(n4);
                    }
                    if (!(file2 = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(file.getParentFile(), string4)).exists() && this.this$0.getModel().renameFile(file, file2) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file2)) {
                        if (jFileChooser.isMultiSelectionEnabled()) {
                            jFileChooser.setSelectedFiles(new File[]{file2});
                        } else {
                            jFileChooser.setSelectedFile(file2);
                        }
                    }
                }
            }
        }

        public String getColumnName(int n2) {
            return this.columnNames[n2];
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        DetailsTableModel(WindowsFileChooserUI windowsFileChooserUI, JFileChooser jFileChooser) {
            this.this$0 = windowsFileChooserUI;
            this.columnNames = new String[]{WindowsFileChooserUI.access$1500(this.this$0), WindowsFileChooserUI.access$1600(this.this$0), WindowsFileChooserUI.access$1700(this.this$0), WindowsFileChooserUI.access$1800(this.this$0), WindowsFileChooserUI.access$1900(this.this$0)};
            this.chooser = jFileChooser;
            this.listModel = windowsFileChooserUI.getModel();
            this.listModel.addListDataListener(this);
        }
    }

    protected class DirectoryComboBoxAction
    implements ActionListener {
        private final WindowsFileChooserUI this$0;

        protected DirectoryComboBoxAction(WindowsFileChooserUI windowsFileChooserUI) {
            this.this$0 = windowsFileChooserUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = (File)WindowsFileChooserUI.access$4400(this.this$0).getSelectedItem();
            this.this$0.getFileChooser().setCurrentDirectory(file);
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories;
        int[] depths;
        File selectedDirectory;
        JFileChooser chooser;
        FileSystemView fsv;
        private final WindowsFileChooserUI this$0;

        public int getSize() {
            return this.directories.size();
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i2 = 0; i2 < this.depths.length; ++i2) {
                File file = (File)this.directories.get(i2);
                File file2 = file.getParentFile();
                this.depths[i2] = 0;
                if (file2 == null) continue;
                for (int i3 = i2 - 1; i3 >= 0; --i3) {
                    if (!file2.equals((File)this.directories.get(i3))) continue;
                    this.depths[i2] = this.depths[i3] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int n2) {
            return this.depths != null && n2 >= 0 && n2 < this.depths.length ? this.depths[n2] : 0;
        }

        public DirectoryComboBoxModel(WindowsFileChooserUI windowsFileChooserUI) {
            this.this$0 = windowsFileChooserUI;
            this.directories = new Vector();
            this.depths = null;
            this.selectedDirectory = null;
            this.chooser = this.this$0.getFileChooser();
            this.fsv = this.chooser.getFileSystemView();
            File file = windowsFileChooserUI.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            if (file == null) {
                return;
            }
            this.directories.clear();
            Object[] objectArray = WindowsFileChooserUI.access$4300(this.this$0) ? (File[])AccessController.doPrivileged(new PrivilegedAction(this){
                private final DirectoryComboBoxModel this$1;
                {
                    this.this$1 = directoryComboBoxModel;
                }

                public Object run() {
                    return ShellFolder.get("fileChooserComboBoxFolders");
                }
            }) : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(objectArray));
            File file2 = null;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file;
            }
            try {
                File file3;
                File file4 = file3 = WindowsFileChooserUI.access$4300(this.this$0) ? ShellFolder.getShellFolder(file2) : file2;
                Vector vector = new Vector(10);
                do {
                    vector.addElement(file4);
                } while ((file4 = file4.getParentFile()) != null);
                int n2 = vector.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    file4 = (File)vector.get(i2);
                    if (!this.directories.contains(file4)) continue;
                    int n3 = this.directories.indexOf(file4);
                    for (int i3 = i2 - 1; i3 >= 0; --i3) {
                        this.directories.insertElementAt(vector.get(i3), n3 + i2 - i3);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(file3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.calculateDepths();
            }
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public Object getElementAt(int n2) {
            return this.directories.elementAt(n2);
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        static void access$2800(DirectoryComboBoxModel directoryComboBoxModel, File file) {
            directoryComboBoxModel.addItem(file);
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;
        private final WindowsFileChooserUI this$0;

        DirectoryComboBoxRenderer(WindowsFileChooserUI windowsFileChooserUI) {
            this.this$0 = windowsFileChooserUI;
            this.ii = new IndentIcon(this.this$0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            Icon icon;
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            if (object == null) {
                this.setText("");
                return this;
            }
            File file = (File)object;
            this.setText(this.this$0.getFileChooser().getName(file));
            this.ii.icon = icon = this.this$0.getFileChooser().getIcon(file);
            this.ii.depth = WindowsFileChooserUI.access$4200(this.this$0).getDepth(n2);
            this.setIcon(this.ii);
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        private final WindowsFileChooserUI this$0;

        EditActionListener(WindowsFileChooserUI windowsFileChooserUI) {
            this.this$0 = windowsFileChooserUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WindowsFileChooserUI.access$000(this.this$0);
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        private final WindowsFileChooserUI this$0;

        public void setBounds(int n2, int n3, int n4, int n5) {
            super.setBounds(n2, n3, Math.min(n4, this.getPreferredSize().width + 4), n5);
        }

        protected FileRenderer(WindowsFileChooserUI windowsFileChooserUI) {
            this.this$0 = windowsFileChooserUI;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            File file = (File)object;
            String string = this.this$0.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = this.this$0.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (bl2) {
                this.this$0.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;
        private final WindowsFileChooserUI this$0;

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        protected FilterComboBoxModel(WindowsFileChooserUI windowsFileChooserUI) {
            this.this$0 = windowsFileChooserUI;
            this.filters = windowsFileChooserUI.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = this.this$0.getFileChooser().getFileFilter();
            boolean bl2 = false;
            if (fileFilter != null) {
                for (int i2 = 0; i2 < this.filters.length; ++i2) {
                    if (this.filters[i2] != fileFilter) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    this.this$0.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return this.this$0.getFileChooser().getFileFilter();
        }

        public Object getElementAt(int n2) {
            if (n2 > this.getSize() - 1) {
                return this.this$0.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n2];
            }
            return null;
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                this.this$0.getFileChooser().setFileFilter((FileFilter)object);
                this.this$0.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        private final WindowsFileChooserUI this$0;

        public FilterComboBoxRenderer(WindowsFileChooserUI windowsFileChooserUI) {
            this.this$0 = windowsFileChooserUI;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            if (object != null && object instanceof FileFilter) {
                this.setText(((FileFilter)object).getDescription());
            }
            return this;
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon;
        int depth;
        private final WindowsFileChooserUI this$0;

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        IndentIcon(WindowsFileChooserUI windowsFileChooserUI) {
            this.this$0 = windowsFileChooserUI;
            this.icon = null;
            this.depth = 0;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (component.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(component, graphics, n2 + this.depth * 10, n3);
            } else {
                this.icon.paintIcon(component, graphics, n2, n3);
            }
        }
    }

    class ShortCutPanel
    extends JToolBar
    implements ActionListener {
        JToggleButton[] buttons;
        File[] files;
        XPStyle xp;
        final Dimension buttonSize;
        private final WindowsFileChooserUI this$0;

        ShortCutPanel(WindowsFileChooserUI windowsFileChooserUI) {
            this.this$0 = windowsFileChooserUI;
            super(1);
            this.xp = XPStyle.getXP();
            this.buttonSize = new Dimension(83, this.xp != null ? 69 : 54);
            this.setFloatable(false);
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            if (this.xp != null) {
                this.putClientProperty("XPStyle.subClass", "placesbar");
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            } else {
                this.setBorder(WindowsFileChooserUI.access$1100(windowsFileChooserUI));
            }
            Color color = new Color(UIManager.getColor("ToolBar.shadow").getRGB());
            this.setBackground(color);
            JFileChooser jFileChooser = windowsFileChooserUI.getFileChooser();
            FileSystemView fileSystemView = jFileChooser.getFileSystemView();
            this.files = (File[])ShellFolder.get("fileChooserShortcutPanelFolders");
            this.buttons = new JToggleButton[this.files.length];
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i2 = 0; i2 < this.files.length; ++i2) {
                Serializable serializable;
                String string;
                int n2;
                if (fileSystemView.isFileSystemRoot(this.files[i2])) {
                    this.files[i2] = fileSystemView.createFileObject(this.files[i2].getAbsolutePath());
                }
                if ((n2 = (string = fileSystemView.getSystemDisplayName(this.files[i2])).lastIndexOf(File.separatorChar)) >= 0 && n2 < string.length() - 1) {
                    string = string.substring(n2 + 1);
                }
                Icon icon = null;
                if (this.files[i2] instanceof ShellFolder) {
                    serializable = (ShellFolder)this.files[i2];
                    icon = new ImageIcon(serializable.getIcon(true), serializable.getFolderType());
                } else {
                    icon = fileSystemView.getSystemIcon(this.files[i2]);
                }
                this.buttons[i2] = new JToggleButton(string, icon);
                if (this.xp != null) {
                    this.buttons[i2].setIconTextGap(2);
                    this.buttons[i2].setMargin(new Insets(2, 2, 2, 2));
                    this.buttons[i2].setText("<html><center>" + string + "</center></html>");
                } else {
                    serializable = new Color(UIManager.getColor("List.selectionForeground").getRGB());
                    this.buttons[i2].setBackground(color);
                    this.buttons[i2].setForeground((Color)serializable);
                }
                this.buttons[i2].setHorizontalTextPosition(0);
                this.buttons[i2].setVerticalTextPosition(3);
                this.buttons[i2].setAlignmentX(0.5f);
                this.buttons[i2].setPreferredSize(this.buttonSize);
                this.buttons[i2].setMaximumSize(this.buttonSize);
                this.buttons[i2].addActionListener(this);
                this.add(this.buttons[i2]);
                if (i2 < this.files.length - 1 && this.xp != null) {
                    this.add(Box.createRigidArea(WindowsFileChooserUI.access$1200()));
                }
                buttonGroup.add(this.buttons[i2]);
            }
            this.doDirectoryChanged(jFileChooser.getCurrentDirectory());
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getMinimumSize();
            Dimension dimension2 = super.getPreferredSize();
            if (dimension.height > dimension2.height) {
                dimension2 = new Dimension(dimension2.width, dimension.height);
            }
            return dimension2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            for (int i2 = 0; i2 < this.buttons.length; ++i2) {
                if (jToggleButton != this.buttons[i2]) continue;
                this.this$0.getFileChooser().setCurrentDirectory(this.files[i2]);
                break;
            }
        }

        void doDirectoryChanged(File file) {
            for (int i2 = 0; i2 < this.buttons.length; ++i2) {
                this.buttons[i2].setSelected(this.files[i2].equals(file));
            }
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;
        private final WindowsFileChooserUI this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 1) {
                    JFileChooser jFileChooser = this.this$0.getFileChooser();
                    int n2 = this.list.locationToIndex(mouseEvent.getPoint());
                    if ((!jFileChooser.isMultiSelectionEnabled() || jFileChooser.getSelectedFiles().length <= 1) && n2 >= 0 && this.list.isSelectedIndex(n2) && WindowsFileChooserUI.access$2500(this.this$0) == n2 && this.this$0.editFile == null) {
                        WindowsFileChooserUI.access$2200(this.this$0, n2);
                    } else if (n2 >= 0) {
                        WindowsFileChooserUI.access$2600(this.this$0, n2);
                    } else {
                        WindowsFileChooserUI.access$2700(this.this$0);
                    }
                } else {
                    WindowsFileChooserUI.access$2700(this.this$0);
                }
            }
        }

        public SingleClickListener(WindowsFileChooserUI windowsFileChooserUI, JList jList) {
            this.this$0 = windowsFileChooserUI;
            this.list = jList;
        }
    }

    protected class WindowsFileView
    extends BasicFileChooserUI.BasicFileView {
        private final WindowsFileChooserUI this$0;

        protected WindowsFileView(WindowsFileChooserUI windowsFileChooserUI) {
            this.this$0 = windowsFileChooserUI;
            super(windowsFileChooserUI);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            if (file != null) {
                icon = this.this$0.getFileChooser().getFileSystemView().getSystemIcon(file);
            }
            if (icon == null) {
                icon = super.getIcon(file);
            }
            this.cacheIcon(file, icon);
            return icon;
        }
    }

    protected class WindowsNewFolderAction
    extends BasicFileChooserUI.NewFolderAction {
        private final WindowsFileChooserUI this$0;

        protected WindowsNewFolderAction(WindowsFileChooserUI windowsFileChooserUI) {
            this.this$0 = windowsFileChooserUI;
            super(windowsFileChooserUI);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = this.this$0.getFileChooser();
            File file = jFileChooser.getSelectedFile();
            super.actionPerformed(actionEvent);
            File file2 = jFileChooser.getSelectedFile();
            if (file2 != null && !file2.equals(file) && file2.isDirectory()) {
                WindowsFileChooserUI.access$1402(this.this$0, file2);
            }
        }
    }
}

