/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthDragGestureRecognizer;
import com.sun.java.swing.plaf.gtk.SynthDropTargetListener;
import com.sun.java.swing.plaf.gtk.SynthGraphics;
import com.sun.java.swing.plaf.gtk.SynthIcon;
import com.sun.java.swing.plaf.gtk.SynthLabelUI;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthTextUI;
import com.sun.java.swing.plaf.gtk.SynthTransferable;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellEditor;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.Position;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.VariableHeightLayoutCache;

class SynthTreeUI
extends TreeUI
implements PropertyChangeListener,
SynthUI,
LazyActionMap.Loader {
    private static final TreeDragGestureRecognizer defaultDragRecognizer = new TreeDragGestureRecognizer();
    private static DropTargetListener defaultDropTargetListener = null;
    private static final TransferHandler defaultTransferHandler = new TreeTransferHandler();
    private Icon collapsedIcon;
    private Icon expandedIcon;
    private JTree tree;
    private Map drawingCache;
    private int trailingControlOffset;
    private int controlSize;
    private int indent;
    private int trailingLegBufferOffset;
    private boolean drawHorizontalLegs;
    private boolean drawVerticalLegs;
    private boolean drawsFocusBorder;
    private int rootOffset;
    private boolean stopEditingWhenSelectionChanges;
    private CellRendererPane rendererPane;
    private Dimension preferredSize = new Dimension();
    protected boolean validCachedPreferredSize;
    private AbstractLayoutCache treeState;
    private boolean largeModel;
    private AbstractLayoutCache.NodeDimensions nodeDimensions;
    private EditingState editingState;
    private boolean leftToRight;
    private int leadRow;
    private MouseListener mouseListener;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private ComponentListener componentListener;
    private CellEditorListener cellEditorListener;
    private TreeSelectionListener treeSelectionListener;
    private TreeModelListener treeModelListener;
    private TreeExpansionListener treeExpansionListener;
    private SynthStyle style;
    private SynthStyle cellStyle;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;
    static Class class$javax$swing$JScrollPane;
    static Class class$com$sun$java$swing$plaf$gtk$SynthTreeUI;

    private int getEditingRow() {
        return this.editingState != null ? this.editingState.row : -1;
    }

    private int getIndent() {
        return this.indent;
    }

    private int getLeadSelectionRow() {
        return this.leadRow;
    }

    private int getTrailingControlOffset() {
        return this.trailingControlOffset;
    }

    private void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.getEditingComponent() != null) {
            this.tree.getCellEditor().stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    private void configureLayoutCache() {
        if (this.nodeDimensions == null) {
            this.nodeDimensions = this.createNodeDimensions();
        }
        this.treeState.setNodeDimensions(this.nodeDimensions);
        this.treeState.setRootVisible(this.tree.isRootVisible());
        this.treeState.setRowHeight(this.tree.getRowHeight());
        this.treeState.setSelectionModel(this.tree.getSelectionModel());
        if (this.treeState.getModel() != this.tree.getModel()) {
            this.treeState.setModel(this.tree.getModel());
        }
        this.updateLayoutCacheExpandedNodes();
        if (this.largeModel) {
            if (this.componentListener == null) {
                this.componentListener = this.createComponentListener();
                if (this.componentListener != null) {
                    this.tree.addComponentListener(this.componentListener);
                }
            }
        } else if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
            this.componentListener = null;
        }
    }

    protected void installComponents() {
    }

    protected void installDefaults() {
        DropTarget dropTarget;
        this.updateRenderer();
        this.fetchStyle(this.tree);
        this.rendererPane = this.createCellRendererPane();
        this.tree.add(this.rendererPane);
        this.treeState = this.createLayoutCache();
        this.configureLayoutCache();
        TransferHandler transferHandler = this.tree.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.tree.setTransferHandler(defaultTransferHandler);
        }
        if ((dropTarget = this.tree.getDropTarget()) instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TreeDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tree, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tree, 0, inputMap);
        LazyActionMap.installLazyActionMap(this.tree, this);
    }

    protected void installListeners() {
        TreeCellEditor treeCellEditor;
        this.tree.addPropertyChangeListener(this);
        this.tree.addMouseListener(defaultDragRecognizer);
        this.tree.addMouseMotionListener(defaultDragRecognizer);
        this.mouseListener = this.createMouseListener();
        if (this.mouseListener != null) {
            this.tree.addMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.tree.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tree.addFocusListener(this.focusListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.tree.addKeyListener(this.keyListener);
        }
        if ((this.treeExpansionListener = this.createTreeExpansionListener()) != null) {
            this.tree.addTreeExpansionListener(this.treeExpansionListener);
        }
        TreeModel treeModel = this.tree.getModel();
        this.treeModelListener = this.createTreeModelListener();
        if (this.treeModelListener != null && treeModel != null) {
            treeModel.addTreeModelListener(this.treeModelListener);
        }
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        this.treeSelectionListener = this.createTreeSelectionListener();
        if (this.treeSelectionListener != null) {
            treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
        }
        if ((treeCellEditor = this.tree.getCellEditor()) != null) {
            this.cellEditorListener = this.createCellEditorListener();
            if (this.cellEditorListener != null) {
                treeCellEditor.addCellEditorListener(this.cellEditorListener);
            }
        }
    }

    private void invalidateSize() {
        this.validCachedPreferredSize = false;
        this.tree.treeDidChange();
    }

    private void invalidateStateAndSize() {
        this.treeState.invalidateSizes();
        this.invalidateSize();
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.tree.remove(this.rendererPane);
        }
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.tree, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.tree, Region.TREE_CELL, 1);
        this.cellStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.cellStyle = null;
        if (this.tree.getTransferHandler() instanceof UIResource) {
            this.tree.setTransferHandler(null);
        }
        if (this.tree.getCellRenderer() instanceof UIResource) {
            this.tree.setCellRenderer(null);
        }
        if (this.tree.getCellEditor() instanceof UIResource) {
            this.tree.setCellEditor(null);
        }
        this.tree = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tree, null);
        SwingUtilities.replaceUIInputMap(this.tree, 1, null);
        SwingUtilities.replaceUIInputMap(this.tree, 0, null);
    }

    protected void uninstallListeners() {
        TreeCellEditor treeCellEditor;
        TreeModel treeModel;
        if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
        }
        this.tree.removePropertyChangeListener(this);
        this.tree.removeMouseListener(defaultDragRecognizer);
        this.tree.removeMouseMotionListener(defaultDragRecognizer);
        if (this.mouseListener != null) {
            this.tree.removeMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.tree.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if (this.focusListener != null) {
            this.tree.removeFocusListener(this.focusListener);
        }
        if (this.keyListener != null) {
            this.tree.removeKeyListener(this.keyListener);
        }
        if (this.treeExpansionListener != null) {
            this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        }
        if ((treeModel = this.tree.getModel()) != null && this.treeModelListener != null) {
            treeModel.removeTreeModelListener(this.treeModelListener);
        }
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        if (this.treeSelectionListener != null) {
            this.tree.getSelectionModel().removeTreeSelectionListener(this.treeSelectionListener);
        }
        if ((treeCellEditor = this.tree.getCellEditor()) != null && this.cellEditorListener != null) {
            treeCellEditor.removeCellEditorListener(this.cellEditorListener);
        }
    }

    private void updateCachedPreferredSize() {
        Insets insets = this.tree.getInsets();
        if (this.largeModel) {
            Rectangle rectangle = this.tree.getVisibleRect();
            rectangle.x -= insets.left;
            rectangle.y -= insets.top;
            this.preferredSize.width = this.treeState.getPreferredWidth(rectangle);
        } else if (this.leftToRight) {
            this.preferredSize.width = this.treeState.getPreferredWidth(null);
        }
        this.preferredSize.height = this.treeState.getPreferredHeight();
        this.preferredSize.width += insets.left + insets.right;
        this.preferredSize.height += insets.top + insets.bottom;
        this.validCachedPreferredSize = true;
    }

    private void updateLargeModel() {
        boolean bl2 = this.tree.isLargeModel();
        if (this.tree.getRowHeight() < 1) {
            bl2 = false;
        }
        if (this.largeModel != bl2) {
            this.completeEditing();
            this.largeModel = bl2;
            this.treeState = this.createLayoutCache();
            this.configureLayoutCache();
            this.invalidateSize();
        }
    }

    private void updateLayoutCacheExpandedNodes() {
        TreeModel treeModel = this.tree.getModel();
        if (treeModel != null && treeModel.getRoot() != null) {
            this.updateExpandedDescendants(new TreePath(treeModel.getRoot()));
        }
    }

    private void updateLeadRow() {
        this.leadRow = this.tree.getLeadSelectionRow();
    }

    private void updateRenderer() {
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer == null) {
            this.tree.setCellRenderer(this.createCellRenderer());
        }
        if (this.tree.isEditable() && this.tree.getCellEditor() instanceof UIResource) {
            this.tree.setCellEditor(this.createCellEditor());
        }
    }

    private void updateRootOffset() {
        this.rootOffset = this.tree.isRootVisible() ? (this.tree.getShowsRootHandles() ? 1 : 0) : (!this.tree.getShowsRootHandles() ? -1 : 0);
    }

    private boolean isLargeModel() {
        return this.largeModel;
    }

    private int getRowX(int n2, int n3) {
        return this.getIndent() * (n3 + this.rootOffset - 1) + this.controlSize;
    }

    private void completeEditing(boolean bl2, boolean bl3, boolean bl4) {
        if (this.editingState != null) {
            EditingState editingState = this.editingState;
            Object object = this.editingState.editor.getCellEditorValue();
            Rectangle rectangle = this.tree.getPathBounds(editingState.path);
            boolean bl5 = this.tree != null && (this.tree.hasFocus() || SwingUtilities.findFocusOwner(this.editingState.component) != null);
            this.editingState = null;
            if (bl2) {
                editingState.editor.stopCellEditing();
            } else if (bl3) {
                editingState.editor.cancelCellEditing();
            }
            this.tree.remove(editingState.component);
            if (editingState.editorHasDifferentSize) {
                this.treeState.invalidatePathBounds(editingState.path);
                this.invalidateSize();
            } else {
                rectangle.x = 0;
                rectangle.width = this.tree.getSize().width;
                this.tree.repaint(rectangle);
            }
            if (bl5) {
                this.tree.requestFocus();
            }
            if (bl4) {
                this.tree.getModel().valueForPathChanged(editingState.path, object);
            }
        }
    }

    private void configureRenderer(SynthContext synthContext) {
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            SynthStyle synthStyle = synthContext.getStyle();
            synthContext.setComponentState(513);
            Color color = defaultTreeCellRenderer.getTextSelectionColor();
            if (color == null || color instanceof UIResource) {
                defaultTreeCellRenderer.setTextSelectionColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            if ((color = defaultTreeCellRenderer.getBackgroundSelectionColor()) == null || color instanceof UIResource) {
                defaultTreeCellRenderer.setBackgroundSelectionColor(synthStyle.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
            synthContext.setComponentState(1);
            color = defaultTreeCellRenderer.getTextNonSelectionColor();
            if (color == null || color instanceof UIResource) {
                defaultTreeCellRenderer.setTextNonSelectionColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            if ((color = defaultTreeCellRenderer.getBackgroundNonSelectionColor()) instanceof UIResource) {
                defaultTreeCellRenderer.setBackgroundNonSelectionColor(synthStyle.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
        }
    }

    static int access$1800(SynthTreeUI synthTreeUI) {
        return synthTreeUI.getLeadSelectionRow();
    }

    static int access$2400(SynthTreeUI synthTreeUI) {
        return synthTreeUI.getEditingRow();
    }

    static void access$1400(SynthTreeUI synthTreeUI) {
        synthTreeUI.completeEditing();
    }

    static void access$1600(SynthTreeUI synthTreeUI) {
        synthTreeUI.updateLeadRow();
    }

    static void access$1700(SynthTreeUI synthTreeUI) {
        synthTreeUI.invalidateSize();
    }

    static boolean access$2100(SynthTreeUI synthTreeUI) {
        return synthTreeUI.stopEditingWhenSelectionChanges;
    }

    static int access$2500(SynthTreeUI synthTreeUI, int n2, int n3) {
        return synthTreeUI.getRowX(n2, n3);
    }

    static void access$2200(SynthTreeUI synthTreeUI, boolean bl2, boolean bl3, boolean bl4) {
        synthTreeUI.completeEditing(bl2, bl3, bl4);
    }

    private Component getEditingComponent() {
        return this.editingState != null ? this.editingState.component : null;
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler(null);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(null);
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler(null);
    }

    protected boolean isMultiSelectEvent(MouseEvent mouseEvent) {
        return SynthLookAndFeel.isPrimaryMouseButton(mouseEvent) && mouseEvent.isShiftDown();
    }

    protected boolean isToggleEvent(MouseEvent mouseEvent) {
        if (!SynthLookAndFeel.isPrimaryMouseButton(mouseEvent)) {
            return false;
        }
        int n2 = this.tree.getToggleClickCount();
        if (n2 <= 0) {
            return false;
        }
        return mouseEvent.getClickCount() == n2;
    }

    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return SynthLookAndFeel.isPrimaryMouseButton(mouseEvent) && mouseEvent.isControlDown();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler(null);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.tree) {
            DropTarget dropTarget;
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                this.fetchStyle((JTree)propertyChangeEvent.getSource());
            }
            if ("leadSelectionPath".equals(string)) {
                this.updateLeadRow();
                this.repaintPath((TreePath)propertyChangeEvent.getOldValue());
                this.repaintPath((TreePath)propertyChangeEvent.getNewValue());
            } else if ("anchorSelectionPath".equals(string)) {
                this.repaintPath((TreePath)propertyChangeEvent.getOldValue());
                this.repaintPath((TreePath)propertyChangeEvent.getNewValue());
            } else if ("cellRenderer".equals(string)) {
                this.completeEditing();
                this.updateRenderer();
                this.invalidateStateAndSize();
            } else if ("model".equals(string)) {
                TreeModel treeModel;
                TreeModel treeModel2 = (TreeModel)propertyChangeEvent.getOldValue();
                this.completeEditing();
                if (treeModel2 != null && this.treeModelListener != null) {
                    treeModel2.removeTreeModelListener(this.treeModelListener);
                }
                if ((treeModel = (TreeModel)propertyChangeEvent.getNewValue()) != null && this.treeModelListener != null) {
                    treeModel.addTreeModelListener(this.treeModelListener);
                }
                if (this.treeState != null) {
                    this.treeState.setModel(treeModel);
                    this.updateLayoutCacheExpandedNodes();
                    this.invalidateSize();
                }
            } else if ("rootVisible".equals(string)) {
                this.completeEditing();
                this.updateRootOffset();
                if (this.treeState != null) {
                    this.treeState.setRootVisible((Boolean)propertyChangeEvent.getNewValue());
                    this.invalidateStateAndSize();
                }
            } else if ("showsRootHandles".equals(string)) {
                this.completeEditing();
                this.updateRootOffset();
                this.invalidateStateAndSize();
            } else if ("rowHeight".equals(string)) {
                this.completeEditing();
                if (this.treeState != null) {
                    this.updateLargeModel();
                    this.treeState.setRowHeight(this.tree.getRowHeight());
                    this.invalidateSize();
                }
            } else if ("cellEditor".equals(string)) {
                TreeCellEditor treeCellEditor;
                this.completeEditing();
                TreeCellEditor treeCellEditor2 = (TreeCellEditor)propertyChangeEvent.getOldValue();
                if (treeCellEditor2 != null && this.cellEditorListener != null) {
                    treeCellEditor2.removeCellEditorListener(this.cellEditorListener);
                }
                if ((treeCellEditor = (TreeCellEditor)propertyChangeEvent.getNewValue()) != null) {
                    if (this.cellEditorListener == null) {
                        this.cellEditorListener = this.createCellEditorListener();
                    }
                    if (this.cellEditorListener != null) {
                        treeCellEditor.addCellEditorListener(this.cellEditorListener);
                    }
                }
            } else if ("editable".equals(string)) {
                this.completeEditing();
                TreeCellEditor treeCellEditor = this.tree.getCellEditor();
                if (this.tree.isEditable()) {
                    if (treeCellEditor == null) {
                        treeCellEditor = this.createCellEditor();
                        if (treeCellEditor != null) {
                            this.tree.setCellEditor(treeCellEditor);
                        }
                    } else {
                        if (this.cellEditorListener == null) {
                            this.cellEditorListener = this.createCellEditorListener();
                        }
                        if (this.cellEditorListener != null) {
                            treeCellEditor.addCellEditorListener(this.cellEditorListener);
                        }
                    }
                } else if (treeCellEditor instanceof UIResource) {
                    this.tree.setCellEditor(null);
                }
            } else if ("largeModel".equals(string)) {
                this.updateLargeModel();
            } else if ("selectionModel".equals(string)) {
                this.selectionModelChanged((TreeSelectionModel)propertyChangeEvent.getOldValue(), this.tree.getSelectionModel());
            } else if ("font".equals(string)) {
                this.completeEditing();
                this.invalidateStateAndSize();
            } else if ("componentOrientation".equals(string)) {
                this.leftToRight = this.tree.getComponentOrientation().isLeftToRight();
                this.invalidateStateAndSize();
                InputMap inputMap = this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(this.tree, 0, inputMap);
            } else if ("transferHandler".equals(string) && (dropTarget = this.tree.getDropTarget()) instanceof UIResource) {
                if (defaultDropTargetListener == null) {
                    defaultDropTargetListener = new TreeDropTargetListener();
                }
                try {
                    dropTarget.addDropTargetListener(defaultDropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    // empty catch block
                }
            }
        }
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    private Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    private Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    InputMap getInputMap(int n2) {
        SynthContext synthContext = this.getContext((JComponent)this.tree, 1);
        SynthStyle synthStyle = synthContext.getStyle();
        InputMap inputMap = null;
        if (n2 == 1) {
            inputMap = (InputMap)synthStyle.get(synthContext, "Tree.ancestorInputMap");
        } else if (n2 == 0) {
            InputMap inputMap2;
            inputMap = (InputMap)synthStyle.get(synthContext, "Tree.focusInputMap");
            if (!this.leftToRight && (inputMap2 = (InputMap)synthStyle.get(synthContext, "Tree.focusInputMap.RightToLeft")) != null) {
                inputMap2.setParent(inputMap);
                inputMap = inputMap2;
            }
        }
        synthContext.dispose();
        return inputMap;
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("null component passed to SynthTreeUI.installUI()");
        }
        this.tree = (JTree)jComponent;
        this.drawingCache = new HashMap(7);
        this.leftToRight = this.tree.getComponentOrientation().isLeftToRight();
        this.stopEditingWhenSelectionChanges = true;
        this.validCachedPreferredSize = false;
        this.installDefaults();
        this.installKeyboardActions();
        this.installComponents();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.completeEditing();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
    }

    public int getRowCount(JTree jTree) {
        return this.treeState != null ? this.treeState.getRowCount() : 0;
    }

    public void cancelEditing(JTree jTree) {
        if (this.editingState != null) {
            this.completeEditing(false, true, false);
        }
    }

    private void fetchStyle(JTree jTree) {
        SynthContext synthContext = this.getContext((JComponent)jTree, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.drawHorizontalLegs = this.style.getBoolean(synthContext, "Tree.drawHorizontalLegs", true);
            this.drawVerticalLegs = this.style.getBoolean(synthContext, "Tree.drawVerticalLegs", true);
            jTree.setRowHeight(this.style.getInt(synthContext, "Tree.rowHeight", -1));
            jTree.setScrollsOnExpand(this.style.getBoolean(synthContext, "Tree.scrollsOnExpand", true));
            this.largeModel = jTree.isLargeModel() && jTree.getRowHeight() > 0;
            this.expandedIcon = this.style.getIcon(synthContext, "Tree.expandedIcon");
            this.collapsedIcon = this.style.getIcon(synthContext, "Tree.collapsedIcon");
            this.trailingLegBufferOffset = this.style.getInt(synthContext, "Tree.trailingLegBufferOffset", 0);
            this.trailingControlOffset = this.style.getInt(synthContext, "Tree.trailingControlOffset", 0);
            this.controlSize = this.style.getInt(synthContext, "Tree.controlSize", 0);
            this.indent = this.style.getInt(synthContext, "Tree.indent", 0);
            this.updateRootOffset();
            this.drawsFocusBorder = this.style.getBoolean(synthContext, "Tree.drawsFocusBorder", true);
        }
        synthContext.dispose();
        synthContext = this.getContext(jTree, Region.TREE_CELL, 1);
        this.cellStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    public boolean isEditing(JTree jTree) {
        return this.editingState != null;
    }

    public boolean stopEditing(JTree jTree) {
        if (this.editingState != null && jTree.getCellEditor().stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    static void access$2000(JTree jTree, int n2, int n3) {
        SynthTreeUI.ensureRowsAreVisible(jTree, n2, n3);
    }

    private static void ensureRowsAreVisible(JTree jTree, int n2, int n3) {
        if (n2 >= 0 && n3 < jTree.getRowCount()) {
            SynthTreeUI synthTreeUI = (SynthTreeUI)jTree.getUI();
            SynthContext synthContext = synthTreeUI.getContext(jTree);
            boolean bl2 = synthContext.getStyle().getBoolean(synthContext, "Tree.scrollsHorizontallyAndVertically", false);
            synthContext.dispose();
            if (n2 == n3) {
                Rectangle rectangle = jTree.getPathBounds(jTree.getPathForRow(n2));
                if (rectangle != null) {
                    if (!bl2) {
                        rectangle.x = jTree.getVisibleRect().x;
                        rectangle.width = 1;
                    }
                    jTree.scrollRectToVisible(rectangle);
                }
            } else {
                Rectangle rectangle = jTree.getPathBounds(jTree.getPathForRow(n2));
                Rectangle rectangle2 = jTree.getVisibleRect();
                Rectangle rectangle3 = rectangle;
                int n4 = rectangle.y;
                int n5 = n4 + rectangle2.height;
                for (int i2 = n2 + 1; i2 <= n3; ++i2) {
                    rectangle3 = jTree.getPathBounds(jTree.getPathForRow(i2));
                    if (rectangle3.y + rectangle3.height <= n5) continue;
                    i2 = n3;
                }
                jTree.scrollRectToVisible(new Rectangle(rectangle2.x, n4, 1, rectangle3.y + rectangle3.height - n4));
            }
        }
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler(this);
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new TreeExpansionHandler(null);
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler(this, null);
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionHandler(this, null);
    }

    protected AbstractLayoutCache createLayoutCache() {
        if (this.largeModel && this.tree.getRowHeight() > 0) {
            return new FixedHeightLayoutCache();
        }
        return new VariableHeightLayoutCache();
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler(this, null);
    }

    protected TreeCellEditor createCellEditor() {
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        SynthTreeCellEditor synthTreeCellEditor = treeCellRenderer != null && treeCellRenderer instanceof DefaultTreeCellRenderer ? new SynthTreeCellEditor(this.tree, (DefaultTreeCellRenderer)treeCellRenderer) : new SynthTreeCellEditor(this.tree, null);
        SynthContext synthContext = this.getContext((JComponent)this.tree, 1);
        synthContext.setComponentState(513);
        synthContext.dispose();
        return synthTreeCellEditor;
    }

    protected TreeCellRenderer createCellRenderer() {
        return new SynthTreeCellRenderer(this);
    }

    private void repaintPath(TreePath treePath) {
        Rectangle rectangle;
        if (treePath != null && (rectangle = this.tree.getPathBounds(treePath)) != null) {
            this.tree.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void toggleExpandState(TreePath treePath) {
        if (!this.tree.isExpanded(treePath)) {
            int n2 = this.tree.getRowForPath(treePath);
            this.tree.expandPath(treePath);
            this.invalidateSize();
            if (n2 != -1) {
                if (this.tree.getScrollsOnExpand()) {
                    SynthTreeUI.ensureRowsAreVisible(this.tree, n2, n2 + this.treeState.getVisibleChildCount(treePath));
                } else {
                    SynthTreeUI.ensureRowsAreVisible(this.tree, n2, n2);
                }
            }
        } else {
            this.tree.collapsePath(treePath);
            this.invalidateSize();
        }
    }

    private void updateExpandedDescendants(TreePath treePath) {
        this.completeEditing();
        this.treeState.setExpandedState(treePath, true);
        Enumeration enumeration = this.tree.getExpandedDescendants(treePath);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                treePath = (TreePath)enumeration.nextElement();
                this.treeState.setExpandedState(treePath, true);
            }
        }
        this.updateLeadRow();
        this.invalidateSize();
    }

    protected void handleExpandControlClick(TreePath treePath, int n2, int n3) {
        this.toggleExpandState(treePath);
    }

    private boolean shouldPaintExpandControl(TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (bl4) {
            return false;
        }
        int n3 = treePath.getPathCount() - 1;
        return n3 != 0 && (n3 != 1 || this.tree.isRootVisible()) || this.tree.getShowsRootHandles();
    }

    private int getComponentState(JComponent jComponent, Region region) {
        return 513;
    }

    private Region getRegion(JTree jTree) {
        return SynthLookAndFeel.getRegion(jTree);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthTreeUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    static Component access$2300(SynthTreeUI synthTreeUI) {
        return synthTreeUI.getEditingComponent();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(this.tree);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        return new Dimension(this.preferredSize);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration enumeration = this.treeState.getVisiblePathsFrom(treePath);
        int n2 = this.treeState.getRowForPath(treePath);
        int n3 = rectangle.y + rectangle.height;
        TreeModel treeModel = this.tree.getModel();
        SynthContext synthContext2 = this.getContext((JComponent)this.tree, Region.TREE_CELL);
        this.drawingCache.clear();
        if (enumeration != null) {
            Rectangle rectangle2;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            TreePath treePath2;
            boolean bl5 = false;
            Rectangle rectangle3 = new Rectangle();
            Rectangle rectangle4 = new Rectangle(0, 0, this.tree.getWidth(), 0);
            TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
            DefaultTreeCellRenderer defaultTreeCellRenderer = treeCellRenderer instanceof DefaultTreeCellRenderer ? (DefaultTreeCellRenderer)treeCellRenderer : null;
            this.configureRenderer(synthContext2);
            while (!bl5 && enumeration.hasMoreElements()) {
                treePath2 = (TreePath)enumeration.nextElement();
                if (treePath2 != null) {
                    bl4 = treeModel.isLeaf(treePath2.getLastPathComponent());
                    if (bl4) {
                        bl3 = false;
                        bl2 = false;
                    } else {
                        bl2 = this.treeState.getExpandedState(treePath2);
                        bl3 = this.tree.hasBeenExpanded(treePath2);
                    }
                    rectangle2 = this.treeState.getBounds(treePath2, rectangle3);
                    this.adjustCellBounds(this.tree, rectangle2, insets);
                    rectangle4.y = rectangle2.y;
                    rectangle4.height = rectangle2.height;
                    this.paintRow(treeCellRenderer, defaultTreeCellRenderer, synthContext, synthContext2, graphics, rectangle, insets, rectangle2, rectangle4, treePath2, n2, bl2, bl3, bl4);
                    if (rectangle2.y + rectangle2.height >= n3) {
                        bl5 = true;
                    }
                } else {
                    bl5 = true;
                }
                ++n2;
            }
            boolean bl6 = this.tree.isRootVisible();
            TreePath treePath3 = treePath;
            for (treePath3 = treePath3.getParentPath(); treePath3 != null; treePath3 = treePath3.getParentPath()) {
                this.paintVerticalPartOfLeg(synthContext, graphics, rectangle, insets, treePath3);
                this.drawingCache.put(treePath3, Boolean.TRUE);
            }
            bl5 = false;
            enumeration = this.treeState.getVisiblePathsFrom(treePath);
            while (!bl5 && enumeration.hasMoreElements()) {
                treePath2 = (TreePath)enumeration.nextElement();
                if (treePath2 != null) {
                    bl4 = treeModel.isLeaf(treePath2.getLastPathComponent());
                    if (bl4) {
                        bl3 = false;
                        bl2 = false;
                    } else {
                        bl2 = this.treeState.getExpandedState(treePath2);
                        bl3 = this.tree.hasBeenExpanded(treePath2);
                    }
                    rectangle2 = this.treeState.getBounds(treePath2, rectangle3);
                    this.adjustCellBounds(this.tree, rectangle2, insets);
                    treePath3 = treePath2.getParentPath();
                    if (treePath3 != null) {
                        if (this.drawingCache.get(treePath3) == null) {
                            this.paintVerticalPartOfLeg(synthContext, graphics, rectangle, insets, treePath3);
                            this.drawingCache.put(treePath3, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(synthContext, graphics, rectangle, insets, rectangle2, treePath2, n2, bl2, bl3, bl4);
                    } else if (bl6 && n2 == 0) {
                        this.paintHorizontalPartOfLeg(synthContext, graphics, rectangle, insets, rectangle2, treePath2, n2, bl2, bl3, bl4);
                    }
                    if (this.shouldPaintExpandControl(treePath2, n2, bl2, bl3, bl4)) {
                        this.paintExpandControl(synthContext, graphics, rectangle, insets, rectangle2, treePath2, n2, bl2, bl3, bl4);
                    }
                    if (rectangle2.y + rectangle2.height >= n3) {
                        bl5 = true;
                    }
                } else {
                    bl5 = true;
                }
                ++n2;
            }
        }
        synthContext2.dispose();
        this.rendererPane.removeAll();
    }

    protected void selectPathForEvent(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isMultiSelectEvent(mouseEvent)) {
            int n2;
            TreePath treePath2 = this.tree.getAnchorSelectionPath();
            int n3 = n2 = treePath2 == null ? -1 : this.tree.getRowForPath(treePath2);
            if (n2 == -1 || this.tree.getSelectionModel().getSelectionMode() == 1) {
                this.tree.setSelectionPath(treePath);
            } else {
                int n4 = this.getRowForPath(this.tree, treePath);
                TreePath treePath3 = treePath2;
                if (this.isToggleSelectionEvent(mouseEvent)) {
                    if (this.tree.isRowSelected(n2)) {
                        this.tree.addSelectionInterval(n2, n4);
                    } else {
                        this.tree.removeSelectionInterval(n2, n4);
                        this.tree.addSelectionInterval(n4, n4);
                    }
                } else if (n4 < n2) {
                    this.tree.setSelectionInterval(n4, n2);
                } else {
                    this.tree.setSelectionInterval(n2, n4);
                }
                this.tree.setAnchorSelectionPath(treePath3);
                this.tree.setLeadSelectionPath(treePath);
            }
        } else if (this.isToggleSelectionEvent(mouseEvent)) {
            if (this.tree.isPathSelected(treePath)) {
                this.tree.removeSelectionPath(treePath);
            } else {
                this.tree.addSelectionPath(treePath);
            }
            this.tree.setAnchorSelectionPath(treePath);
            this.tree.setLeadSelectionPath(treePath);
        } else if (SynthLookAndFeel.isPrimaryMouseButton(mouseEvent)) {
            this.tree.setSelectionPath(treePath);
            if (this.isToggleEvent(mouseEvent)) {
                this.toggleExpandState(treePath);
            }
        }
    }

    private boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        if (this.tree.isEditing() && this.tree.getInvokesStopCellEditing() && !this.tree.stopEditing()) {
            return false;
        }
        this.completeEditing();
        TreeCellEditor treeCellEditor = this.tree.getCellEditor();
        if (treeCellEditor != null && this.tree.isPathEditable(treePath)) {
            int n2 = this.getRowForPath(this.tree, treePath);
            if (treeCellEditor.isCellEditable(mouseEvent)) {
                EditingState editingState;
                this.editingState = editingState = new EditingState(null);
                editingState.component = treeCellEditor.getTreeCellEditorComponent(this.tree, treePath.getLastPathComponent(), this.tree.isPathSelected(treePath), this.tree.isExpanded(treePath), this.tree.getModel().isLeaf(treePath.getLastPathComponent()), n2);
                editingState.editor = treeCellEditor;
                Rectangle rectangle = this.getPathBounds(this.tree, treePath);
                editingState.row = n2;
                Dimension dimension = editingState.component.getPreferredSize();
                if (dimension.height != rectangle.height && this.tree.getRowHeight() > 0) {
                    dimension.height = this.tree.getRowHeight();
                }
                if (dimension.width != rectangle.width || dimension.height != rectangle.height) {
                    editingState.editorHasDifferentSize = true;
                    this.treeState.invalidatePathBounds(treePath);
                    this.invalidateSize();
                } else {
                    editingState.editorHasDifferentSize = false;
                }
                this.tree.add(editingState.component);
                editingState.component.setBounds(rectangle.x, rectangle.y, dimension.width, dimension.height);
                editingState.path = treePath;
                editingState.component.validate();
                Rectangle rectangle2 = this.tree.getVisibleRect();
                this.tree.repaint(rectangle.x, rectangle.y, rectangle2.width + rectangle2.x - rectangle.x, dimension.height);
                if (treeCellEditor.shouldSelectCell(mouseEvent)) {
                    this.stopEditingWhenSelectionChanges = false;
                    this.tree.setSelectionRow(n2);
                    this.stopEditingWhenSelectionChanges = true;
                }
                SynthLookAndFeel.compositeRequestFocus(editingState.component);
                return true;
            }
        }
        return false;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public void loadActionMap(JComponent jComponent, ActionMap actionMap) {
        actionMap.put("selectPrevious", new IncrementAction("selectPrevious", -1, false, true));
        actionMap.put("selectPreviousChangeLead", new IncrementAction("selectPreviousLead", -1, false, false));
        actionMap.put("selectPreviousExtendSelection", new IncrementAction("selectPreviousExtendSelection", -1, true, true));
        actionMap.put("selectNext", new IncrementAction("selectNext", 1, false, true));
        actionMap.put("selectNextChangeLead", new IncrementAction("selectNextLead", 1, false, false));
        actionMap.put("selectNextExtendSelection", new IncrementAction("selectNextExtendSelection", 1, true, true));
        actionMap.put("selectChild", new TraverseAction("selectChild", 1, true));
        actionMap.put("selectChildChangeLead", new TraverseAction("selectChildLead", 1, false));
        actionMap.put("selectParent", new TraverseAction("selectParent", -1, true));
        actionMap.put("selectParentChangeLead", new TraverseAction("selectParentLead", -1, false));
        actionMap.put("scrollUpChangeSelection", new ScrollAndSelectAction("scrollUpChangeSelection", 1, false, true, null));
        actionMap.put("scrollUpChangeLead", new ScrollAndSelectAction("scrollUpChangeLead", 1, false, false, null));
        actionMap.put("scrollUpExtendSelection", new ScrollAndSelectAction("scrollUpExtendSelection", 1, true, true, null));
        actionMap.put("scrollDownChangeSelection", new ScrollAndSelectAction("scrollDownChangeSelection", 5, false, true, null));
        actionMap.put("scrollDownExtendSelection", new ScrollAndSelectAction("scrollDownExtendSelection", 5, true, true, null));
        actionMap.put("scrollDownChangeLead", new ScrollAndSelectAction("scrollDownChangeLead", 5, false, false, null));
        actionMap.put("selectFirst", new HomeAction("selectFirst", -1, false, true));
        actionMap.put("selectFirstChangeLead", new HomeAction("selectFirst", -1, false, false));
        actionMap.put("selectFirstExtendSelection", new HomeAction("selectFirstExtendSelection", -1, true, true));
        actionMap.put("selectLast", new HomeAction("selectLast", 1, false, true));
        actionMap.put("selectLastChangeLead", new HomeAction("selectLast", 1, false, false));
        actionMap.put("selectLastExtendSelection", new HomeAction("selectLastExtendSelection", 1, true, true));
        actionMap.put("toggle", new ToggleAction("toggle"));
        actionMap.put("cancel", new CancelEditingAction(this, "cancel"));
        actionMap.put("startEditing", new EditAction("startEditing"));
        actionMap.put("selectAll", new SelectAllAction("selectAll", true));
        actionMap.put("clearSelection", new SelectAllAction("clearSelection", false));
        actionMap.put("toggleSelectionPreserveAnchor", new AddSelectionAction("toggleSelectionPreserveAnchor", false));
        actionMap.put("toggleSelection", new AddSelectionAction("toggleSelection", true));
        actionMap.put("extendSelection", new ExtendSelectionAction("extendSelection"));
        actionMap.put("scrollLeft", new ScrollAction("scrollLeft", 0, -10));
        actionMap.put("scrollLeftExtendSelection", new ScrollAndSelectAction("scrollLeftExtendSelection", 7, true, true, null));
        actionMap.put("scrollRight", new ScrollAction("scrollRight", 0, 10));
        actionMap.put("scrollRightExtendSelection", new ScrollAndSelectAction("scrollRightExtendSelection", 3, true, true, null));
        actionMap.put("scrollRightChangeLead", new ScrollAndSelectAction("scrollRightChangeLead", 3, false, false, null));
        actionMap.put("scrollLeftChangeLead", new ScrollAndSelectAction("scrollLeftChangeLead", 7, false, false, null));
        actionMap.put("expand", new TreeExpandAction(this, null));
        actionMap.put("collapse", new TreeCollapseAction(this, null));
        actionMap.put("moveSelectionToParent", new TreeMoveSelectionToParentAction(this, null));
        actionMap.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMap.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
    }

    static CellRendererPane access$2600(SynthTreeUI synthTreeUI) {
        return synthTreeUI.rendererPane;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    static JTree access$1900(SynthTreeUI synthTreeUI) {
        return synthTreeUI.tree;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTreeUI();
    }

    static AbstractLayoutCache access$1500(SynthTreeUI synthTreeUI) {
        return synthTreeUI.treeState;
    }

    protected void expandPathIfNecessary(SynthContext synthContext, TreePath treePath, int n2, int n3) {
        if (this.isLocationInExpandControl(synthContext, treePath, n2, n3)) {
            this.handleExpandControlClick(treePath, n2, n3);
        }
    }

    protected boolean isLocationInExpandControl(SynthContext synthContext, TreePath treePath, int n2, int n3) {
        TreeModel treeModel = this.tree.getModel();
        if (treePath != null && !treeModel.isLeaf(treePath.getLastPathComponent())) {
            int n4 = this.getExpandedIcon() != null ? SynthIcon.getIconWidth(this.getExpandedIcon(), synthContext) : 8;
            Insets insets = this.tree.getInsets();
            int n5 = this.getRowX(this.tree.getRowForPath(treePath), treePath.getPathCount() - 1) - this.getTrailingControlOffset() - n4 / 2;
            n5 = this.leftToRight ? (n5 += insets.left) : this.tree.getWidth() - this.getRowX(this.tree.getRowForPath(treePath), treePath.getPathCount() - 1) + this.getTrailingControlOffset() - n4 / 2;
            return n2 >= n5 && n2 <= n5 + n4;
        }
        return false;
    }

    static void access$1300(SynthTreeUI synthTreeUI, TreePath treePath) {
        synthTreeUI.updateExpandedDescendants(treePath);
    }

    static void access$2800(SynthTreeUI synthTreeUI, TreePath treePath) {
        synthTreeUI.toggleExpandState(treePath);
    }

    public TreePath getEditingPath(JTree jTree) {
        return this.editingState != null ? this.editingState.path : null;
    }

    public TreePath getPathForRow(JTree jTree, int n2) {
        return this.treeState != null ? this.treeState.getPathForRow(n2) : null;
    }

    public TreePath getClosestPathForLocation(JTree jTree, int n2, int n3) {
        if (jTree != null && this.treeState != null) {
            Insets insets = jTree.getInsets();
            n2 = this.leftToRight ? (n2 -= insets.left) : jTree.getWidth() - n2 - insets.right;
            return this.treeState.getPathClosestTo(n2, n3 - insets.top);
        }
        return null;
    }

    public int getRowForPath(JTree jTree, TreePath treePath) {
        return this.treeState != null ? this.treeState.getRowForPath(treePath) : -1;
    }

    public void startEditingAtPath(JTree jTree, TreePath treePath) {
        jTree.scrollPathToVisible(treePath);
        if (treePath != null && jTree.isVisible(treePath)) {
            this.startEditing(treePath, null);
        }
    }

    private TreePath getLastChildPath(TreePath treePath) {
        int n2;
        TreeModel treeModel = this.tree.getModel();
        if (treeModel != null && (n2 = treeModel.getChildCount(treePath.getLastPathComponent())) > 0) {
            return treePath.pathByAddingChild(treeModel.getChild(treePath.getLastPathComponent(), n2 - 1));
        }
        return null;
    }

    private void selectionModelChanged(TreeSelectionModel treeSelectionModel, TreeSelectionModel treeSelectionModel2) {
        this.completeEditing();
        if (treeSelectionModel2 != null && this.treeSelectionListener != null) {
            treeSelectionModel2.removeTreeSelectionListener(this.treeSelectionListener);
        }
        if (treeSelectionModel2 != null) {
            if (this.treeSelectionListener != null) {
                treeSelectionModel2.addTreeSelectionListener(this.treeSelectionListener);
            }
            if (this.treeState != null) {
                this.treeState.setSelectionModel(treeSelectionModel2);
            }
        } else if (this.treeState != null) {
            this.treeState.setSelectionModel(null);
        }
        if (this.tree != null) {
            this.tree.repaint();
        }
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthTreeUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, region, this.cellStyle, n2);
    }

    private void adjustCellBounds(JTree jTree, Rectangle rectangle, Insets insets) {
        if (rectangle != null) {
            if (insets == null) {
                insets = jTree.getInsets();
            }
            rectangle.y += insets.top;
            rectangle.x = this.leftToRight ? (rectangle.x += insets.left) : jTree.getWidth() - insets.right - rectangle.x - rectangle.width;
        }
    }

    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        if (jTree != null && this.treeState != null) {
            Rectangle rectangle = this.treeState.getBounds(treePath, null);
            this.adjustCellBounds(jTree, rectangle, null);
            return rectangle;
        }
        return null;
    }

    static boolean access$2700(SynthTreeUI synthTreeUI, TreePath treePath, MouseEvent mouseEvent) {
        return synthTreeUI.startEditing(treePath, mouseEvent);
    }

    static SynthContext access$2900(SynthTreeUI synthTreeUI, JComponent jComponent, Region region) {
        return synthTreeUI.getContext(jComponent, region);
    }

    private void paintIconCenteredAt(SynthContext synthContext, Component component, Graphics graphics, Icon icon, int n2, int n3) {
        int n4 = SynthIcon.getIconWidth(icon, synthContext);
        int n5 = SynthIcon.getIconHeight(icon, synthContext);
        SynthIcon.paintIcon(icon, synthContext, graphics, n2 - n4 / 2, n3 - n5 / 2, n4, n5);
    }

    protected void paintVerticalPartOfLeg(SynthContext synthContext, Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (!this.drawVerticalLegs) {
            return;
        }
        int n2 = treePath.getPathCount() - 1;
        if (n2 == 0 && !this.tree.getShowsRootHandles() && !this.tree.isRootVisible()) {
            return;
        }
        int n3 = this.getRowX(-1, n2) - this.getTrailingControlOffset();
        int n4 = this.leftToRight ? n3 + insets.left : this.tree.getWidth() - n3 - insets.right;
        int n5 = rectangle.x;
        int n6 = rectangle.x + (rectangle.width - 1);
        if (n4 >= n5 && n4 <= n6) {
            int n7;
            Object object;
            TreeModel treeModel;
            int n8 = rectangle.y;
            int n9 = rectangle.y + rectangle.height;
            Rectangle rectangle2 = this.getPathBounds(this.tree, treePath);
            Rectangle rectangle3 = this.getPathBounds(this.tree, this.getLastChildPath(treePath));
            int n10 = rectangle2 == null ? Math.max(insets.top, n8) : Math.max(rectangle2.y + rectangle2.height, n8);
            if (n2 == 0 && !this.tree.isRootVisible() && (treeModel = this.tree.getModel()).getChildCount(object = treeModel.getRoot()) > 0 && (rectangle2 = this.getPathBounds(this.tree, treePath.pathByAddingChild(treeModel.getChild(object, 0)))) != null) {
                n10 = Math.max(insets.top, rectangle2.y + rectangle2.height / 2);
            }
            if (n10 < (n7 = Math.min(rectangle3.y + rectangle3.height / 2, n9))) {
                object = synthContext.getStyle().getSynthGraphics(synthContext);
                graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.FOREGROUND));
                ((SynthGraphics)object).drawLine(synthContext, "Tree.verticalLine", graphics, n4, n10, n4, n7);
            }
        }
    }

    protected void paintExpandControl(SynthContext synthContext, Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        Object object = treePath.getLastPathComponent();
        if (!(bl4 || bl3 && this.tree.getModel().getChildCount(object) <= 0)) {
            int n3 = this.leftToRight ? rectangle2.x - this.getTrailingControlOffset() + 1 : rectangle2.x + rectangle2.width + this.getTrailingControlOffset() - 1;
            int n4 = rectangle2.y + rectangle2.height / 2;
            if (bl2) {
                Icon icon = this.getExpandedIcon();
                if (icon != null) {
                    this.paintIconCenteredAt(synthContext, this.tree, graphics, icon, n3, n4);
                }
            } else {
                Icon icon = this.getCollapsedIcon();
                if (icon != null) {
                    this.paintIconCenteredAt(synthContext, this.tree, graphics, icon, n3, n4);
                }
            }
        }
    }

    protected void paintHorizontalPartOfLeg(SynthContext synthContext, Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        int n3;
        int n4;
        if (!this.drawHorizontalLegs) {
            return;
        }
        int n5 = treePath.getPathCount() - 1;
        if ((n5 == 0 || n5 == 1 && !this.tree.isRootVisible()) && !this.tree.getShowsRootHandles()) {
            return;
        }
        int n6 = rectangle.x;
        int n7 = rectangle.x + (rectangle.width - 1);
        int n8 = rectangle.y + (rectangle.height - 1);
        int n9 = rectangle2.y + rectangle2.height / 2;
        if (this.leftToRight) {
            n4 = rectangle2.x - this.getIndent() - this.getTrailingControlOffset();
            n3 = rectangle2.x - this.trailingLegBufferOffset;
        } else {
            n4 = rectangle2.x + rectangle2.width + this.trailingLegBufferOffset;
            n3 = rectangle2.x + rectangle2.width + this.getIndent() + this.getTrailingControlOffset();
        }
        if (n9 >= rectangle.y && n9 <= n8 && n3 >= n6 && n4 <= n7 && (n4 = Math.max(n4, n6)) < (n3 = Math.min(n3, n7))) {
            SynthGraphics synthGraphics = synthContext.getStyle().getSynthGraphics(synthContext);
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.FOREGROUND));
            synthGraphics.drawLine(synthContext, "Tree.horizontalLine", graphics, n4, n9, n3, n9);
        }
    }

    protected void paintRow(TreeCellRenderer treeCellRenderer, DefaultTreeCellRenderer defaultTreeCellRenderer, SynthContext synthContext, SynthContext synthContext2, Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, Rectangle rectangle3, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = this.tree.isRowSelected(n2);
        if (bl5) {
            synthContext2.setComponentState(513);
        } else {
            synthContext2.setComponentState(1);
        }
        if (defaultTreeCellRenderer != null && defaultTreeCellRenderer.getBorderSelectionColor() instanceof UIResource) {
            defaultTreeCellRenderer.setBorderSelectionColor(this.style.getColor(synthContext2, ColorType.FOCUS));
        }
        SynthLookAndFeel.updateSubregion(synthContext2, graphics, rectangle3);
        if (this.getEditingRow() == n2) {
            return;
        }
        int n3 = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        Component component = treeCellRenderer.getTreeCellRendererComponent(this.tree, treePath.getLastPathComponent(), bl5, bl2, bl4, n2, n3 == n2);
        this.rendererPane.paintComponent(graphics, component, this.tree, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
    }

    static class 1 {
    }

    private static class AddSelectionAction
    extends GenericTreeAction {
        private boolean changeAnchor;

        AddSelectionAction(String string, boolean bl2) {
            super(string);
            this.changeAnchor = bl2;
        }

        protected void actionPerformed(ActionEvent actionEvent, JTree jTree, int n2) {
            int n3 = jTree.getLeadSelectionRow();
            TreePath treePath = jTree.getAnchorSelectionPath();
            TreePath treePath2 = jTree.getLeadSelectionPath();
            if (n3 == -1) {
                n3 = 0;
            }
            if (!this.changeAnchor) {
                if (jTree.isRowSelected(n3)) {
                    jTree.removeSelectionRow(n3);
                    jTree.setLeadSelectionPath(treePath2);
                } else {
                    jTree.addSelectionRow(n3);
                }
                jTree.setAnchorSelectionPath(treePath);
            } else {
                jTree.setSelectionRow(n3);
            }
        }
    }

    private class CancelEditingAction
    extends AbstractAction {
        private final SynthTreeUI this$0;

        public boolean isEnabled() {
            return SynthTreeUI.access$1900(this.this$0) != null && SynthTreeUI.access$1900(this.this$0).isEnabled() && this.this$0.isEditing(SynthTreeUI.access$1900(this.this$0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SynthTreeUI.access$1900(this.this$0) != null) {
                SynthTreeUI.access$1900(this.this$0).cancelEditing();
            }
        }

        public CancelEditingAction(SynthTreeUI synthTreeUI, String string) {
            this.this$0 = synthTreeUI;
            super(string);
        }
    }

    class CellEditorHandler
    implements CellEditorListener {
        private final SynthTreeUI this$0;

        CellEditorHandler(SynthTreeUI synthTreeUI) {
            this.this$0 = synthTreeUI;
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            SynthTreeUI.access$2200(this.this$0, false, false, false);
        }

        public void editingStopped(ChangeEvent changeEvent) {
            SynthTreeUI.access$2200(this.this$0, false, false, true);
        }
    }

    private static class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        private Timer timer;
        private JScrollBar scrollBar;
        private SynthTreeUI ui;

        private ComponentHandler() {
        }

        private void adjust() {
            if (this.timer != null) {
                this.timer.stop();
            }
            SynthTreeUI.access$1700(this.ui);
            this.timer = null;
            this.scrollBar = null;
            this.ui = null;
        }

        ComponentHandler(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.scrollBar.getValueIsAdjusting()) {
                this.adjust();
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
            JTree jTree = (JTree)componentEvent.getSource();
            SynthTreeUI synthTreeUI = (SynthTreeUI)jTree.getUI();
            if (this.ui != synthTreeUI) {
                this.adjust();
            }
            if (this.timer == null) {
                JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = SynthTreeUI.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, jTree);
                if (jScrollPane == null) {
                    SynthTreeUI.access$1700(synthTreeUI);
                } else {
                    JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                    if (jScrollBar == null || !jScrollBar.getValueIsAdjusting()) {
                        jScrollBar = jScrollPane.getHorizontalScrollBar();
                        if (jScrollBar != null && jScrollBar.getValueIsAdjusting()) {
                            this.queue(synthTreeUI, jScrollBar);
                        } else {
                            SynthTreeUI.access$1700(synthTreeUI);
                        }
                    } else {
                        this.queue(synthTreeUI, jScrollBar);
                    }
                }
            }
        }

        private void queue(SynthTreeUI synthTreeUI, JScrollBar jScrollBar) {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
            this.ui = synthTreeUI;
            this.scrollBar = jScrollBar;
        }
    }

    private static class EditAction
    extends GenericTreeAction {
        public EditAction(String string) {
            super(string);
        }

        protected void actionPerformed(ActionEvent actionEvent, JTree jTree, int n2) {
            TreePath treePath = jTree.getLeadSelectionPath();
            if (treePath != null) {
                jTree.startEditingAtPath(treePath);
            }
        }
    }

    private static class EditingState {
        public Component component;
        public TreePath path;
        public int row;
        public boolean editorHasDifferentSize;
        public CellEditor editor;

        private EditingState() {
        }

        EditingState(1 var1_1) {
            this();
        }
    }

    private static class ExtendSelectionAction
    extends GenericTreeAction {
        ExtendSelectionAction(String string) {
            super(string);
        }

        protected void actionPerformed(ActionEvent actionEvent, JTree jTree, int n2) {
            int n3 = jTree.getLeadSelectionRow();
            if (n3 != -1) {
                TreePath treePath = jTree.getLeadSelectionPath();
                TreePath treePath2 = jTree.getAnchorSelectionPath();
                int n4 = jTree.getRowForPath(treePath2);
                if (n4 == -1) {
                    n4 = 0;
                }
                jTree.setSelectionInterval(n4, n3);
                jTree.setLeadSelectionPath(treePath);
                jTree.setAnchorSelectionPath(treePath2);
            }
        }
    }

    private static class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        FocusHandler(1 var1_1) {
            this();
        }

        public void focusGained(FocusEvent focusEvent) {
            this.paintLead((JTree)focusEvent.getSource());
        }

        public void focusLost(FocusEvent focusEvent) {
            this.paintLead((JTree)focusEvent.getSource());
        }

        private void paintLead(JTree jTree) {
            Rectangle rectangle = jTree.getPathBounds(jTree.getLeadSelectionPath());
            if (rectangle != null) {
                jTree.repaint(rectangle);
            }
        }
    }

    private static abstract class GenericTreeAction
    extends AbstractAction {
        protected int direction;
        protected boolean addToSelection;
        protected boolean changeSelection;

        public void actionPerformed(ActionEvent actionEvent) {
            JTree jTree = (JTree)actionEvent.getSource();
            int n2 = jTree.getRowCount();
            if (n2 > 0) {
                this.actionPerformed(actionEvent, jTree, n2);
            }
        }

        GenericTreeAction(String string) {
            super(string);
        }

        GenericTreeAction(String string, int n2, boolean bl2, boolean bl3) {
            super(string);
            this.direction = n2;
            this.addToSelection = bl2;
            this.changeSelection = bl3;
        }

        protected abstract void actionPerformed(ActionEvent var1, JTree var2, int var3);

        protected void adjustSelection(JTree jTree, TreePath treePath) {
            if (this.addToSelection) {
                this.extendSelection(jTree, treePath);
            } else if (this.changeSelection) {
                jTree.setSelectionPath(treePath);
            } else {
                jTree.setLeadSelectionPath(treePath);
            }
        }

        private void extendSelection(JTree jTree, TreePath treePath) {
            TreePath treePath2 = jTree.getAnchorSelectionPath();
            int n2 = treePath2 == null ? -1 : jTree.getRowForPath(treePath2);
            int n3 = jTree.getRowForPath(treePath);
            if (n2 == -1) {
                jTree.setSelectionRow(n3);
            } else {
                if (n2 < n3) {
                    jTree.setSelectionInterval(n2, n3);
                } else {
                    jTree.setSelectionInterval(n3, n2);
                }
                jTree.setAnchorSelectionPath(treePath2);
                jTree.setLeadSelectionPath(treePath);
            }
        }
    }

    private static class HomeAction
    extends GenericTreeAction {
        HomeAction(String string, int n2, boolean bl2, boolean bl3) {
            super(string, n2, bl2, bl3);
        }

        protected void actionPerformed(ActionEvent actionEvent, JTree jTree, int n2) {
            if (this.direction == -1) {
                SynthTreeUI.access$2000(jTree, 0, 0);
                if (this.addToSelection) {
                    int n3;
                    TreePath treePath = jTree.getAnchorSelectionPath();
                    int n4 = n3 = treePath == null ? -1 : jTree.getRowForPath(treePath);
                    if (n3 == -1) {
                        jTree.setSelectionInterval(0, 0);
                    } else {
                        jTree.setSelectionInterval(0, n3);
                        jTree.setAnchorSelectionPath(treePath);
                        jTree.setLeadSelectionPath(jTree.getPathForRow(0));
                    }
                } else if (this.changeSelection) {
                    jTree.setSelectionInterval(0, 0);
                } else {
                    jTree.setLeadSelectionPath(jTree.getPathForRow(0));
                }
            } else {
                SynthTreeUI.access$2000(jTree, n2 - 1, n2 - 1);
                if (this.addToSelection) {
                    int n5;
                    TreePath treePath = jTree.getAnchorSelectionPath();
                    int n6 = n5 = treePath == null ? -1 : jTree.getRowForPath(treePath);
                    if (n5 == -1) {
                        jTree.setSelectionInterval(n2 - 1, n2 - 1);
                    } else {
                        jTree.setSelectionInterval(n5, n2 - 1);
                        jTree.setAnchorSelectionPath(treePath);
                        jTree.setLeadSelectionPath(jTree.getPathForRow(n2 - 1));
                    }
                } else if (this.changeSelection) {
                    jTree.setSelectionInterval(n2 - 1, n2 - 1);
                } else {
                    jTree.setLeadSelectionPath(jTree.getPathForRow(n2 - 1));
                }
            }
        }
    }

    private static class IncrementAction
    extends GenericTreeAction {
        IncrementAction(String string, int n2, boolean bl2, boolean bl3) {
            super(string);
            this.direction = n2;
            this.addToSelection = bl2;
            this.changeSelection = bl3;
        }

        protected void actionPerformed(ActionEvent actionEvent, JTree jTree, int n2) {
            int n3 = jTree.getLeadSelectionRow();
            TreeSelectionModel treeSelectionModel = jTree.getSelectionModel();
            int n4 = n3 == -1 ? (this.direction == 1 ? 0 : n2 - 1) : Math.min(n2 - 1, Math.max(0, n3 + this.direction));
            this.adjustSelection(jTree, jTree.getPathForRow(n4));
            SynthTreeUI.access$2000(jTree, n4, n4);
        }
    }

    private static class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        KeyHandler(1 var1_1) {
            this();
        }

        public void keyTyped(KeyEvent keyEvent) {
            JTree jTree = (JTree)keyEvent.getSource();
            if (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                return;
            }
            if (jTree != null && jTree.getRowCount() > 0 && jTree.hasFocus() && jTree.isEnabled()) {
                TreePath treePath;
                boolean bl2 = true;
                String string = Character.toString(keyEvent.getKeyChar());
                int n2 = jTree.getMinSelectionRow() + 1;
                if (n2 >= jTree.getRowCount()) {
                    bl2 = false;
                    n2 = 0;
                }
                if ((treePath = jTree.getNextMatch(string, n2, Position.Bias.Forward)) != null) {
                    jTree.setSelectionPath(treePath);
                } else if (bl2 && (treePath = jTree.getNextMatch(string, 0, Position.Bias.Forward)) != null) {
                    jTree.setSelectionPath(treePath);
                }
            }
        }
    }

    private static class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean inDND;
        private Component destination;

        private MouseHandler() {
        }

        MouseHandler(1 var1_1) {
            this();
        }

        private void cacheDestination(Component component, int n2, int n3) {
            this.destination = component != null ? SwingUtilities.getDeepestComponentAt(component, n2, n3) : null;
        }

        private void handleSelection(MouseEvent mouseEvent) {
            JTree jTree = (JTree)mouseEvent.getSource();
            SynthTreeUI synthTreeUI = (SynthTreeUI)jTree.getUI();
            if (jTree != null && jTree.isEnabled()) {
                TreePath treePath;
                if (jTree.isEditing() && jTree.getInvokesStopCellEditing() && !jTree.stopEditing()) {
                    return;
                }
                if (jTree.isRequestFocusEnabled()) {
                    jTree.requestFocus();
                }
                if ((treePath = jTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                    int n2;
                    Rectangle rectangle = jTree.getPathBounds(treePath);
                    if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                        return;
                    }
                    if (SynthLookAndFeel.isPrimaryMouseButton(mouseEvent)) {
                        SynthContext synthContext = synthTreeUI.getContext(jTree);
                        synthTreeUI.expandPathIfNecessary(synthContext, treePath, mouseEvent.getX(), mouseEvent.getY());
                        synthContext.dispose();
                    }
                    if ((n2 = mouseEvent.getX()) > rectangle.x && n2 <= rectangle.x + rectangle.width && !SynthTreeUI.access$2700(synthTreeUI, treePath, mouseEvent)) {
                        synthTreeUI.selectPathForEvent(treePath, mouseEvent);
                    }
                }
            }
            this.cacheDestination(SynthTreeUI.access$2300(synthTreeUI), mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.redispatchEventIfNecessary(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                this.handleSelection(mouseEvent);
                this.redispatchEventIfNecessary(mouseEvent);
                this.inDND = false;
            } else {
                this.inDND = true;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && this.inDND) {
                this.handleSelection(mouseEvent);
                this.redispatchEventIfNecessary(mouseEvent);
            }
        }

        private void redispatchEventIfNecessary(MouseEvent mouseEvent) {
            if (this.destination != null) {
                JTree jTree = (JTree)mouseEvent.getSource();
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(jTree, mouseEvent, this.destination));
            }
        }
    }

    private class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        private final SynthTreeUI this$0;

        private NodeDimensionsHandler(SynthTreeUI synthTreeUI) {
            this.this$0 = synthTreeUI;
        }

        NodeDimensionsHandler(SynthTreeUI synthTreeUI, 1 var2_2) {
            this(synthTreeUI);
        }

        public Rectangle getNodeDimensions(Object object, int n2, int n3, boolean bl2, Rectangle rectangle) {
            Component component = SynthTreeUI.access$2300(this.this$0);
            int n4 = SynthTreeUI.access$2400(this.this$0);
            if (component != null && n4 == n2) {
                Dimension dimension = component.getPreferredSize();
                int n5 = SynthTreeUI.access$1900(this.this$0).getRowHeight();
                if (n5 > 0 && n5 != dimension.height) {
                    dimension.height = n5;
                }
                if (rectangle != null) {
                    rectangle.x = SynthTreeUI.access$2500(this.this$0, n2, n3);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(SynthTreeUI.access$2500(this.this$0, n2, n3), 0, dimension.width, dimension.height);
                }
                return rectangle;
            }
            TreeCellRenderer treeCellRenderer = SynthTreeUI.access$1900(this.this$0).getCellRenderer();
            if (treeCellRenderer != null) {
                component = treeCellRenderer.getTreeCellRendererComponent(SynthTreeUI.access$1900(this.this$0), object, SynthTreeUI.access$1900(this.this$0).isRowSelected(n2), bl2, SynthTreeUI.access$1900(this.this$0).getModel().isLeaf(object), n2, false);
                SynthTreeUI.access$2600(this.this$0).add(component);
                component.validate();
                Dimension dimension = component.getPreferredSize();
                if (rectangle != null) {
                    rectangle.x = SynthTreeUI.access$2500(this.this$0, n2, n3);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(SynthTreeUI.access$2500(this.this$0, n2, n3), 0, dimension.width, dimension.height);
                }
                return rectangle;
            }
            return null;
        }
    }

    private static class ScrollAction
    extends AbstractAction {
        private int direction;
        private int amount;

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            Rectangle rectangle = jComponent.getVisibleRect();
            Dimension dimension = jComponent.getSize();
            if (this.direction == 0) {
                rectangle.x += this.amount;
                rectangle.x = Math.max(0, rectangle.x);
                rectangle.x = Math.min(Math.max(0, dimension.width - rectangle.width), rectangle.x);
            } else {
                rectangle.y += this.amount;
                rectangle.y = Math.max(0, rectangle.y);
                rectangle.y = Math.min(Math.max(0, dimension.width - rectangle.height), rectangle.y);
            }
            jComponent.scrollRectToVisible(rectangle);
        }

        public ScrollAction(String string, int n2, int n3) {
            super(string);
            this.direction = n2;
            this.amount = n3;
        }
    }

    private static class ScrollAndSelectAction
    extends GenericTreeAction {
        private ScrollAndSelectAction(String string, int n2, boolean bl2, boolean bl3) {
            super(string, n2, bl2, bl3);
        }

        ScrollAndSelectAction(String string, int n2, boolean bl2, boolean bl3, 1 var5_5) {
            this(string, n2, bl2, bl3);
        }

        protected void actionPerformed(ActionEvent actionEvent, JTree jTree, int n2) {
            Dimension dimension = jTree.getSize();
            TreePath treePath = jTree.getLeadSelectionPath();
            TreePath treePath2 = null;
            Rectangle rectangle = jTree.getVisibleRect();
            switch (this.direction) {
                case 1: {
                    treePath2 = jTree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    if (treePath2.equals(treePath)) {
                        rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                        treePath2 = jTree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    }
                    Rectangle rectangle2 = jTree.getPathBounds(treePath2);
                    rectangle.y = rectangle2.y;
                    break;
                }
                case 5: {
                    rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                    treePath2 = jTree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    if (treePath2.equals(treePath)) {
                        rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                        treePath2 = jTree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    }
                    Rectangle rectangle3 = jTree.getPathBounds(treePath2);
                    rectangle.y = rectangle3.y - (rectangle.height - rectangle3.height);
                    break;
                }
                case 7: {
                    treePath2 = jTree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    rectangle.x = Math.max(0, rectangle.x - rectangle.width);
                    break;
                }
                case 3: {
                    rectangle.x = Math.min(Math.max(0, jTree.getWidth() - rectangle.width), rectangle.x + rectangle.width);
                    treePath2 = jTree.getClosestPathForLocation(rectangle.x, rectangle.y + rectangle.height);
                }
            }
            this.adjustSelection(jTree, treePath2);
            jTree.scrollRectToVisible(rectangle);
        }
    }

    private static class SelectAllAction
    extends GenericTreeAction {
        private boolean selectAll;

        public SelectAllAction(String string, boolean bl2) {
            super(string);
            this.selectAll = bl2;
        }

        protected void actionPerformed(ActionEvent actionEvent, JTree jTree, int n2) {
            if (this.selectAll) {
                TreePath treePath = jTree.getLeadSelectionPath();
                TreePath treePath2 = jTree.getAnchorSelectionPath();
                if (treePath != null && !jTree.isVisible(treePath)) {
                    treePath = null;
                }
                jTree.setSelectionInterval(0, n2 - 1);
                if (treePath != null) {
                    jTree.setLeadSelectionPath(treePath);
                }
                if (treePath2 != null && jTree.isVisible(treePath2)) {
                    jTree.setAnchorSelectionPath(treePath2);
                } else if (treePath != null) {
                    jTree.setAnchorSelectionPath(treePath);
                }
            } else {
                TreePath treePath = jTree.getLeadSelectionPath();
                TreePath treePath3 = jTree.getAnchorSelectionPath();
                jTree.clearSelection();
                jTree.setAnchorSelectionPath(treePath3);
                jTree.setLeadSelectionPath(treePath);
            }
        }
    }

    private static class SynthTreeCellEditor
    extends DefaultTreeCellEditor {
        protected TreeCellEditor createTreeCellEditor() {
            JTextField jTextField = new JTextField();
            jTextField.setName("Tree.cellEditor");
            ((SynthTextUI)jTextField.getUI()).forceFetchStyle(jTextField);
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
            defaultCellEditor.setClickCountToStart(1);
            return defaultCellEditor;
        }

        public SynthTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
            this.setBorderSelectionColor(null);
        }
    }

    private class SynthTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements UIResource {
        static final boolean $assertionsDisabled = !(class$com$sun$java$swing$plaf$gtk$SynthTreeUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthTreeUI = SynthTreeUI.class$("com.sun.java.swing.plaf.gtk.SynthTreeUI")) : class$com$sun$java$swing$plaf$gtk$SynthTreeUI).desiredAssertionStatus();
        private final SynthTreeUI this$0;

        SynthTreeCellRenderer(SynthTreeUI synthTreeUI) {
            this.this$0 = synthTreeUI;
            this.setName("Tree.cellRenderer");
            ((SynthLabelUI)this.getUI()).forceFetchStyle(this);
        }

        public void paint(Graphics graphics) {
            this.paintComponent(graphics);
            if (this.hasFocus) {
                SynthContext synthContext = SynthTreeUI.access$2900(this.this$0, SynthTreeUI.access$1900(this.this$0), Region.TREE_CELL);
                if (synthContext.getStyle() == null) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"SynthTreeCellRenderer is being used outside of UI that created it");
                    }
                    return;
                }
                SynthPainter synthPainter = (SynthPainter)synthContext.getStyle().get(synthContext, "focus");
                if (synthPainter != null) {
                    int n2 = 0;
                    Icon icon = this.getIcon();
                    if (icon != null && this.getText() != null) {
                        n2 = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                    }
                    if (this.selected) {
                        synthContext.setComponentState(513);
                    } else {
                        synthContext.setComponentState(1);
                    }
                    if (this.getComponentOrientation().isLeftToRight()) {
                        synthPainter.paint(synthContext, "focus", graphics, n2, 0, this.getWidth() - n2, this.getHeight());
                    } else {
                        synthPainter.paint(synthContext, "focus", graphics, 0, 0, this.getWidth() - n2, this.getHeight());
                    }
                }
                synthContext.dispose();
            }
        }
    }

    private static class ToggleAction
    extends GenericTreeAction {
        ToggleAction(String string) {
            super(string);
        }

        protected void actionPerformed(ActionEvent actionEvent, JTree jTree, int n2) {
            int n3 = jTree.getLeadSelectionRow();
            if (n3 != -1) {
                TreePath treePath = jTree.getPathForRow(n3);
                if (!jTree.getModel().isLeaf(treePath.getLastPathComponent())) {
                    TreePath treePath2 = jTree.getAnchorSelectionPath();
                    TreePath treePath3 = jTree.getLeadSelectionPath();
                    SynthTreeUI.access$2800((SynthTreeUI)jTree.getUI(), treePath);
                    jTree.setAnchorSelectionPath(treePath2);
                    jTree.setLeadSelectionPath(treePath3);
                }
            }
        }
    }

    private static class TraverseAction
    extends GenericTreeAction {
        TraverseAction(String string, int n2, boolean bl2) {
            super(string, n2, false, bl2);
        }

        protected void actionPerformed(ActionEvent actionEvent, JTree jTree, int n2) {
            int n3;
            int n4 = jTree.getLeadSelectionRow();
            TreeModel treeModel = jTree.getModel();
            if (n4 == -1) {
                n3 = 0;
            } else {
                SynthTreeUI synthTreeUI = (SynthTreeUI)jTree.getUI();
                TreePath treePath = jTree.getPathForRow(n4);
                if (this.direction == 1) {
                    if (!treeModel.isLeaf(treePath.getLastPathComponent()) && !jTree.isExpanded(n4)) {
                        SynthTreeUI.access$2800(synthTreeUI, treePath);
                        n3 = -1;
                    } else {
                        n3 = Math.min(n4 + 1, n2 - 1);
                    }
                } else if (!treeModel.isLeaf(treePath.getLastPathComponent()) && jTree.isExpanded(n4)) {
                    SynthTreeUI.access$2800(synthTreeUI, jTree.getPathForRow(n4));
                    n3 = -1;
                } else {
                    treePath = jTree.getPathForRow(n4);
                    n3 = treePath != null && treePath.getPathCount() > 1 ? jTree.getRowForPath(treePath.getParentPath()) : -1;
                }
            }
            if (n3 != -1) {
                if (this.changeSelection) {
                    jTree.setSelectionInterval(n3, n3);
                } else {
                    jTree.setLeadSelectionPath(jTree.getPathForRow(n3));
                }
                SynthTreeUI.access$2000(jTree, n3, n3);
            }
        }
    }

    private class TreeCollapseAction
    extends AbstractAction {
        private final SynthTreeUI this$0;

        private TreeCollapseAction(SynthTreeUI synthTreeUI) {
            this.this$0 = synthTreeUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n2 = SynthTreeUI.access$1800(this.this$0);
            SynthTreeUI.access$1900(this.this$0).collapseRow(n2);
        }

        TreeCollapseAction(SynthTreeUI synthTreeUI, 1 var2_2) {
            this(synthTreeUI);
        }
    }

    static class TreeDragGestureRecognizer
    extends SynthDragGestureRecognizer {
        TreeDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            TreeUI treeUI;
            TreePath treePath;
            JTree jTree;
            return super.isDragPossible(mouseEvent) && (jTree = (JTree)this.getComponent(mouseEvent)).getDragEnabled() && (treePath = (treeUI = jTree.getUI()).getClosestPathForLocation(jTree, mouseEvent.getX(), mouseEvent.getY())) != null && jTree.isPathSelected(treePath);
        }
    }

    static class TreeDropTargetListener
    extends SynthDropTargetListener {
        private int[] selectedIndices;

        TreeDropTargetListener() {
        }

        protected void restoreComponentState(JComponent jComponent) {
            JTree jTree = (JTree)jComponent;
            jTree.setSelectionRows(this.selectedIndices);
        }

        protected void saveComponentState(JComponent jComponent) {
            JTree jTree = (JTree)jComponent;
            this.selectedIndices = jTree.getSelectionRows();
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JTree jTree = (JTree)jComponent;
            TreeUI treeUI = jTree.getUI();
            TreePath treePath = treeUI.getClosestPathForLocation(jTree, point.x, point.y);
            if (treePath != null) {
                jTree.setSelectionPath(treePath);
            }
        }
    }

    private class TreeExpandAction
    extends AbstractAction {
        private final SynthTreeUI this$0;

        private TreeExpandAction(SynthTreeUI synthTreeUI) {
            this.this$0 = synthTreeUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n2 = SynthTreeUI.access$1800(this.this$0);
            SynthTreeUI.access$1900(this.this$0).expandRow(n2);
        }

        TreeExpandAction(SynthTreeUI synthTreeUI, 1 var2_2) {
            this(synthTreeUI);
        }
    }

    private static class TreeExpansionHandler
    implements TreeExpansionListener {
        private TreeExpansionHandler() {
        }

        TreeExpansionHandler(1 var1_1) {
            this();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            JTree jTree = (JTree)treeExpansionEvent.getSource();
            SynthTreeUI synthTreeUI = (SynthTreeUI)jTree.getUI();
            TreePath treePath = treeExpansionEvent.getPath();
            SynthTreeUI.access$1400(synthTreeUI);
            if (treePath != null && jTree.isVisible(treePath)) {
                SynthTreeUI.access$1500(synthTreeUI).setExpandedState(treePath, false);
                SynthTreeUI.access$1600(synthTreeUI);
                SynthTreeUI.access$1700(synthTreeUI);
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            JTree jTree = (JTree)treeExpansionEvent.getSource();
            SynthTreeUI synthTreeUI = (SynthTreeUI)jTree.getUI();
            TreePath treePath = treeExpansionEvent.getPath();
            SynthTreeUI.access$1300(synthTreeUI, treePath);
        }
    }

    private class TreeModelHandler
    implements TreeModelListener {
        private final SynthTreeUI this$0;

        private TreeModelHandler(SynthTreeUI synthTreeUI) {
            this.this$0 = synthTreeUI;
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (SynthTreeUI.access$1500(this.this$0) != null && treeModelEvent != null) {
                SynthTreeUI.access$1500(this.this$0).treeNodesChanged(treeModelEvent);
                TreePath treePath = treeModelEvent.getTreePath().getParentPath();
                if (treePath == null || SynthTreeUI.access$1500(this.this$0).isExpanded(treePath)) {
                    SynthTreeUI.access$1700(this.this$0);
                }
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (SynthTreeUI.access$1500(this.this$0) != null && treeModelEvent != null) {
                SynthTreeUI.access$1500(this.this$0).treeNodesInserted(treeModelEvent);
                SynthTreeUI.access$1600(this.this$0);
                TreePath treePath = treeModelEvent.getTreePath();
                if (SynthTreeUI.access$1500(this.this$0).isExpanded(treePath)) {
                    SynthTreeUI.access$1700(this.this$0);
                } else {
                    int[] nArray = treeModelEvent.getChildIndices();
                    int n2 = SynthTreeUI.access$1900(this.this$0).getModel().getChildCount(treePath.getLastPathComponent());
                    if (nArray != null && n2 - nArray.length == 0) {
                        SynthTreeUI.access$1700(this.this$0);
                    }
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (SynthTreeUI.access$1500(this.this$0) != null && treeModelEvent != null) {
                SynthTreeUI.access$1500(this.this$0).treeNodesRemoved(treeModelEvent);
                SynthTreeUI.access$1600(this.this$0);
                TreePath treePath = treeModelEvent.getTreePath();
                if (SynthTreeUI.access$1500(this.this$0).isExpanded(treePath) || SynthTreeUI.access$1900(this.this$0).getModel().getChildCount(treePath.getLastPathComponent()) == 0) {
                    SynthTreeUI.access$1700(this.this$0);
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (SynthTreeUI.access$1500(this.this$0) != null && treeModelEvent != null) {
                SynthTreeUI.access$1500(this.this$0).treeStructureChanged(treeModelEvent);
                SynthTreeUI.access$1600(this.this$0);
                TreePath treePath = treeModelEvent.getTreePath();
                if (treePath != null) {
                    treePath = treePath.getParentPath();
                }
                if (treePath == null || SynthTreeUI.access$1500(this.this$0).isExpanded(treePath)) {
                    SynthTreeUI.access$1700(this.this$0);
                }
            }
        }

        TreeModelHandler(SynthTreeUI synthTreeUI, 1 var2_2) {
            this(synthTreeUI);
        }
    }

    private class TreeMoveSelectionToParentAction
    extends AbstractAction {
        private final SynthTreeUI this$0;

        private TreeMoveSelectionToParentAction(SynthTreeUI synthTreeUI) {
            this.this$0 = synthTreeUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            int n3 = SynthTreeUI.access$1800(this.this$0);
            TreePath treePath = this.this$0.getPathForRow(SynthTreeUI.access$1900(this.this$0), n3);
            if (treePath != null && treePath.getPathCount() > 1 && (n2 = this.this$0.getRowForPath(SynthTreeUI.access$1900(this.this$0), treePath.getParentPath())) != -1) {
                SynthTreeUI.access$1900(this.this$0).setSelectionInterval(n2, n2);
                SynthTreeUI.access$2000(SynthTreeUI.access$1900(this.this$0), n2, n2);
            }
        }

        TreeMoveSelectionToParentAction(SynthTreeUI synthTreeUI, 1 var2_2) {
            this(synthTreeUI);
        }
    }

    private class TreeSelectionHandler
    implements TreeSelectionListener {
        private final SynthTreeUI this$0;

        private TreeSelectionHandler(SynthTreeUI synthTreeUI) {
            this.this$0 = synthTreeUI;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object;
            Object object2;
            if (SynthTreeUI.access$2100(this.this$0)) {
                SynthTreeUI.access$1400(this.this$0);
            }
            TreeSelectionModel treeSelectionModel = SynthTreeUI.access$1900(this.this$0).getSelectionModel();
            TreeModel treeModel = SynthTreeUI.access$1900(this.this$0).getModel();
            if (SynthTreeUI.access$1900(this.this$0).getExpandsSelectedPaths() && (object2 = treeSelectionModel.getSelectionPaths()) != null) {
                for (int i2 = ((TreePath[])object2).length - 1; i2 >= 0; --i2) {
                    object = object2[i2].getParentPath();
                    boolean bl2 = true;
                    while (object != null) {
                        if (treeModel != null && treeModel.isLeaf(object.getLastPathComponent())) {
                            bl2 = false;
                            object = null;
                            continue;
                        }
                        object = object.getParentPath();
                    }
                    if (!bl2) continue;
                    SynthTreeUI.access$1900(this.this$0).makeVisible(object2[i2]);
                }
            }
            object2 = SynthTreeUI.access$1900(this.this$0).getLeadSelectionPath();
            TreePath treePath = SynthTreeUI.access$1900(this.this$0).getSelectionModel().getLeadSelectionPath();
            SynthTreeUI.access$1900(this.this$0).setAnchorSelectionPath(treePath);
            SynthTreeUI.access$1900(this.this$0).setLeadSelectionPath(treePath);
            object = treeSelectionEvent.getPaths();
            Rectangle rectangle = SynthTreeUI.access$1900(this.this$0).getVisibleRect();
            boolean bl3 = true;
            int n2 = SynthTreeUI.access$1900(this.this$0).getWidth();
            if (object != null) {
                int n3 = ((TreePath[])object).length;
                if (n3 > 4) {
                    SynthTreeUI.access$1900(this.this$0).repaint();
                    bl3 = false;
                } else {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        Rectangle rectangle2 = this.this$0.getPathBounds(SynthTreeUI.access$1900(this.this$0), object[i3]);
                        if (rectangle2 == null || !rectangle.intersects(rectangle2)) continue;
                        SynthTreeUI.access$1900(this.this$0).repaint(0, rectangle2.y, n2, rectangle2.height);
                    }
                }
            }
            if (bl3) {
                Rectangle rectangle3 = this.this$0.getPathBounds(SynthTreeUI.access$1900(this.this$0), (TreePath)object2);
                if (rectangle3 != null && rectangle.intersects(rectangle3)) {
                    SynthTreeUI.access$1900(this.this$0).repaint(0, rectangle3.y, n2, rectangle3.height);
                }
                if ((rectangle3 = this.this$0.getPathBounds(SynthTreeUI.access$1900(this.this$0), treePath)) != null && rectangle.intersects(rectangle3)) {
                    SynthTreeUI.access$1900(this.this$0).repaint(0, rectangle3.y, n2, rectangle3.height);
                }
            }
        }

        TreeSelectionHandler(SynthTreeUI synthTreeUI, 1 var2_2) {
            this(synthTreeUI);
        }
    }

    static class TreeTransferHandler
    extends TransferHandler
    implements UIResource,
    Comparator {
        private JTree tree;

        TreeTransferHandler() {
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTree) {
                this.tree = (JTree)jComponent;
                TreePath[] treePathArray = this.tree.getSelectionPaths();
                if (treePathArray == null || treePathArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<ul>\n");
                TreeModel treeModel = this.tree.getModel();
                Object var6_6 = null;
                TreePath[] treePathArray2 = this.getDisplayOrderPaths(treePathArray);
                for (int i2 = 0; i2 < treePathArray2.length; ++i2) {
                    TreePath treePath = treePathArray2[i2];
                    Object object = treePath.getLastPathComponent();
                    boolean bl2 = treeModel.isLeaf(object);
                    String string = this.getDisplayString(treePath, true, bl2);
                    stringBuffer.append(string + "\n");
                    stringBuffer2.append("  <li>" + string + "\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</ul>\n</body>\n</html>");
                this.tree = null;
                return new SynthTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        public int compare(Object object, Object object2) {
            int n2 = this.tree.getRowForPath((TreePath)object);
            int n3 = this.tree.getRowForPath((TreePath)object2);
            return n2 - n3;
        }

        String getDisplayString(TreePath treePath, boolean bl2, boolean bl3) {
            int n2 = this.tree.getRowForPath(treePath);
            boolean bl4 = this.tree.getLeadSelectionRow() == n2;
            Object object = treePath.getLastPathComponent();
            return this.tree.convertValueToText(object, bl2, this.tree.isExpanded(n2), bl3, n2, bl4);
        }

        TreePath[] getDisplayOrderPaths(TreePath[] treePathArray) {
            int n2;
            ArrayList arrayList = new ArrayList();
            for (n2 = 0; n2 < treePathArray.length; ++n2) {
                arrayList.add(treePathArray[n2]);
            }
            Collections.sort(arrayList, this);
            n2 = arrayList.size();
            TreePath[] treePathArray2 = new TreePath[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                treePathArray2[i2] = (TreePath)arrayList.get(i2);
            }
            return treePathArray2;
        }
    }
}

