/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthIcon;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;

class SynthToolBarUI
extends ToolBarUI
implements SwingConstants,
SynthUI {
    protected JToolBar toolBar;
    private boolean floating;
    private int floatingX;
    private int floatingY;
    private JFrame floatingFrame;
    private RootPaneContainer floatingToolBar;
    protected DragWindow dragWindow;
    private Container dockingSource;
    private int dockingSensitivity = 0;
    protected int focusedCompIndex = -1;
    protected Icon handleIcon = null;
    protected Rectangle contentRect = null;
    protected MouseInputListener dockingListener;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    protected String constraintBeforeFloating = "North";
    private SynthStyle style;
    private SynthStyle contentStyle;
    private SynthStyle dragWindowStyle;
    private static String FOCUSED_COMP_INDEX = "JToolBar.focusedCompIndex";
    static Class class$com$sun$java$swing$plaf$gtk$SynthToolBarUI;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    SynthToolBarUI() {
    }

    protected void installComponents() {
    }

    protected void installDefaults() {
        this.toolBar.setLayout(this.createLayout());
        this.fetchStyle(this.toolBar);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, inputMap);
        LazyActionMap.installLazyActionMap(this.toolBar, class$com$sun$java$swing$plaf$gtk$SynthToolBarUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthToolBarUI = SynthToolBarUI.class$("com.sun.java.swing.plaf.gtk.SynthToolBarUI")) : class$com$sun$java$swing$plaf$gtk$SynthToolBarUI, "ToolBar.actionMap");
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        if (this.dockingListener != null) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyListener);
        }
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            Component[] componentArray = this.toolBar.getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                componentArray[i2].addFocusListener(this.toolBarFocusListener);
            }
        }
    }

    protected void uninstallComponents() {
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.toolBar, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        this.handleIcon = null;
        synthContext = this.getContext(this.toolBar, Region.TOOL_BAR_CONTENT, 1);
        this.contentStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.contentStyle = null;
        synthContext = this.getContext(this.toolBar, Region.TOOL_BAR_DRAG_WINDOW, 1);
        this.dragWindowStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.dragWindowStyle = null;
        this.toolBar.setLayout(null);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.toolBar, null);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, null);
    }

    protected void uninstallListeners() {
        if (this.dockingListener != null) {
            this.toolBar.removeMouseMotionListener(this.dockingListener);
            this.toolBar.removeMouseListener(this.dockingListener);
            this.dockingListener = null;
        }
        if (this.propertyListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.toolBarContListener != null) {
            this.toolBar.removeContainerListener(this.toolBarContListener);
            this.toolBarContListener = null;
        }
        if (this.toolBarFocusListener != null) {
            Component[] componentArray = this.toolBar.getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                componentArray[i2].removeFocusListener(this.toolBarFocusListener);
            }
            this.toolBarFocusListener = null;
        }
    }

    public boolean isFloating() {
        return this.floating;
    }

    protected void navigateFocusedComp(int n2) {
        int n3 = this.toolBar.getComponentCount();
        block0 : switch (n2) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n3) break;
                int n4 = this.focusedCompIndex + 1;
                while (n4 != this.focusedCompIndex) {
                    Component component;
                    if (n4 >= n3) {
                        n4 = 0;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n4++)) == null || !component.isFocusTraversable()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n3) break;
                int n5 = this.focusedCompIndex - 1;
                while (n5 != this.focusedCompIndex) {
                    Component component;
                    if (n5 < 0) {
                        n5 = n3 - 1;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n5--)) == null || !component.isFocusTraversable()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
        }
    }

    public void setOrientation(int n2) {
        this.toolBar.setOrientation(n2);
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(n2);
        }
    }

    public void setFloatingLocation(int n2, int n3) {
        this.floatingX = n2;
        this.floatingY = n3;
    }

    static boolean access$502(SynthToolBarUI synthToolBarUI, boolean bl2) {
        synthToolBarUI.floating = bl2;
        return synthToolBarUI.floating;
    }

    protected LayoutManager createLayout() {
        return new SynthToolBarLayoutManager(this);
    }

    public void setFloating(boolean bl2, Point point) {
        if (this.toolBar.isFloatable()) {
            Object object;
            if (this.dragWindow != null) {
                this.dragWindow.setVisible(false);
            }
            this.floating = bl2;
            if (bl2) {
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                    this.dockingSource.remove(this.toolBar);
                }
                object = new Point();
                this.toolBar.getLocation((Point)object);
                this.constraintBeforeFloating = this.calculateConstraint(this.dockingSource, (Point)object);
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                this.floatingToolBar.getContentPane().add((Component)this.toolBar, "Center");
                this.setOrientation(0);
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).pack();
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setLocation(this.floatingX, this.floatingY);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).show();
                }
            } else {
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(false);
                }
                this.floatingToolBar.getContentPane().remove(this.toolBar);
                object = this.getDockingConstraint(this.dockingSource, point);
                int n2 = this.mapConstraintToOrientation((String)object);
                this.setOrientation(n2);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if (this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.propertyListener);
                }
                this.dockingSource.add((String)object, this.toolBar);
            }
            this.dockingSource.invalidate();
            object = this.dockingSource.getParent();
            if (object != null) {
                ((Container)object).validate();
            }
            this.dockingSource.repaint();
        }
    }

    protected ContainerListener createToolBarContListener() {
        return new ToolBarContListener(this);
    }

    protected FocusListener createToolBarFocusListener() {
        return new ToolBarFocusListener(this);
    }

    protected WindowListener createFrameListener() {
        return new FrameListener(this);
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener(this);
    }

    protected String getPropertyPrefix() {
        return "ToolBar";
    }

    private int mapConstraintToOrientation(String string) {
        int n2 = this.toolBar.getOrientation();
        if (string != null) {
            if (string.equals("East") || string.equals("West")) {
                n2 = 1;
            } else if (string.equals("North") || string.equals("South")) {
                n2 = 0;
            }
        }
        return n2;
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("navigateRight", new RightAction(null));
        actionMap.put("navigateLeft", new LeftAction(null));
        actionMap.put("navigateUp", new UpAction(null));
        actionMap.put("navigateDown", new DownAction(null));
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            SynthContext synthContext = this.getContext((JComponent)this.toolBar, 1);
            InputMap inputMap = (InputMap)synthContext.getStyle().get(synthContext, "ToolBar.ancestorInputMap");
            synthContext.dispose();
            return inputMap;
        }
        return null;
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.toolBar = (JToolBar)jComponent;
        this.contentRect = new Rectangle();
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.dockingSensitivity = 0;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingToolBar = null;
        this.setOrientation(this.toolBar.getOrientation());
        jComponent.setOpaque(true);
        if (jComponent.getClientProperty(FOCUSED_COMP_INDEX) != null) {
            this.focusedCompIndex = (Integer)jComponent.getClientProperty(FOCUSED_COMP_INDEX);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.isFloating()) {
            this.setFloating(false, null);
        }
        this.floatingToolBar = null;
        this.dragWindow = null;
        this.dockingSource = null;
        jComponent.putClientProperty(FOCUSED_COMP_INDEX, new Integer(this.focusedCompIndex));
    }

    private void fetchStyle(JToolBar jToolBar) {
        SynthContext synthContext = this.getContext((JComponent)jToolBar, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (synthStyle != this.style) {
            this.handleIcon = this.style.getIcon(synthContext, this.getPropertyPrefix() + ".handleIcon");
        }
        synthContext.dispose();
        synthContext = this.getContext(jToolBar, Region.TOOL_BAR_CONTENT, 1);
        this.contentStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        synthContext = this.getContext(jToolBar, Region.TOOL_BAR_DRAG_WINDOW, 1);
        this.dragWindowStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected MouseInputListener createDockingListener() {
        return new DockingListener(this, this.toolBar);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthToolBarUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    protected DragWindow createDragWindow(JToolBar jToolBar) {
        Container container;
        Window window = null;
        if (this.toolBar != null) {
            for (container = this.toolBar.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            }
            if (container != null && container instanceof Window) {
                window = (Window)container;
            }
        }
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (this.floatingToolBar instanceof Window) {
            window = (Window)((Object)this.floatingToolBar);
        }
        container = new DragWindow(this, window);
        return container;
    }

    static Container access$800(SynthToolBarUI synthToolBarUI) {
        return synthToolBarUI.dockingSource;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        if (this.handleIcon != null && this.toolBar.isFloatable()) {
            int n2 = this.toolBar.getComponentOrientation().isLeftToRight() ? 0 : this.toolBar.getWidth() - SynthIcon.getIconWidth(this.handleIcon, synthContext);
            SynthIcon.paintIcon(this.handleIcon, synthContext, graphics, n2, 0, SynthIcon.getIconWidth(this.handleIcon, synthContext), SynthIcon.getIconHeight(this.handleIcon, synthContext));
        }
        SynthContext synthContext2 = this.getContext((JComponent)this.toolBar, Region.TOOL_BAR_CONTENT);
        this.paintContent(synthContext2, graphics, this.contentRect);
        synthContext2.dispose();
    }

    public boolean canDock(Component component, Point point) {
        boolean bl2 = false;
        if (component.contains(point)) {
            int n2 = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (point.y < this.dockingSensitivity) {
                bl2 = true;
            }
            if (point.y > component.getSize().height - this.dockingSensitivity) {
                bl2 = true;
            }
            if (point.x < this.dockingSensitivity) {
                bl2 = true;
            }
            if (point.x > component.getSize().width - this.dockingSensitivity) {
                bl2 = true;
            }
        }
        return bl2;
    }

    protected void dragTo(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            try {
                Object object;
                Cloneable cloneable;
                Point point3;
                if (this.dragWindow == null) {
                    this.dragWindow = this.createDragWindow(this.toolBar);
                }
                if ((point3 = this.dragWindow.getOffset()) == null) {
                    cloneable = this.toolBar.getPreferredSize();
                    point3 = new Point(cloneable.width / 2, cloneable.height / 2);
                    this.dragWindow.setOffset(point3);
                }
                cloneable = new Point(point2.x + point.x, point2.y + point.y);
                Point point4 = new Point(((Point)cloneable).x - point3.x, ((Point)cloneable).y - point3.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                Point point5 = new Point(point2);
                SwingUtilities.convertPointFromScreen(point5, this.toolBar.getParent());
                this.constraintBeforeFloating = this.calculateConstraint(this.dockingSource, point5);
                Point point6 = this.dockingSource.getLocationOnScreen();
                Point point7 = new Point(((Point)cloneable).x - point6.x, ((Point)cloneable).y - point6.y);
                if (this.canDock(this.dockingSource, point7)) {
                    object = this.getDockingConstraint(this.dockingSource, point7);
                    int n2 = this.mapConstraintToOrientation((String)object);
                    this.dragWindow.setOrientation(n2);
                } else {
                    this.dragWindow.setOrientation(0);
                }
                this.dragWindow.setLocation(point4.x, point4.y);
                if (!this.dragWindow.isVisible()) {
                    object = this.toolBar.getPreferredSize();
                    this.dragWindow.setSize(((Dimension)object).width, ((Dimension)object).height);
                    this.dragWindow.show();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected void floatAt(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            try {
                Point point3 = this.dragWindow.getOffset();
                if (point3 == null) {
                    point3 = point;
                    this.dragWindow.setOffset(point3);
                }
                Point point4 = new Point(point2.x + point.x, point2.y + point.y);
                this.setFloatingLocation(point4.x - point3.x, point4.y - point3.y);
                if (this.dockingSource != null) {
                    Point point5 = this.dockingSource.getLocationOnScreen();
                    Point point6 = new Point(point4.x - point5.x, point4.y - point5.y);
                    if (this.canDock(this.dockingSource, point6)) {
                        this.setFloating(false, point6);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dragWindow.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static int access$700(SynthToolBarUI synthToolBarUI, String string) {
        return synthToolBarUI.mapConstraintToOrientation(string);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected JFrame createFloatingFrame(JToolBar jToolBar) {
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        JFrame jFrame = new JFrame(this, jToolBar.getName(), window != null ? window.getGraphicsConfiguration() : null){
            private final SynthToolBarUI this$0;

            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(this){
                    private boolean packing;
                    private final 1 this$1;

                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.this$1.pack();
                            this.packing = false;
                        }
                    }
                    {
                        this.this$1 = var1_1;
                        this.packing = false;
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
            {
                this.this$0 = synthToolBarUI;
                super(string, graphicsConfiguration);
            }
        };
        jFrame.getRootPane().setName("ToolBar.FloatingFrame");
        jFrame.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        jFrame.addWindowListener(windowListener);
        return jFrame;
    }

    static void access$900(SynthToolBarUI synthToolBarUI, JToolBar jToolBar) {
        synthToolBarUI.fetchStyle(jToolBar);
    }

    static RootPaneContainer access$600(SynthToolBarUI synthToolBarUI) {
        return synthToolBarUI.floatingToolBar;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        class ToolBarDialog
        extends JDialog {
            private final SynthToolBarUI this$0;

            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(this){
                    private boolean packing;
                    private final ToolBarDialog this$1;

                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.this$1.pack();
                            this.packing = false;
                        }
                    }
                    {
                        this.this$1 = toolBarDialog;
                        this.packing = false;
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }

            public ToolBarDialog(SynthToolBarUI synthToolBarUI, Dialog dialog, String string, boolean bl2) {
                this.this$0 = synthToolBarUI;
                super(dialog, string, bl2);
            }

            public ToolBarDialog(SynthToolBarUI synthToolBarUI, Frame frame, String string, boolean bl2) {
                this.this$0 = synthToolBarUI;
                super(frame, string, bl2);
            }
        }
        ToolBarDialog toolBarDialog = window instanceof Frame ? new ToolBarDialog(this, (Frame)window, jToolBar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog(this, (Dialog)window, jToolBar.getName(), false) : new ToolBarDialog(this, (Frame)null, jToolBar.getName(), false));
        toolBarDialog.getRootPane().setName("ToolBar.FloatingWindow");
        toolBarDialog.setTitle(jToolBar.getName());
        toolBarDialog.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        toolBarDialog.addWindowListener(windowListener);
        return toolBarDialog;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthToolBarUI();
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthToolBarUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, region, this.dragWindowStyle, n2);
    }

    static Container access$802(SynthToolBarUI synthToolBarUI, Container container) {
        synthToolBarUI.dockingSource = container;
        return synthToolBarUI.dockingSource;
    }

    public void paintContent(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
    }

    private String calculateConstraint(Component component, Point point) {
        if (point == null) {
            return this.constraintBeforeFloating;
        }
        String string = "North";
        if (component.contains(point)) {
            int n2 = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (point.y >= this.dockingSource.getSize().height - this.dockingSensitivity) {
                string = "South";
            } else if (point.x < this.dockingSensitivity && this.toolBar.getOrientation() == 1) {
                string = "West";
            } else if (point.x >= this.dockingSource.getSize().width - this.dockingSensitivity && this.toolBar.getOrientation() == 1) {
                string = "East";
            } else if (point.y < this.dockingSensitivity) {
                string = "North";
            }
        }
        return string;
    }

    private String getDockingConstraint(Component component, Point point) {
        if (point == null) {
            return this.constraintBeforeFloating;
        }
        String string = "North";
        if (component.contains(point)) {
            int n2 = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (point.y >= this.dockingSource.getSize().height - this.dockingSensitivity) {
                string = "South";
            }
            if (point.x < this.dockingSensitivity) {
                string = "West";
            }
            if (point.x >= this.dockingSource.getSize().width - this.dockingSensitivity) {
                string = "East";
            }
            if (point.y < this.dockingSensitivity) {
                string = "North";
            }
        }
        return string;
    }

    static RootPaneContainer access$602(SynthToolBarUI synthToolBarUI, RootPaneContainer rootPaneContainer) {
        synthToolBarUI.floatingToolBar = rootPaneContainer;
        return synthToolBarUI.floatingToolBar;
    }

    static SynthContext access$1000(SynthToolBarUI synthToolBarUI, JComponent jComponent, Region region) {
        return synthToolBarUI.getContext(jComponent, region);
    }

    class DockingListener
    implements MouseInputListener {
        protected JToolBar toolBar;
        protected boolean isDragging;
        protected Point origin;
        private final SynthToolBarUI this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = true;
            Point point = mouseEvent.getPoint();
            if (this.origin == null) {
                this.origin = mouseEvent.getComponent().getLocationOnScreen();
            }
            this.this$0.dragTo(point, this.origin);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = false;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point point = mouseEvent.getPoint();
                if (this.origin == null) {
                    this.origin = mouseEvent.getComponent().getLocationOnScreen();
                }
                this.this$0.floatAt(point, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }

        public DockingListener(SynthToolBarUI synthToolBarUI, JToolBar jToolBar) {
            this.this$0 = synthToolBarUI;
            this.isDragging = false;
            this.origin = null;
            this.toolBar = jToolBar;
        }
    }

    private static class DownAction
    extends KeyAction {
        private DownAction() {
            super(null);
        }

        DownAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            SynthToolBarUI synthToolBarUI = (SynthToolBarUI)jToolBar.getUI();
            synthToolBarUI.navigateFocusedComp(5);
        }
    }

    protected class DragWindow
    extends Window {
        int orientation;
        Point offset;
        private final SynthToolBarUI this$0;

        public void setOrientation(int n2) {
            if (this.isShowing()) {
                if (n2 == this.orientation) {
                    return;
                }
                this.orientation = n2;
                Dimension dimension = this.getSize();
                this.setSize(new Dimension(dimension.height, dimension.width));
                if (this.offset != null) {
                    if (SynthLookAndFeel.isLeftToRight(this.this$0.toolBar)) {
                        this.setOffset(new Point(this.offset.y, this.offset.x));
                    } else if (n2 == 0) {
                        this.setOffset(new Point(dimension.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, dimension.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }

        public void paint(Graphics graphics) {
            SynthContext synthContext = SynthToolBarUI.access$1000(this.this$0, this.this$0.toolBar, Region.TOOL_BAR_DRAG_WINDOW);
            SynthLookAndFeel.updateSubregion(synthContext, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            synthContext.dispose();
        }

        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point point) {
            this.offset = point;
        }

        DragWindow(SynthToolBarUI synthToolBarUI, Window window) {
            this.this$0 = synthToolBarUI;
            super(window);
            this.orientation = this.this$0.toolBar.getOrientation();
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        private final SynthToolBarUI this$0;

        protected FrameListener(SynthToolBarUI synthToolBarUI) {
            this.this$0 = synthToolBarUI;
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (this.this$0.toolBar.isFloatable()) {
                if (this.this$0.dragWindow != null) {
                    this.this$0.dragWindow.setVisible(false);
                }
                SynthToolBarUI.access$502(this.this$0, false);
                if (SynthToolBarUI.access$600(this.this$0) == null) {
                    SynthToolBarUI.access$602(this.this$0, this.this$0.createFloatingWindow(this.this$0.toolBar));
                }
                if (SynthToolBarUI.access$600(this.this$0) instanceof Window) {
                    ((Window)((Object)SynthToolBarUI.access$600(this.this$0))).setVisible(false);
                }
                SynthToolBarUI.access$600(this.this$0).getContentPane().remove(this.this$0.toolBar);
                String string = this.this$0.constraintBeforeFloating;
                int n2 = SynthToolBarUI.access$700(this.this$0, string);
                this.this$0.setOrientation(n2);
                if (SynthToolBarUI.access$800(this.this$0) == null) {
                    SynthToolBarUI.access$802(this.this$0, this.this$0.toolBar.getParent());
                }
                if (this.this$0.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.this$0.propertyListener);
                }
                SynthToolBarUI.access$800(this.this$0).add(string, this.this$0.toolBar);
                SynthToolBarUI.access$800(this.this$0).invalidate();
                Container container = SynthToolBarUI.access$800(this.this$0).getParent();
                if (container != null) {
                    container.validate();
                }
                SynthToolBarUI.access$800(this.this$0).repaint();
                this.this$0.setFloating(false, null);
            }
        }
    }

    private static abstract class KeyAction
    extends AbstractAction {
        private KeyAction() {
        }

        public boolean isEnabled() {
            return true;
        }

        KeyAction(1 var1_1) {
            this();
        }
    }

    private static class LeftAction
    extends KeyAction {
        private LeftAction() {
            super(null);
        }

        LeftAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            SynthToolBarUI synthToolBarUI = (SynthToolBarUI)jToolBar.getUI();
            synthToolBarUI.navigateFocusedComp(7);
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        private final SynthToolBarUI this$0;

        protected PropertyListener(SynthToolBarUI synthToolBarUI) {
            this.this$0 = synthToolBarUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthToolBarUI.access$900(this.this$0, this.this$0.toolBar);
            }
            if (string.equals("lookAndFeel")) {
                this.this$0.toolBar.updateUI();
            } else if (string.equals("orientation")) {
                Component[] componentArray = this.this$0.toolBar.getComponents();
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                for (int i2 = 0; i2 < componentArray.length; ++i2) {
                    if (!(componentArray[i2] instanceof JToolBar.Separator)) continue;
                    JToolBar.Separator separator = (JToolBar.Separator)componentArray[i2];
                    separator.setOrientation(n2);
                    Dimension dimension = separator.getSize();
                    if (dimension.width == dimension.height) continue;
                    Dimension dimension2 = new Dimension(dimension.height, dimension.width);
                    separator.setSeparatorSize(dimension2);
                }
            }
        }
    }

    private static class RightAction
    extends KeyAction {
        private RightAction() {
            super(null);
        }

        RightAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            SynthToolBarUI synthToolBarUI = (SynthToolBarUI)jToolBar.getUI();
            synthToolBarUI.navigateFocusedComp(3);
        }
    }

    class SynthToolBarLayoutManager
    implements LayoutManager {
        private final SynthToolBarUI this$0;

        SynthToolBarLayoutManager(SynthToolBarUI synthToolBarUI) {
            this.this$0 = synthToolBarUI;
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            JToolBar jToolBar = (JToolBar)container;
            boolean bl2 = jToolBar.getComponentOrientation().isLeftToRight();
            SynthContext synthContext = this.this$0.getContext(jToolBar);
            int n2 = SynthIcon.getIconWidth(this.this$0.handleIcon, synthContext);
            if (jToolBar.getOrientation() == 0) {
                int n3 = bl2 ? n2 : jToolBar.getWidth() - n2;
                for (int i2 = 0; i2 < jToolBar.getComponentCount(); ++i2) {
                    Component component = jToolBar.getComponent(i2);
                    Dimension dimension = component.getPreferredSize();
                    component.setBounds(bl2 ? n3 : n3 - dimension.width, 0, dimension.width, dimension.height);
                    n3 = bl2 ? n3 + dimension.width : n3 - dimension.width;
                }
                this.this$0.contentRect.x = bl2 ? SynthIcon.getIconWidth(this.this$0.handleIcon, synthContext) : 0;
                this.this$0.contentRect.y = 0;
                this.this$0.contentRect.width = jToolBar.getWidth() - this.this$0.contentRect.x;
                this.this$0.contentRect.height = jToolBar.getHeight();
            } else {
                int n4 = SynthIcon.getIconHeight(this.this$0.handleIcon, synthContext);
                for (int i3 = 0; i3 < jToolBar.getComponentCount(); ++i3) {
                    Component component = jToolBar.getComponent(i3);
                    Dimension dimension = component.getPreferredSize();
                    component.setBounds(0, n4, dimension.width, dimension.height);
                    n4 += dimension.height;
                }
                this.this$0.contentRect.x = 0;
                this.this$0.contentRect.y = SynthIcon.getIconHeight(this.this$0.handleIcon, synthContext);
                this.this$0.contentRect.width = jToolBar.getWidth();
                this.this$0.contentRect.height = jToolBar.getHeight() - this.this$0.contentRect.y;
            }
            synthContext.dispose();
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            JToolBar jToolBar = (JToolBar)container;
            Dimension dimension = new Dimension();
            SynthContext synthContext = this.this$0.getContext(jToolBar);
            if (jToolBar.getOrientation() == 0) {
                dimension.width = SynthIcon.getIconWidth(this.this$0.handleIcon, synthContext);
                for (int i2 = 0; i2 < jToolBar.getComponentCount(); ++i2) {
                    Dimension dimension2 = jToolBar.getComponent(i2).getMinimumSize();
                    dimension.width += dimension2.width;
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
            } else {
                dimension.height = SynthIcon.getIconHeight(this.this$0.handleIcon, synthContext);
                for (int i3 = 0; i3 < jToolBar.getComponentCount(); ++i3) {
                    Dimension dimension3 = jToolBar.getComponent(i3).getMinimumSize();
                    dimension.width = Math.max(dimension.width, dimension3.width);
                    dimension.height += dimension3.height;
                }
            }
            synthContext.dispose();
            return dimension;
        }

        public Dimension preferredLayoutSize(Container container) {
            JToolBar jToolBar = (JToolBar)container;
            Dimension dimension = new Dimension();
            SynthContext synthContext = this.this$0.getContext(jToolBar);
            if (jToolBar.getOrientation() == 0) {
                dimension.width = SynthIcon.getIconWidth(this.this$0.handleIcon, synthContext);
                for (int i2 = 0; i2 < jToolBar.getComponentCount(); ++i2) {
                    Dimension dimension2 = jToolBar.getComponent(i2).getPreferredSize();
                    dimension.width += dimension2.width;
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
            } else {
                dimension.height = SynthIcon.getIconHeight(this.this$0.handleIcon, synthContext);
                for (int i3 = 0; i3 < jToolBar.getComponentCount(); ++i3) {
                    Dimension dimension3 = jToolBar.getComponent(i3).getPreferredSize();
                    dimension.width = Math.max(dimension.width, dimension3.width);
                    dimension.height += dimension3.height;
                }
            }
            synthContext.dispose();
            return dimension;
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        private final SynthToolBarUI this$0;

        protected ToolBarContListener(SynthToolBarUI synthToolBarUI) {
            this.this$0 = synthToolBarUI;
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (this.this$0.toolBarFocusListener != null) {
                component.addFocusListener(this.this$0.toolBarFocusListener);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (this.this$0.toolBarFocusListener != null) {
                component.removeFocusListener(this.this$0.toolBarFocusListener);
            }
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        private final SynthToolBarUI this$0;

        protected ToolBarFocusListener(SynthToolBarUI synthToolBarUI) {
            this.this$0 = synthToolBarUI;
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            this.this$0.focusedCompIndex = this.this$0.toolBar.getComponentIndex(component);
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private static class UpAction
    extends KeyAction {
        private UpAction() {
            super(null);
        }

        UpAction(1 var1_1) {
            this();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            SynthToolBarUI synthToolBarUI = (SynthToolBarUI)jToolBar.getUI();
            synthToolBarUI.navigateFocusedComp(1);
        }
    }
}

