/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.CircularIdentityList;
import com.sun.java.swing.plaf.gtk.DefaultSynthStyle;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKEngineParser;
import com.sun.java.swing.plaf.gtk.GTKScanner;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.GTKStyleFactory;
import com.sun.java.swing.plaf.gtk.PangoFonts;
import com.sun.java.swing.plaf.gtk.PropertyParser;
import com.sun.java.swing.plaf.gtk.XColors;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.swing.plaf.ColorUIResource;
import sun.security.action.GetPropertyAction;

class GTKParser {
    private ArrayList freeScanners = new ArrayList();
    private HashMap namedStyles = new HashMap();
    private ArrayList assignments = new ArrayList();
    private HashMap settings = new HashMap();
    private File[] pixmapPaths = null;
    private ArrayList dirStack = new ArrayList();
    private HashMap engineParsers = new HashMap();
    private GTKScanner scanner;
    private final String CWD;
    private static final Symbol SYMBOL_INVALID = new Symbol("invalid", 268);
    private static final Symbol SYMBOL_INCLUDE = new Symbol("include", GTKParser.SYMBOL_INVALID.val + 1);
    private static final Symbol SYMBOL_NORMAL = new Symbol("NORMAL", GTKParser.SYMBOL_INCLUDE.val + 1);
    private static final Symbol SYMBOL_ACTIVE = new Symbol("ACTIVE", GTKParser.SYMBOL_NORMAL.val + 1);
    private static final Symbol SYMBOL_PRELIGHT = new Symbol("PRELIGHT", GTKParser.SYMBOL_ACTIVE.val + 1);
    private static final Symbol SYMBOL_SELECTED = new Symbol("SELECTED", GTKParser.SYMBOL_PRELIGHT.val + 1);
    private static final Symbol SYMBOL_INSENSITIVE = new Symbol("INSENSITIVE", GTKParser.SYMBOL_SELECTED.val + 1);
    private static final Symbol SYMBOL_FG = new Symbol("fg", GTKParser.SYMBOL_INSENSITIVE.val + 1);
    private static final Symbol SYMBOL_BG = new Symbol("bg", GTKParser.SYMBOL_FG.val + 1);
    private static final Symbol SYMBOL_TEXT = new Symbol("text", GTKParser.SYMBOL_BG.val + 1);
    private static final Symbol SYMBOL_BASE = new Symbol("base", GTKParser.SYMBOL_TEXT.val + 1);
    private static final Symbol SYMBOL_XTHICKNESS = new Symbol("xthickness", GTKParser.SYMBOL_BASE.val + 1);
    private static final Symbol SYMBOL_YTHICKNESS = new Symbol("ythickness", GTKParser.SYMBOL_XTHICKNESS.val + 1);
    private static final Symbol SYMBOL_FONT = new Symbol("font", GTKParser.SYMBOL_YTHICKNESS.val + 1);
    private static final Symbol SYMBOL_FONTSET = new Symbol("fontset", GTKParser.SYMBOL_FONT.val + 1);
    private static final Symbol SYMBOL_FONT_NAME = new Symbol("font_name", GTKParser.SYMBOL_FONTSET.val + 1);
    private static final Symbol SYMBOL_BG_PIXMAP = new Symbol("bg_pixmap", GTKParser.SYMBOL_FONT_NAME.val + 1);
    private static final Symbol SYMBOL_PIXMAP_PATH = new Symbol("pixmap_path", GTKParser.SYMBOL_BG_PIXMAP.val + 1);
    private static final Symbol SYMBOL_STYLE = new Symbol("style", GTKParser.SYMBOL_PIXMAP_PATH.val + 1);
    private static final Symbol SYMBOL_BINDING = new Symbol("binding", GTKParser.SYMBOL_STYLE.val + 1);
    private static final Symbol SYMBOL_BIND = new Symbol("bind", GTKParser.SYMBOL_BINDING.val + 1);
    private static final Symbol SYMBOL_WIDGET = new Symbol("widget", GTKParser.SYMBOL_BIND.val + 1);
    private static final Symbol SYMBOL_WIDGET_CLASS = new Symbol("widget_class", GTKParser.SYMBOL_WIDGET.val + 1);
    private static final Symbol SYMBOL_CLASS = new Symbol("class", GTKParser.SYMBOL_WIDGET_CLASS.val + 1);
    private static final Symbol SYMBOL_LOWEST = new Symbol("lowest", GTKParser.SYMBOL_CLASS.val + 1);
    private static final Symbol SYMBOL_GTK = new Symbol("gtk", GTKParser.SYMBOL_LOWEST.val + 1);
    private static final Symbol SYMBOL_APPLICATION = new Symbol("application", GTKParser.SYMBOL_GTK.val + 1);
    private static final Symbol SYMBOL_THEME = new Symbol("theme", GTKParser.SYMBOL_APPLICATION.val + 1);
    private static final Symbol SYMBOL_RC = new Symbol("rc", GTKParser.SYMBOL_THEME.val + 1);
    private static final Symbol SYMBOL_HIGHEST = new Symbol("highest", GTKParser.SYMBOL_RC.val + 1);
    private static final Symbol SYMBOL_ENGINE = new Symbol("engine", GTKParser.SYMBOL_HIGHEST.val + 1);
    private static final Symbol SYMBOL_MODULE_PATH = new Symbol("module_path", GTKParser.SYMBOL_ENGINE.val + 1);
    private static final Symbol SYMBOL_IM_MODULE_PATH = new Symbol("im_module_path", GTKParser.SYMBOL_MODULE_PATH.val + 1);
    private static final Symbol SYMBOL_IM_MODULE_FILE = new Symbol("im_module_file", GTKParser.SYMBOL_IM_MODULE_PATH.val + 1);
    private static final Symbol SYMBOL_STOCK = new Symbol("stock", GTKParser.SYMBOL_IM_MODULE_FILE.val + 1);
    private static final Symbol SYMBOL_LTR = new Symbol("LTR", GTKParser.SYMBOL_STOCK.val + 1);
    private static final Symbol SYMBOL_RTL = new Symbol("RTL", GTKParser.SYMBOL_LTR.val + 1);
    private static final Symbol SYMBOL_LAST = new Symbol("last", GTKParser.SYMBOL_RTL.val + 1);
    private static final Symbol[] symbols = new Symbol[]{SYMBOL_INCLUDE, SYMBOL_NORMAL, SYMBOL_ACTIVE, SYMBOL_PRELIGHT, SYMBOL_SELECTED, SYMBOL_INSENSITIVE, SYMBOL_FG, SYMBOL_BG, SYMBOL_TEXT, SYMBOL_BASE, SYMBOL_XTHICKNESS, SYMBOL_YTHICKNESS, SYMBOL_FONT, SYMBOL_FONTSET, SYMBOL_FONT_NAME, SYMBOL_BG_PIXMAP, SYMBOL_PIXMAP_PATH, SYMBOL_STYLE, SYMBOL_BINDING, SYMBOL_BIND, SYMBOL_WIDGET, SYMBOL_WIDGET_CLASS, SYMBOL_CLASS, SYMBOL_LOWEST, SYMBOL_GTK, SYMBOL_APPLICATION, SYMBOL_THEME, SYMBOL_RC, SYMBOL_HIGHEST, SYMBOL_ENGINE, SYMBOL_MODULE_PATH, SYMBOL_IM_MODULE_FILE, SYMBOL_STOCK, SYMBOL_LTR, SYMBOL_RTL};

    private int ignoreBlock() throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 123) {
            return 123;
        }
        int n3 = 1;
        block5: while (n3 > 0) {
            n2 = this.scanner.getToken();
            switch (n2) {
                case -1: {
                    return 125;
                }
                case 123: {
                    ++n3;
                    continue block5;
                }
                case 125: {
                    --n3;
                    continue block5;
                }
            }
        }
        return 256;
    }

    private int parseBinding() throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != GTKParser.SYMBOL_BINDING.val) {
            return GTKParser.SYMBOL_BINDING.val;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        n2 = this.ignoreBlock();
        if (n2 != 256) {
            return n2;
        }
        this.scanner.printMessage("Binding specification is unsupported, ignoring", false);
        return 256;
    }

    private int parseIMModuleFile() throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != GTKParser.SYMBOL_IM_MODULE_FILE.val) {
            return GTKParser.SYMBOL_IM_MODULE_FILE.val;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        this.scanner.printMessage("im_module_file directive is unsupported, ignoring", false);
        return 256;
    }

    private int parseIdentifier() throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 266) {
            return 266;
        }
        Object[] objectArray = new Object[1];
        StringBuffer stringBuffer = new StringBuffer(this.scanner.currValue.stringVal);
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";
        int n3 = stringBuffer.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (string.indexOf(stringBuffer.charAt(i2)) != -1) continue;
            stringBuffer.setCharAt(i2, '-');
        }
        String string2 = stringBuffer.toString().intern();
        n2 = this.parsePropertyAssignment(objectArray);
        if (n2 != 256) {
            return n2;
        }
        this.settings.put(string2, objectArray[0]);
        return 256;
    }

    private int parseInclude() throws IOException {
        Object[] objectArray;
        int n2 = this.scanner.getToken();
        if (n2 != GTKParser.SYMBOL_INCLUDE.val) {
            return GTKParser.SYMBOL_INCLUDE.val;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        File file = null;
        String string = this.scanner.currValue.stringVal;
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            file = file2;
        } else {
            objectArray = new File[this.dirStack.size()];
            objectArray = (File[])this.dirStack.toArray(objectArray);
            for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
                file2 = new File((File)objectArray[i2], string);
                if (!file2.exists()) continue;
                file = file2;
                break;
            }
        }
        if (file == null) {
            this.scanner.printMessage("Unable to find include file: \"" + string + "\"", false);
        } else {
            objectArray = this.scanner;
            try {
                this.parseFile(file2, string);
            }
            catch (IOException iOException) {
                objectArray.printMessage("(" + iOException.toString() + ") while parsing include file: \"" + string + "\"", false);
            }
            this.scanner = objectArray;
        }
        return 256;
    }

    private int parseModulePath() throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != GTKParser.SYMBOL_MODULE_PATH.val) {
            return GTKParser.SYMBOL_MODULE_PATH.val;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        this.scanner.printMessage("module_path directive is now ignored", false);
        return 256;
    }

    private int parsePixmapPath() throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != GTKParser.SYMBOL_PIXMAP_PATH.val) {
            return GTKParser.SYMBOL_PIXMAP_PATH.val;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        this.pixmapPaths = null;
        ArrayList arrayList = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(this.scanner.currValue.stringVal, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            File file = new File(string);
            if (file.isAbsolute()) {
                arrayList.add(file);
                continue;
            }
            this.scanner.printMessage("Pixmap path element: \"" + string + "\" must be absolute", false);
        }
        if (arrayList.size() > 0) {
            this.pixmapPaths = new File[arrayList.size()];
            this.pixmapPaths = (File[])arrayList.toArray(this.pixmapPaths);
        }
        return 256;
    }

    private int parseStatement() throws IOException {
        int n2 = this.scanner.peekNextToken();
        if (n2 == GTKParser.SYMBOL_INCLUDE.val) {
            return this.parseInclude();
        }
        if (n2 == GTKParser.SYMBOL_STYLE.val) {
            return this.parseStyle();
        }
        if (n2 == GTKParser.SYMBOL_BINDING.val) {
            return this.parseBinding();
        }
        if (n2 == GTKParser.SYMBOL_PIXMAP_PATH.val) {
            return this.parsePixmapPath();
        }
        if (n2 == GTKParser.SYMBOL_WIDGET.val || n2 == GTKParser.SYMBOL_WIDGET_CLASS.val || n2 == GTKParser.SYMBOL_CLASS.val) {
            return this.parseAssignment(n2);
        }
        if (n2 == GTKParser.SYMBOL_MODULE_PATH.val) {
            return this.parseModulePath();
        }
        if (n2 == GTKParser.SYMBOL_IM_MODULE_FILE.val) {
            return this.parseIMModuleFile();
        }
        if (n2 == 266) {
            return this.parseIdentifier();
        }
        this.scanner.getToken();
        return GTKParser.SYMBOL_STYLE.val;
    }

    private int parseStyle() throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != GTKParser.SYMBOL_STYLE.val) {
            return GTKParser.SYMBOL_STYLE.val;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        StyleInfo styleInfo = (StyleInfo)this.namedStyles.get(this.scanner.currValue.stringVal);
        if (styleInfo == null) {
            styleInfo = new StyleInfo(this.scanner.currValue.stringVal);
        }
        if ((n2 = this.scanner.peekNextToken()) == 61) {
            n2 = this.scanner.getToken();
            n2 = this.scanner.getToken();
            if (n2 != 264) {
                return 264;
            }
            StyleInfo styleInfo2 = (StyleInfo)this.namedStyles.get(this.scanner.currValue.stringVal);
            if (styleInfo2 != null) {
                styleInfo.copyDataFrom(styleInfo2);
            }
        }
        if ((n2 = this.scanner.getToken()) != 123) {
            return 123;
        }
        n2 = this.scanner.peekNextToken();
        while (n2 != 125) {
            if (n2 == GTKParser.SYMBOL_FG.val || n2 == GTKParser.SYMBOL_BG.val || n2 == GTKParser.SYMBOL_TEXT.val || n2 == GTKParser.SYMBOL_BASE.val) {
                n2 = this.parseColorSetting(n2, styleInfo);
            } else if (n2 == GTKParser.SYMBOL_XTHICKNESS.val || n2 == GTKParser.SYMBOL_YTHICKNESS.val) {
                n2 = this.parseThickness(n2, styleInfo);
            } else if (n2 == GTKParser.SYMBOL_BG_PIXMAP.val) {
                n2 = this.parseBGPixmap(styleInfo);
            } else if (n2 == GTKParser.SYMBOL_FONT.val || n2 == GTKParser.SYMBOL_FONTSET.val || n2 == GTKParser.SYMBOL_FONT_NAME.val) {
                n2 = this.parseFont(n2, styleInfo);
            } else if (n2 == GTKParser.SYMBOL_ENGINE.val) {
                n2 = this.parseEngine(styleInfo);
            } else if (n2 == GTKParser.SYMBOL_STOCK.val) {
                n2 = this.parseStock(styleInfo);
            } else if (n2 == 266) {
                n2 = this.parseIdentifierInStyle(styleInfo);
            } else {
                this.scanner.getToken();
                n2 = 125;
            }
            if (n2 != 256) {
                return n2;
            }
            n2 = this.scanner.peekNextToken();
        }
        n2 = this.scanner.getToken();
        if (n2 != 125) {
            return 125;
        }
        this.namedStyles.put(styleInfo.name, styleInfo);
        return 256;
    }

    public GTKParser() {
        this.engineParsers.put("pixmap", "com.sun.java.swing.plaf.gtk.PixmapEngineParser");
        this.engineParsers.put("bluecurve", "com.sun.java.swing.plaf.gtk.BluecurveEngineParser");
        this.engineParsers.put("blueprint", "com.sun.java.swing.plaf.gtk.BlueprintEngineParser");
        this.CWD = (String)AccessController.doPrivileged(new GetPropertyAction("user.dir"));
        this.freeScanners.add(GTKParser.createScanner());
    }

    public void clearParser() {
        this.namedStyles.clear();
        this.settings.clear();
        this.assignments.clear();
        this.dirStack.clear();
        this.pixmapPaths = null;
    }

    private void parseCurrent() throws IOException {
        while (this.scanner.peekNextToken() != -1) {
            int n2 = this.parseStatement();
            if (n2 == 256) continue;
            String string = null;
            String string2 = null;
            if (this.scanner.currScope == 0) {
                Symbol symbol = GTKParser.getSymbol(n2);
                if (symbol != null) {
                    string2 = "e.g. `" + symbol.name + "'";
                }
                if ((symbol = GTKParser.getSymbol(this.scanner.currToken)) != null) {
                    string = symbol.name;
                }
            }
            this.scanner.unexpectedToken(n2, string, string2, true);
            break;
        }
    }

    private void printAssignments() {
        System.out.println("===== Assignments =====");
        Object[] objectArray = new Assignment[this.assignments.size()];
        objectArray = (Assignment[])this.assignments.toArray(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            System.out.println(objectArray[i2]);
        }
    }

    private void printNamedStyles() {
        System.out.println("===== Named Styles =====");
        Object[] objectArray = new StyleInfo[this.namedStyles.size()];
        objectArray = (StyleInfo[])this.namedStyles.values().toArray(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            System.out.println("NAME: " + ((StyleInfo)object).name);
            GTKStyle gTKStyle = ((StyleInfo)object).toGTKStyle();
            System.out.println(gTKStyle == StyleInfo.access$000() ? "EMPTY_STYLE" : gTKStyle.toString());
            System.out.println("---------------------------");
        }
    }

    private void printSettings() {
        System.out.println("===== GTK Settings =====");
        Iterator iterator = this.settings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            System.out.println(entry.getKey() + "=" + entry.getValue());
        }
    }

    private static float javaColorVal(double d2) {
        float f2 = (float)Math.max(Math.min(d2, 1.0), 0.0);
        return f2;
    }

    private int parseAssignment(int n2) throws IOException {
        boolean bl2;
        int n3;
        int n4 = this.scanner.getToken();
        if (n4 != n2) {
            return n2;
        }
        if (n4 == GTKParser.SYMBOL_WIDGET.val) {
            n3 = 0;
        } else if (n4 == GTKParser.SYMBOL_WIDGET_CLASS.val) {
            n3 = 1;
        } else if (n4 == GTKParser.SYMBOL_CLASS.val) {
            n3 = 2;
        } else {
            return GTKParser.SYMBOL_WIDGET_CLASS.val;
        }
        n4 = this.scanner.getToken();
        if (n4 != 264) {
            return 264;
        }
        String string = this.scanner.currValue.stringVal;
        n4 = this.scanner.getToken();
        if (n4 == GTKParser.SYMBOL_STYLE.val) {
            bl2 = false;
        } else if (n4 == GTKParser.SYMBOL_BINDING.val) {
            bl2 = true;
        } else {
            return GTKParser.SYMBOL_STYLE.val;
        }
        n4 = this.scanner.peekNextToken();
        if (n4 == 58) {
            n4 = this.scanner.getToken();
            n4 = this.scanner.getToken();
            if (n4 != GTKParser.SYMBOL_LOWEST.val && n4 != GTKParser.SYMBOL_GTK.val && n4 != GTKParser.SYMBOL_APPLICATION.val && n4 != GTKParser.SYMBOL_THEME.val && n4 != GTKParser.SYMBOL_RC.val && n4 != GTKParser.SYMBOL_HIGHEST.val) {
                return GTKParser.SYMBOL_APPLICATION.val;
            }
            this.scanner.printMessage("Priority specification is unsupported, ignoring", false);
        }
        if ((n4 = this.scanner.getToken()) != 264) {
            return 264;
        }
        if (bl2) {
            this.scanner.printMessage("Binding assignment is unsupported, ignoring", false);
        } else {
            StyleInfo styleInfo = (StyleInfo)this.namedStyles.get(this.scanner.currValue.stringVal);
            if (styleInfo == null) {
                return 264;
            }
            Assignment assignment = new Assignment(n3, string, styleInfo);
            this.assignments.add(assignment);
        }
        return 256;
    }

    private static float javaColorVal(long l2) {
        int n2 = (int)Math.max(Math.min(l2, 65535L), 0L);
        return (float)l2 / 65535.0f;
    }

    private int parseState(int[] nArray) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 91) {
            return 91;
        }
        n2 = this.scanner.getToken();
        if (n2 == GTKParser.SYMBOL_NORMAL.val) {
            nArray[0] = 0;
        } else if (n2 == GTKParser.SYMBOL_ACTIVE.val) {
            nArray[0] = 2;
        } else if (n2 == GTKParser.SYMBOL_PRELIGHT.val) {
            nArray[0] = 1;
        } else if (n2 == GTKParser.SYMBOL_SELECTED.val) {
            nArray[0] = 4;
        } else if (n2 == GTKParser.SYMBOL_INSENSITIVE.val) {
            nArray[0] = 3;
        } else {
            return GTKParser.SYMBOL_NORMAL.val;
        }
        n2 = this.scanner.getToken();
        if (n2 != 93) {
            return 93;
        }
        return 256;
    }

    private int parseColorSetting(int n2, StyleInfo styleInfo) throws IOException {
        int n3 = this.scanner.getToken();
        if (n3 != n2) {
            return n2;
        }
        Color[] colorArray = null;
        if (n3 == GTKParser.SYMBOL_FG.val) {
            colorArray = styleInfo.fg;
        } else if (n3 == GTKParser.SYMBOL_BG.val) {
            colorArray = styleInfo.bg;
        } else if (n3 == GTKParser.SYMBOL_TEXT.val) {
            colorArray = styleInfo.text;
        } else if (n3 == GTKParser.SYMBOL_BASE.val) {
            colorArray = styleInfo.base;
        } else {
            return GTKParser.SYMBOL_FG.val;
        }
        int[] nArray = new int[1];
        n3 = this.parseState(nArray);
        if (n3 != 256) {
            return n3;
        }
        n3 = this.scanner.getToken();
        if (n3 != 61) {
            return 61;
        }
        return this.parseColor(colorArray, nArray[0]);
    }

    private int parseFont(int n2, StyleInfo styleInfo) throws IOException {
        boolean bl2;
        int n3 = this.scanner.getToken();
        if (n3 != n2) {
            return n2;
        }
        if (n3 == GTKParser.SYMBOL_FONT_NAME.val) {
            bl2 = true;
        } else if (n3 == GTKParser.SYMBOL_FONT.val || n3 == GTKParser.SYMBOL_FONTSET.val) {
            bl2 = false;
        } else {
            return GTKParser.SYMBOL_FONT_NAME.val;
        }
        n3 = this.scanner.getToken();
        if (n3 != 61) {
            return 61;
        }
        n3 = this.scanner.getToken();
        if (n3 != 264) {
            return 264;
        }
        if (bl2) {
            String string = this.scanner.currValue.stringVal;
            styleInfo.font = PangoFonts.lookupFont(string);
        }
        return 256;
    }

    private int parseThickness(int n2, StyleInfo styleInfo) throws IOException {
        boolean bl2;
        int n3 = this.scanner.getToken();
        if (n3 != n2) {
            return n2;
        }
        if (n3 == GTKParser.SYMBOL_XTHICKNESS.val) {
            bl2 = true;
        } else if (n3 == GTKParser.SYMBOL_YTHICKNESS.val) {
            bl2 = false;
        } else {
            return GTKParser.SYMBOL_XTHICKNESS.val;
        }
        n3 = this.scanner.getToken();
        if (n3 != 61) {
            return 61;
        }
        n3 = this.scanner.getToken();
        if (n3 != 261) {
            return 261;
        }
        int n4 = (int)this.scanner.currValue.longVal;
        if (bl2) {
            styleInfo.xThickness = n4;
        } else {
            styleInfo.yThickness = n4;
        }
        return 256;
    }

    private int parseBGPixmap(StyleInfo styleInfo) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != GTKParser.SYMBOL_BG_PIXMAP.val) {
            return GTKParser.SYMBOL_BG_PIXMAP.val;
        }
        int[] nArray = new int[1];
        n2 = this.parseState(nArray);
        if (n2 != 256) {
            return n2;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        String string = null;
        String string2 = this.scanner.currValue.stringVal;
        string = string2.equals("<none>") || string2.equals("<parent>") ? string2.intern() : this.resolvePixmapPath(string2);
        if (string == null) {
            this.scanner.printMessage("Unable to locate image file in pixmap_path: \"" + string2 + "\"", false);
        } else {
            styleInfo.bgPixmapName[nArray[0]] = string;
        }
        return 256;
    }

    private int parseEngine(StyleInfo styleInfo) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != GTKParser.SYMBOL_ENGINE.val) {
            return GTKParser.SYMBOL_ENGINE.val;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        String string = this.scanner.currValue.stringVal;
        if (string.length() == 0) {
            n2 = this.scanner.getToken();
            if (n2 != 123) {
                return 123;
            }
            n2 = this.scanner.getToken();
            if (n2 != 125) {
                return 125;
            }
            styleInfo.engineInfo = null;
            return 256;
        }
        GTKEngineParser gTKEngineParser = this.getParser(string);
        if (gTKEngineParser == null) {
            n2 = this.ignoreBlock();
            if (n2 != 256) {
                return n2;
            }
            this.scanner.printMessage("Engine \"" + string + "\" is unsupported, ignoring", false);
        } else {
            n2 = this.scanner.getToken();
            if (n2 != 123) {
                return 123;
            }
            EngineInfo[] engineInfoArray = new EngineInfo[1];
            if (styleInfo.engineInfo != null && string.equals(EngineInfo.access$100(styleInfo.engineInfo))) {
                engineInfoArray[0] = styleInfo.engineInfo;
            }
            if ((n2 = gTKEngineParser.parse(this.scanner, this, engineInfoArray)) != 256) {
                return n2;
            }
            if (engineInfoArray[0] != null) {
                EngineInfo.access$102(engineInfoArray[0], string);
            }
            styleInfo.engineInfo = engineInfoArray[0];
        }
        return 256;
    }

    private int parseIdentifierInStyle(StyleInfo styleInfo) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 266 || this.scanner.currValue.stringVal.charAt(0) < 'A' || this.scanner.currValue.stringVal.charAt(0) > 'Z') {
            return 266;
        }
        Object[] objectArray = new Object[1];
        String string = this.scanner.currValue.stringVal.intern();
        if (this.scanner.getToken() != 58 || this.scanner.getToken() != 58) {
            return 58;
        }
        n2 = this.scanner.getToken();
        if (n2 != 266) {
            return 266;
        }
        StringBuffer stringBuffer = new StringBuffer(this.scanner.currValue.stringVal);
        String string2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";
        int n3 = stringBuffer.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (string2.indexOf(stringBuffer.charAt(i2)) != -1) continue;
            stringBuffer.setCharAt(i2, '-');
        }
        String string3 = stringBuffer.toString().intern();
        n2 = this.parsePropertyAssignment(objectArray);
        if (n2 != 256) {
            return n2;
        }
        PropertyParser propertyParser = null;
        if (objectArray[0] instanceof String && (propertyParser = PropertyParser.getParserFor(string3)) != null) {
            Object object = propertyParser.parse((String)objectArray[0]);
            if (object == null) {
                this.scanner.printMessage("Failed to parse property value \"" + objectArray[0] + "\" for `" + string + "::" + string3 + "'", false);
            } else {
                styleInfo.addProperty(string, string3, object);
            }
        } else {
            styleInfo.addProperty(string, string3, objectArray[0]);
        }
        return 256;
    }

    private int parseStock(StyleInfo styleInfo) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != GTKParser.SYMBOL_STOCK.val) {
            return GTKParser.SYMBOL_STOCK.val;
        }
        n2 = this.scanner.getToken();
        if (n2 != 91) {
            return 91;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        String string = this.scanner.currValue.stringVal;
        n2 = this.scanner.getToken();
        if (n2 != 93) {
            return 93;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        if (n2 != 123) {
            return 123;
        }
        ArrayList arrayList = new ArrayList();
        Object[] objectArray = new GTKStyle.GTKIconSource[1];
        n2 = this.scanner.peekNextToken();
        while (n2 != 125) {
            n2 = this.parseIconSource((GTKStyle.GTKIconSource[])objectArray);
            if (n2 != 256) {
                return n2;
            }
            n2 = this.scanner.getToken();
            if (n2 != 44 && n2 != 125) {
                return 125;
            }
            if (objectArray[0] == null) continue;
            arrayList.add(objectArray[0]);
        }
        if (arrayList.size() != 0) {
            objectArray = new GTKStyle.GTKIconSource[arrayList.size()];
            objectArray = (GTKStyle.GTKIconSource[])arrayList.toArray(objectArray);
            styleInfo.addStockItem(string, (GTKStyle.GTKIconSource[])objectArray);
        }
        return 256;
    }

    private static Symbol getSymbol(int n2) {
        if (n2 > GTKParser.SYMBOL_INVALID.val && n2 < GTKParser.SYMBOL_LAST.val) {
            for (int i2 = 0; i2 < symbols.length; ++i2) {
                if (GTKParser.symbols[i2].val != n2) continue;
                return symbols[i2];
            }
        }
        return null;
    }

    private static GTKScanner createScanner() {
        GTKScanner gTKScanner = new GTKScanner();
        gTKScanner.caseSensitive = true;
        gTKScanner.scanBinary = true;
        gTKScanner.scanHexDollar = true;
        gTKScanner.symbol2Token = true;
        for (int i2 = 0; i2 < symbols.length; ++i2) {
            gTKScanner.addSymbol(GTKParser.symbols[i2].name, GTKParser.symbols[i2].val);
        }
        return gTKScanner;
    }

    private int parseIconSource(GTKStyle.GTKIconSource[] gTKIconSourceArray) throws IOException {
        String string = null;
        int n2 = -100;
        int n3 = -100;
        String string2 = null;
        int n4 = this.scanner.getToken();
        if (n4 != 123) {
            return 123;
        }
        n4 = this.scanner.getToken();
        if (n4 != 264) {
            return 264;
        }
        string = this.scanner.currValue.stringVal;
        n4 = this.scanner.getToken();
        if (n4 == 125) {
            gTKIconSourceArray[0] = this.createIconSource(string, n2, n3, string2);
            return 256;
        }
        if (n4 != 44) {
            return 44;
        }
        n4 = this.scanner.getToken();
        if (n4 == GTKParser.SYMBOL_RTL.val) {
            n2 = 1;
        } else if (n4 == GTKParser.SYMBOL_LTR.val) {
            n2 = 0;
        } else if (n4 != 42) {
            return GTKParser.SYMBOL_RTL.val;
        }
        n4 = this.scanner.getToken();
        if (n4 == 125) {
            gTKIconSourceArray[0] = this.createIconSource(string, n2, n3, string2);
            return 256;
        }
        if (n4 != 44) {
            return 44;
        }
        n4 = this.scanner.getToken();
        if (n4 == GTKParser.SYMBOL_NORMAL.val) {
            n3 = 1;
        } else if (n4 == GTKParser.SYMBOL_ACTIVE.val) {
            n3 = 4;
        } else if (n4 == GTKParser.SYMBOL_PRELIGHT.val) {
            n3 = 2;
        } else if (n4 == GTKParser.SYMBOL_SELECTED.val) {
            n3 = 512;
        } else if (n4 == GTKParser.SYMBOL_INSENSITIVE.val) {
            n3 = 8;
        } else if (n4 != 42) {
            return GTKParser.SYMBOL_PRELIGHT.val;
        }
        n4 = this.scanner.getToken();
        if (n4 == 125) {
            gTKIconSourceArray[0] = this.createIconSource(string, n2, n3, string2);
            return 256;
        }
        if (n4 != 44) {
            return 44;
        }
        n4 = this.scanner.getToken();
        if (n4 != 42) {
            if (n4 != 264) {
                return 264;
            }
            string2 = this.scanner.currValue.stringVal;
            if (GTKStyle.getIconSize(string2) == null) {
                string2 = null;
            }
        }
        if ((n4 = this.scanner.getToken()) != 125) {
            return 125;
        }
        gTKIconSourceArray[0] = this.createIconSource(string, n2, n3, string2);
        return 256;
    }

    public void loadStylesInto(GTKStyleFactory gTKStyleFactory) {
        Object[] objectArray = new Assignment[this.assignments.size()];
        objectArray = (Assignment[])this.assignments.toArray(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            GTKStyle gTKStyle = ((Assignment)object).info.toGTKStyle();
            if (gTKStyle == StyleInfo.access$000()) continue;
            try {
                gTKStyleFactory.addStyle(gTKStyle, ((Assignment)object).pattern, ((Assignment)object).type);
                continue;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    private int parseColor(Color[] colorArray, int n2) throws IOException {
        int n3 = this.scanner.getToken();
        switch (n3) {
            case 123: {
                float f2;
                float f3;
                float f4;
                n3 = this.scanner.getToken();
                if (n3 == 261) {
                    f4 = GTKParser.javaColorVal(this.scanner.currValue.longVal);
                } else if (n3 == 263) {
                    f4 = GTKParser.javaColorVal(this.scanner.currValue.doubleVal);
                } else {
                    return 263;
                }
                n3 = this.scanner.getToken();
                if (n3 != 44) {
                    return 44;
                }
                n3 = this.scanner.getToken();
                if (n3 == 261) {
                    f3 = GTKParser.javaColorVal(this.scanner.currValue.longVal);
                } else if (n3 == 263) {
                    f3 = GTKParser.javaColorVal(this.scanner.currValue.doubleVal);
                } else {
                    return 263;
                }
                n3 = this.scanner.getToken();
                if (n3 != 44) {
                    return 44;
                }
                n3 = this.scanner.getToken();
                if (n3 == 261) {
                    f2 = GTKParser.javaColorVal(this.scanner.currValue.longVal);
                } else if (n3 == 263) {
                    f2 = GTKParser.javaColorVal(this.scanner.currValue.doubleVal);
                } else {
                    return 263;
                }
                n3 = this.scanner.getToken();
                if (n3 != 125) {
                    return 125;
                }
                colorArray[n2] = new ColorUIResource(f4, f3, f2);
                break;
            }
            case 264: {
                Color color = GTKParser.parseColorString(this.scanner.currValue.stringVal);
                if (color == null) {
                    this.scanner.printMessage("Invalid color constant '" + this.scanner.currValue.stringVal + "'", false);
                    return 264;
                }
                colorArray[n2] = color;
                break;
            }
            default: {
                return 264;
            }
        }
        return 256;
    }

    private int parsePropertyAssignment(Object[] objectArray) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        boolean bl2 = this.scanner.scanIdentifier;
        boolean bl3 = this.scanner.scanSymbols;
        boolean bl4 = this.scanner.identifier2String;
        boolean bl5 = this.scanner.char2Token;
        boolean bl6 = this.scanner.scanIdentifierNULL;
        boolean bl7 = this.scanner.numbers2Int;
        this.scanner.scanIdentifier = true;
        this.scanner.scanSymbols = false;
        this.scanner.identifier2String = false;
        this.scanner.char2Token = true;
        this.scanner.scanIdentifierNULL = false;
        this.scanner.numbers2Int = true;
        boolean bl8 = false;
        if (this.scanner.peekNextToken() == 45) {
            this.scanner.getToken();
            bl8 = true;
        }
        n2 = this.scanner.peekNextToken();
        switch (n2) {
            case 261: {
                this.scanner.getToken();
                objectArray[0] = new Long(bl8 ? -this.scanner.currValue.longVal : this.scanner.currValue.longVal);
                n2 = 256;
                break;
            }
            case 263: {
                this.scanner.getToken();
                objectArray[0] = new Double(bl8 ? -this.scanner.currValue.doubleVal : this.scanner.currValue.doubleVal);
                n2 = 256;
                break;
            }
            case 264: {
                this.scanner.getToken();
                if (bl8) {
                    n2 = 261;
                    break;
                }
                objectArray[0] = this.scanner.currValue.stringVal;
                n2 = 256;
                break;
            }
            case 40: 
            case 91: 
            case 123: 
            case 266: {
                if (bl8) {
                    n2 = 261;
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer();
                n2 = this.parseComplexPropVal(stringBuffer, -1);
                if (n2 != 256) break;
                stringBuffer.append(' ');
                objectArray[0] = stringBuffer.toString();
                break;
            }
            default: {
                this.scanner.getToken();
                n2 = 261;
            }
        }
        this.scanner.scanIdentifier = bl2;
        this.scanner.scanSymbols = bl3;
        this.scanner.identifier2String = bl4;
        this.scanner.char2Token = bl5;
        this.scanner.scanIdentifierNULL = bl6;
        this.scanner.numbers2Int = bl7;
        return n2;
    }

    public void parseString(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        this.parseReader(stringReader, "-");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java GTKParser <gtkrc file> <gtkrc file>....");
            System.exit(1);
        }
        GTKParser gTKParser = new GTKParser();
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                gTKParser.parseFile(new File(stringArray[i2]), stringArray[i2]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        gTKParser.printNamedStyles();
        System.out.println();
        gTKParser.printSettings();
        System.out.println();
        gTKParser.printAssignments();
    }

    private int parseComplexPropVal(StringBuffer stringBuffer, int n2) throws IOException {
        int n3 = this.scanner.getToken();
        switch (n3) {
            case 261: {
                stringBuffer.append(" 0x");
                stringBuffer.append(Long.toHexString(this.scanner.currValue.longVal));
                break;
            }
            case 263: {
                stringBuffer.append(' ');
                stringBuffer.append(this.scanner.currValue.doubleVal);
                break;
            }
            case 264: {
                stringBuffer.append(" \"");
                stringBuffer.append(this.escapeString(this.scanner.currValue.stringVal));
                stringBuffer.append('\"');
                break;
            }
            case 266: {
                stringBuffer.append(' ');
                stringBuffer.append(this.scanner.currValue.stringVal);
                break;
            }
            case 40: {
                stringBuffer.append(' ');
                stringBuffer.append((char)n3);
                n3 = this.parseComplexPropVal(stringBuffer, 41);
                if (n3 == 256) break;
                return n3;
            }
            case 123: {
                stringBuffer.append(' ');
                stringBuffer.append((char)n3);
                n3 = this.parseComplexPropVal(stringBuffer, 125);
                if (n3 == 256) break;
                return n3;
            }
            case 91: {
                stringBuffer.append(' ');
                stringBuffer.append((char)n3);
                n3 = this.parseComplexPropVal(stringBuffer, 93);
                if (n3 == 256) break;
                return n3;
            }
            default: {
                if (n3 >= 256 || n3 <= -1) {
                    return n2 != -1 ? n2 : 264;
                }
                stringBuffer.append(' ');
                stringBuffer.append((char)n3);
                if (n3 != n2) break;
                return 256;
            }
        }
        if (n2 == -1) {
            return 256;
        }
        return this.parseComplexPropVal(stringBuffer, n2);
    }

    public HashMap getGTKSettings() {
        return this.settings;
    }

    private GTKEngineParser getParser(String string) {
        Object object = this.engineParsers.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof GTKEngineParser) {
            return (GTKEngineParser)object;
        }
        GTKEngineParser gTKEngineParser = null;
        try {
            gTKEngineParser = (GTKEngineParser)Class.forName((String)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (gTKEngineParser == null) {
            this.engineParsers.remove(string);
        } else {
            this.engineParsers.put(string, gTKEngineParser);
        }
        return gTKEngineParser;
    }

    private static Color parseColorString(String string) {
        if (string.charAt(0) == '#') {
            int n2;
            int n3;
            int n4;
            int n5 = (string = string.substring(1)).length();
            if (n5 < 3 || n5 > 12 || n5 % 3 != 0) {
                return null;
            }
            n5 /= 3;
            try {
                n4 = Integer.parseInt(string.substring(0, n5), 16);
                n3 = Integer.parseInt(string.substring(n5, n5 * 2), 16);
                n2 = Integer.parseInt(string.substring(n5 * 2, n5 * 3), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (n5 == 4) {
                return new ColorUIResource((float)n4 / 65535.0f, (float)n3 / 65535.0f, (float)n2 / 65535.0f);
            }
            if (n5 == 1) {
                return new ColorUIResource((float)n4 / 15.0f, (float)n3 / 15.0f, (float)n2 / 15.0f);
            }
            if (n5 == 2) {
                return new ColorUIResource(n4, n3, n2);
            }
            return new ColorUIResource((float)n4 / 4095.0f, (float)n3 / 4095.0f, (float)n2 / 4095.0f);
        }
        return XColors.lookupColor(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile(File file, String string) throws IOException {
        if (!file.canRead() || !file.isFile()) {
            return;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File(this.CWD);
        }
        this.dirStack.add(file2);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            this.parseReader(bufferedReader, string);
        }
        finally {
            this.dirStack.remove(this.dirStack.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseReader(Reader reader, String string) throws IOException {
        int n2 = this.freeScanners.size();
        this.scanner = n2 == 0 ? GTKParser.createScanner() : (GTKScanner)this.freeScanners.remove(n2 - 1);
        this.scanner.scanReader(reader, string);
        try {
            this.parseCurrent();
        }
        finally {
            this.scanner.clearScanner();
            this.freeScanners.add(this.scanner);
        }
    }

    private String escapeString(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 * 4);
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block9;
                }
                default: {
                    if (c2 < ' ' || c2 > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append(Integer.toOctalString(c2));
                        continue block9;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    String resolvePixmapPath(String string) {
        if (this.pixmapPaths != null) {
            for (int i2 = 0; i2 < this.pixmapPaths.length; ++i2) {
                File file = new File(this.pixmapPaths[i2], string);
                if (!file.canRead()) continue;
                return file.getAbsolutePath();
            }
        }
        Object[] objectArray = new File[this.dirStack.size()];
        objectArray = (File[])this.dirStack.toArray(objectArray);
        for (int i3 = objectArray.length - 1; i3 >= 0; --i3) {
            File file = new File((File)objectArray[i3], string);
            if (!file.canRead()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    private GTKStyle.GTKIconSource createIconSource(String string, int n2, int n3, String string2) {
        String string3 = this.resolvePixmapPath(string);
        if (string3 != null) {
            return new GTKStyle.GTKIconSource(string3, n2, n3, string2);
        }
        return null;
    }

    private static class Assignment {
        int type;
        String pattern;
        StyleInfo info;

        public String toString() {
            String string = "";
            switch (this.type) {
                case 0: {
                    string = "widget, ";
                    break;
                }
                case 1: {
                    string = "widget_class, ";
                    break;
                }
                case 2: {
                    string = "class, ";
                }
            }
            string = string + this.pattern + ", ";
            string = string + this.info.name;
            return string;
        }

        Assignment(int n2, String string, StyleInfo styleInfo) {
            this.type = n2;
            this.pattern = string;
            this.info = styleInfo;
        }
    }

    static abstract class EngineInfo {
        private String engineName;

        EngineInfo() {
        }

        static String access$100(EngineInfo engineInfo) {
            return engineInfo.engineName;
        }

        static String access$102(EngineInfo engineInfo, String string) {
            engineInfo.engineName = string;
            return engineInfo.engineName;
        }

        abstract GTKStyle constructGTKStyle(GTKStyle.GTKStateInfo[] var1, CircularIdentityList var2, Font var3, int var4, int var5, GTKStyle.GTKStockIconInfo[] var6);
    }

    private static class StyleInfo {
        String name;
        static final int NUM_STATES = 5;
        static final int NORMAL = 0;
        static final int PRELIGHT = 1;
        static final int ACTIVE = 2;
        static final int INSENSITIVE = 3;
        static final int SELECTED = 4;
        Color[] fg = new Color[5];
        Color[] bg = new Color[5];
        Color[] text = new Color[5];
        Color[] base = new Color[5];
        String[] bgPixmapName = new String[5];
        Font font = null;
        int xThickness = -1;
        int yThickness = -1;
        ArrayList stocks = null;
        CircularIdentityList props = null;
        EngineInfo engineInfo = null;
        private GTKStyle cachedStyle = null;
        private static GTKStyle EMPTY_STYLE = new GTKStyle();

        private void initStocksIfNecessary() {
            if (this.stocks == null) {
                this.stocks = new ArrayList();
                this.stocks.add(new HashMap());
            }
        }

        private static int toSynthState(int n2) {
            switch (n2) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 8;
                }
                case 4: {
                    return 512;
                }
            }
            return 1;
        }

        void copyDataFrom(StyleInfo styleInfo) {
            for (int i2 = 0; i2 < 5; ++i2) {
                this.fg[i2] = styleInfo.fg[i2];
                this.bg[i2] = styleInfo.bg[i2];
                this.text[i2] = styleInfo.text[i2];
                this.base[i2] = styleInfo.base[i2];
                this.bgPixmapName[i2] = styleInfo.bgPixmapName[i2];
            }
            this.xThickness = styleInfo.xThickness;
            this.yThickness = styleInfo.yThickness;
            this.font = styleInfo.font;
            if (styleInfo.stocks != null) {
                this.initStocksIfNecessary();
                this.stocks.addAll(styleInfo.stocks);
            }
            if (this.props == null) {
                this.props = GTKStyle.cloneClassSpecificValues(styleInfo.props);
            } else {
                GTKStyle.addClassSpecificValues(styleInfo.props, this.props);
            }
        }

        static GTKStyle access$000() {
            return EMPTY_STYLE;
        }

        GTKStyle toGTKStyle() {
            Object[] objectArray;
            if (this.cachedStyle != null) {
                return this.cachedStyle;
            }
            ArrayList arrayList = new ArrayList();
            for (int i2 = 0; i2 < 5; ++i2) {
                objectArray = null;
                if (this.fg[i2] != null || this.bg[i2] != null || this.text[i2] != null || this.base[i2] != null) {
                    objectArray = new Color[GTKColorType.MAX_COUNT];
                    objectArray[GTKColorType.FOREGROUND.getID()] = this.fg[i2];
                    objectArray[GTKColorType.BACKGROUND.getID()] = this.bg[i2];
                    objectArray[GTKColorType.TEXT_FOREGROUND.getID()] = this.text[i2];
                    objectArray[GTKColorType.TEXT_BACKGROUND.getID()] = this.base[i2];
                }
                if (objectArray == null && this.bgPixmapName[i2] == null) continue;
                GTKStyle.GTKStateInfo gTKStateInfo = new GTKStyle.GTKStateInfo(StyleInfo.toSynthState(i2), null, null, null, (Color[])objectArray, this.bgPixmapName[i2]);
                arrayList.add(gTKStateInfo);
            }
            Object[] objectArray2 = null;
            if (arrayList.size() != 0) {
                objectArray2 = new GTKStyle.GTKStateInfo[arrayList.size()];
                objectArray2 = (GTKStyle.GTKStateInfo[])arrayList.toArray(objectArray2);
            }
            objectArray = this.stocksToArray();
            this.cachedStyle = this.engineInfo != null ? this.engineInfo.constructGTKStyle((GTKStyle.GTKStateInfo[])objectArray2, this.props, this.font, this.xThickness, this.yThickness, (GTKStyle.GTKStockIconInfo[])objectArray) : (objectArray2 != null || objectArray != null || this.props != null || this.font != null || this.xThickness != -1 || this.yThickness != -1 ? new GTKStyle((DefaultSynthStyle.StateInfo[])objectArray2, this.props, this.font, this.xThickness, this.yThickness, (GTKStyle.GTKStockIconInfo[])objectArray) : EMPTY_STYLE);
            return this.cachedStyle;
        }

        private GTKStyle.GTKStockIconInfo[] stocksToArray() {
            if (this.stocks == null) {
                return null;
            }
            ArrayList arrayList = new ArrayList();
            Object[] objectArray = new HashMap[this.stocks.size()];
            objectArray = (HashMap[])this.stocks.toArray(objectArray);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                arrayList.addAll(((HashMap)objectArray[i2]).values());
            }
            Object[] objectArray2 = new GTKStyle.GTKStockIconInfo[arrayList.size()];
            objectArray2 = (GTKStyle.GTKStockIconInfo[])arrayList.toArray(objectArray2);
            return objectArray2;
        }

        StyleInfo(String string) {
            this.name = string;
        }

        void addStockItem(String string, GTKStyle.GTKIconSource[] gTKIconSourceArray) {
            this.initStocksIfNecessary();
            GTKStyle.GTKStockIconInfo gTKStockIconInfo = new GTKStyle.GTKStockIconInfo(string, gTKIconSourceArray);
            HashMap hashMap = (HashMap)this.stocks.get(0);
            hashMap.put(string, gTKStockIconInfo);
        }

        void addProperty(String string, String string2, Object object) {
            CircularIdentityList circularIdentityList;
            if (this.props == null) {
                this.props = new CircularIdentityList();
            }
            if ((circularIdentityList = (CircularIdentityList)this.props.get(string)) == null) {
                circularIdentityList = new CircularIdentityList();
                this.props.set(string, circularIdentityList);
            }
            circularIdentityList.set(string2, object);
        }
    }

    static class Symbol {
        public String name;
        public int val;

        public Symbol(String string, int n2) {
            this.name = string;
            this.val = n2;
        }
    }
}

