/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.BlueprintStyle;
import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.GTKStyleFactory;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthArrowButton;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.TextUI;
import sun.security.action.GetPropertyAction;

class BlueprintEngine
extends GTKEngine
implements GTKConstants {
    private static final Object RENDERING_HINT = "true".equals((String)AccessController.doPrivileged(new GetPropertyAction("swing.pixmap.smoothScaling"))) ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : null;
    private int COMPONENT_NORTH_WEST = 1;
    private int COMPONENT_NORTH = 2;
    private int COMPONENT_NORTH_EAST = 4;
    private int COMPONENT_WEST = 8;
    private int COMPONENT_CENTER = 16;
    private int COMPONENT_EAST = 32;
    private int COMPONENT_SOUTH_EAST = 64;
    private int COMPONENT_SOUTH = 128;
    private int COMPONENT_SOUTH_WEST = 256;
    private int COMPONENT_ALL = 512;
    private int _clipX1;
    private int _clipX2;
    private int _clipY1;
    private int _clipY2;

    BlueprintEngine() {
    }

    private int HLSvalue(double d2, double d3, double d4) {
        if (d4 > 255.0) {
            d4 -= 255.0;
        } else if (d4 < 0.0) {
            d4 += 255.0;
        }
        double d5 = d4 < 42.5 ? d2 + (d3 - d2) * (d4 / 42.5) : (d4 < 127.5 ? d3 : (d4 < 170.0 ? d2 + (d3 - d2) * ((170.0 - d4) / 42.5) : d2));
        return (int)(d5 * 255.0);
    }

    private boolean intersectsClip(int n2, int n3, int n4, int n5) {
        return !(n4 >= n2 && n4 <= this._clipX1 || n5 >= n3 && n5 <= this._clipY1 || this._clipX2 >= this._clipX1 && this._clipX2 <= n2 || this._clipY2 >= this._clipY1 && this._clipY2 <= n3);
    }

    private Color HLStoRGB(int n2, int n3, int n4) {
        double d2 = n2;
        double d3 = n3;
        double d4 = n4;
        if (d4 == 0.0) {
            n2 = n3;
            n4 = n3;
        } else {
            double d5 = d3 < 128.0 ? d3 * (255.0 + d4) / 65025.0 : (d3 + d4 - d3 * d4 / 255.0) / 255.0;
            double d6 = d3 / 127.5 - d5;
            n2 = this.HLSvalue(d6, d5, d2 + 85.0);
            n3 = this.HLSvalue(d6, d5, d2);
            n4 = this.HLSvalue(d6, d5, d2 - 85.0);
        }
        return new Color(n2, n3, n4);
    }

    private Color RGBtoHLS(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (n2 > n3) {
            n8 = Math.max(n2, n4);
            n7 = Math.min(n3, n4);
        } else {
            n8 = Math.max(n3, n4);
            n7 = Math.min(n2, n4);
        }
        int n9 = (n8 + n7) / 2;
        if (n8 == n7) {
            n6 = 0;
            n5 = 0;
        } else {
            int n10 = n8 - n7;
            n6 = n9 < 128 ? 255 * n10 / (n8 + n7) : 255 * n10 / (511 - n8 - n7);
            n5 = n2 == n8 ? (n3 - n4) / n10 : (n3 == n8 ? 2 + (n4 - n2) / n10 : 4 + (n2 - n3) / n10);
            if ((n5 = (int)((double)n5 * 42.5)) < 0) {
                n5 += 255;
            } else if (n5 > 255) {
                n5 -= 255;
            }
        }
        return new Color(n5, n9, n6);
    }

    private void blueprintRender(Image image, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n8 <= 0 || n9 <= 0 || !this.intersectsClip(n6, n7, n6 + n8, n7 + n9)) {
            return;
        }
        if (n4 == 0 && n5 == 0 || n5 == 0 && n9 == n5 || n5 != 0 || n8 == n4) {
            // empty if block
        }
        graphics.drawImage(image, n6, n7, n6 + n8, n7 + n9, n2, n3, n2 + n4, n3 + n5, null);
    }

    private String getComponentType(JComponent jComponent) {
        return GTKStyleFactory.gtkClassFor(SynthLookAndFeel.getRegion(jComponent));
    }

    private boolean hasAncestorOfType(JComponent jComponent, String string) {
        String string2 = null;
        while (jComponent != null) {
            string2 = this.getComponentType(jComponent);
            if (string2 == string) {
                return true;
            }
            if (jComponent.getParent() instanceof JComponent) {
                jComponent = (JComponent)jComponent.getParent();
                continue;
            }
            jComponent = null;
        }
        return false;
    }

    private boolean hasAncestorOfTypeFromList(JComponent jComponent, ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!this.hasAncestorOfType(jComponent, (String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean paintSimpleImage(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, BlueprintStyle.Info info) {
        if (info != null) {
            Rectangle rectangle = graphics.getClipBounds();
            this._clipX1 = rectangle.x;
            this._clipY1 = rectangle.y;
            this._clipX2 = this._clipX1 + rectangle.width;
            this._clipY2 = this._clipY1 + rectangle.height;
            this.themeBlueprintRender(synthContext, graphics, n2, n3, n4, n5, info.getImage(), info.getImageInsets(), bl2 ? this.COMPONENT_ALL : this.COMPONENT_ALL | this.COMPONENT_CENTER, info.getStretch(), false, info.isBkgMask(), info.isRecolorable(), info.getColorizeColor());
            if (bl2) {
                this.themeBlueprintRender(synthContext, graphics, n2, n3, n4, n5, info.getOverlayImage(), info.getOverlayInsets(), this.COMPONENT_ALL, info.getOverlayStretch(), true, false, false, null);
            }
            return true;
        }
        return false;
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, int n2, Color color, int n3, int n4, int n5, int n6) {
        JComponent jComponent = synthContext.getComponent();
        if (jComponent instanceof JPopupMenu && this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("BACKGROUND", null, n2, -100, -100, -100, -100, null))) {
            return;
        }
        super.paintBackground(synthContext, graphics, n2, color, n3, n4, n5, n6);
    }

    private void paintGapImage(SynthContext synthContext, BlueprintStyle.Info info, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, int n6, int n7, int n8) {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        int n9 = 0;
        int n10 = this.COMPONENT_ALL;
        Image image = info.getGapStartImage();
        Image image2 = info.getGapImage();
        Image image3 = info.getGapEndImage();
        if (!bl2) {
            n10 |= this.COMPONENT_CENTER;
        }
        n9 = image != null ? (n6 == 2 || n8 == 3 ? image.getHeight(null) : image.getWidth(null)) : (n6 == 2 || n8 == 3 ? ((BlueprintStyle)synthContext.getStyle()).getYThickness() : ((BlueprintStyle)synthContext.getStyle()).getXThickness());
        if (n8 > 0) {
            switch (n6) {
                case 2: {
                    if (!bl2) {
                        n10 |= this.COMPONENT_NORTH_WEST | this.COMPONENT_NORTH | this.COMPONENT_NORTH_EAST;
                    }
                    rectangle.x = n2;
                    rectangle.y = n3;
                    rectangle.width = n7;
                    rectangle.height = n9;
                    rectangle2.x = n2 + n7;
                    rectangle2.y = n3;
                    rectangle2.width = n8;
                    rectangle2.height = n9;
                    rectangle3.x = n2 + n7 + n8;
                    rectangle3.y = n3;
                    rectangle3.width = n4 - (n7 + n8);
                    rectangle3.height = n9;
                    break;
                }
                case 3: {
                    if (!bl2) {
                        n10 |= this.COMPONENT_SOUTH_WEST | this.COMPONENT_SOUTH | this.COMPONENT_SOUTH_EAST;
                    }
                    rectangle.x = n2;
                    rectangle.y = n3 + n5 - n9;
                    rectangle.width = n7;
                    rectangle.height = n9;
                    rectangle2.x = n2 + n7;
                    rectangle2.y = n3 + n5 - n9;
                    rectangle2.width = n8;
                    rectangle2.height = n9;
                    rectangle3.x = n2 + n7 + n8;
                    rectangle3.y = n3 + n5 - n9;
                    rectangle3.width = n4 - (n7 + n8);
                    rectangle3.height = n9;
                    break;
                }
                case 0: {
                    if (!bl2) {
                        n10 |= this.COMPONENT_NORTH_WEST | this.COMPONENT_WEST | this.COMPONENT_SOUTH_WEST;
                    }
                    rectangle.x = n2;
                    rectangle.y = n3;
                    rectangle.width = n9;
                    rectangle.height = n7;
                    rectangle2.x = n2;
                    rectangle2.y = n3 + n7;
                    rectangle2.width = n9;
                    rectangle2.height = n8;
                    rectangle3.x = n2;
                    rectangle3.y = n3 + n7 + n8;
                    rectangle3.width = n9;
                    rectangle3.height = n5 - (n7 + n8);
                    break;
                }
                case 1: {
                    if (!bl2) {
                        n10 |= this.COMPONENT_NORTH_EAST | this.COMPONENT_EAST | this.COMPONENT_SOUTH_EAST;
                    }
                    rectangle.x = n2 + n4 - n9;
                    rectangle.y = n3;
                    rectangle.width = n9;
                    rectangle.height = n7;
                    rectangle2.x = n2 + n4 - n9;
                    rectangle2.y = n3 + n7;
                    rectangle2.width = n9;
                    rectangle2.height = n8;
                    rectangle3.x = n2 + n4 - n9;
                    rectangle3.y = n3 + n7 + n8;
                    rectangle3.width = n9;
                    rectangle3.height = n5 - (n7 + n8);
                }
            }
            this.themeBlueprintRender(synthContext, graphics, n2, n3, n4, n5, info.getImage(), info.getImageInsets(), n10, true, false, info.isBkgMask(), info.isRecolorable(), info.getColorizeColor());
            if (image != null) {
                this.themeBlueprintRender(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, image, info.getGapStartInsets(), this.COMPONENT_ALL, true, false, false, false, null);
            }
            if (image2 != null) {
                this.themeBlueprintRender(synthContext, graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, image2, info.getGapInsets(), this.COMPONENT_ALL, true, false, false, false, null);
            }
            if (image3 != null) {
                this.themeBlueprintRender(synthContext, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, image3, info.getGapEndInsets(), this.COMPONENT_ALL, true, false, false, false, null);
            }
        }
    }

    public void paintArrow(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, String string, int n5, int n6, int n7, int n8) {
        Container container = synthContext.getComponent();
        if (container.getName() == "Spinner.nextButton" || container.getName() == "Spinner.previousButton" || container.getName() == "ComboBox.arrowButton") {
            return;
        }
        String string2 = null;
        if ((container = container.getParent()) != null && container instanceof JComponent && (container = container.getParent()) != null && container instanceof JComponent) {
            string2 = this.getComponentType((JComponent)container);
        }
        if (!this.paintSimpleImage(synthContext, graphics, n5, n6, n7, n8, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("ARROW", string, n2, n3, -100, -100, n4, string2))) {
            super.paintArrow(synthContext, graphics, n2, n3, n4, string, n5, n6, n7, n8);
        }
    }

    public void paintBox(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        Region region = synthContext.getRegion();
        Container container = synthContext.getComponent();
        SynthStyle synthStyle = synthContext.getStyle();
        if (string == "vscrollbar" || string == "hscrollbar" && container instanceof SynthArrowButton) {
            int n8 = ((SynthArrowButton)container).getDirection();
            switch (n8) {
                case 1: {
                    n8 = 100;
                    break;
                }
                case 5: {
                    n8 = 101;
                    break;
                }
                case 3: {
                    n8 = 103;
                    break;
                }
                case 7: {
                    n8 = 102;
                }
            }
            container = (JComponent)container.getParent();
            if (container == null || !(container instanceof JComponent)) {
                return;
            }
            if (container instanceof JScrollBar) {
                ScrollBarUI scrollBarUI = ((JScrollBar)container).getUI();
                if (scrollBarUI instanceof SynthUI) {
                    SynthContext synthContext2 = ((SynthUI)((Object)scrollBarUI)).getContext((JComponent)container);
                    synthStyle = synthContext2.getStyle();
                    synthContext2.dispose();
                }
                if (this.paintSimpleImage(synthContext, graphics, n4, n5, n6, n7, true, ((BlueprintStyle)synthStyle).getInfo("STEPPER", string, n2, -100, -100, -100, n8, null))) {
                    return;
                }
                if (this.paintSimpleImage(synthContext, graphics, n4, n5, n6, n7, true, ((BlueprintStyle)synthStyle).getInfo("BOX", string, n2, n3, -100, -100, -100, null))) {
                    super.paintBox(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
                }
                return;
            }
        }
        if (container.getName() == "Spinner.nextButton" || container.getName() == "Spinner.previousButton" && container instanceof SynthArrowButton) {
            SpinnerUI spinnerUI;
            string = ((SynthArrowButton)container).getDirection() == 1 ? "spinbutton_up" : "spinbutton_down";
            if ((container = container.getParent()) != null && container instanceof JSpinner && (spinnerUI = ((JSpinner)container).getUI()) instanceof SynthUI) {
                SynthContext synthContext3 = ((SynthUI)((Object)spinnerUI)).getContext((JComponent)container);
                synthStyle = synthContext3.getStyle();
                synthContext3.dispose();
            }
        }
        int n9 = region == Region.SCROLL_BAR ? (((JScrollBar)container).getOrientation() == 0 ? 0 : 1) : (region == Region.SLIDER_TRACK ? (((JSlider)container).getOrientation() == 0 ? 0 : 1) : -100);
        String string2 = null;
        if (container != null && (container = container.getParent()) != null && container instanceof JComponent) {
            string2 = this.getComponentType((JComponent)container);
        }
        if (!this.paintSimpleImage(synthContext, graphics, n4, n5, n6, n7, true, ((BlueprintStyle)synthStyle).getInfo("BOX", string, n2, n3, n9, -100, -100, string2))) {
            super.paintBox(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
        }
    }

    public void paintCheck(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        if (!this.paintSimpleImage(synthContext, graphics, n4, n5, n6, n7, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("CHECK", string, n2, n3, -100, -100, -100, null))) {
            super.paintCheck(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
        }
    }

    public void paintExpander(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        super.paintExpander(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
    }

    public void paintOption(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        if (!this.paintSimpleImage(synthContext, graphics, n4, n5, n6, n7, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("OPTION", string, n2, n3, -100, -100, -100, null))) {
            super.paintOption(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
        }
    }

    public void paintShadow(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        JComboBox jComboBox;
        Component component;
        Container container = synthContext.getComponent();
        String string2 = null;
        SynthStyle synthStyle = synthContext.getStyle();
        if (container.getName() == "ComboBox.textField") {
            string2 = "GtkCombo";
        } else if (container.getName() == "ComboBox.renderer" && (container = container.getParent()) != null) {
            container = container.getParent();
            string2 = "GtkCombo";
        }
        if (container instanceof JComboBox && (component = (jComboBox = (JComboBox)container).getEditor().getEditorComponent()) instanceof JTextField) {
            TextUI textUI;
            if (!jComboBox.isEditable() && component.getParent() == null) {
                jComboBox.add(component);
                jComboBox.remove(component);
            }
            if ((textUI = ((JTextField)component).getUI()) instanceof SynthUI) {
                SynthContext synthContext2 = ((SynthUI)((Object)textUI)).getContext((JComponent)container);
                synthStyle = synthContext2.getStyle();
                synthContext2.dispose();
            }
        }
        if (string == "menu" && string2 == "GtkHBox") {
            return;
        }
        if (!this.paintSimpleImage(synthContext, graphics, n4, n5, n6, n7, true, ((BlueprintStyle)synthStyle).getInfo("SHADOW", string, n2, n3, -100, -100, -100, string2))) {
            super.paintShadow(synthContext, graphics, n2, n3, string, n4, n5, n6, n7);
        }
    }

    public void paintExtension(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8) {
        if (!this.paintSimpleImage(synthContext, graphics, n4, n5, n6, n7, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("EXTENSION", string, n2, n3, -100, n8, -100, null))) {
            super.paintExtension(synthContext, graphics, n2, n3, string, n4, n5, n6, n7, n8);
        }
    }

    public void paintHandle(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8) {
        if (string == "handlebox" || string == "dockitem") {
            n6 -= 2;
            --n7;
        }
        if (!this.paintSimpleImage(synthContext, graphics, n4, n5, n6, n7, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("HANDLE", string, n2, n3, n8, -100, -100, null))) {
            super.paintHandle(synthContext, graphics, n2, n3, string, n4, n5, n6, n7, n8);
        }
    }

    public void paintSlider(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8) {
        if (!this.paintSimpleImage(synthContext, graphics, n4, n5, n6, n7, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("SLIDER", string, n2, n3, n8, -100, -100, null))) {
            super.paintSlider(synthContext, graphics, n2, n3, string, n4, n5, n6, n7, n8);
        }
    }

    public void paintBoxGap(SynthContext synthContext, Graphics graphics, int n2, int n3, String string, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        BlueprintStyle.Info info = ((BlueprintStyle)synthContext.getStyle()).getInfo("BOX_GAP", string, n2, n3, -100, n8, -100, null);
        if (info != null) {
            this.paintGapImage(synthContext, info, graphics, n4, n5, n6, n7, true, n8, n9, n10);
        } else {
            super.paintBoxGap(synthContext, graphics, n2, n3, string, n4, n5, n6, n7, n8, n9, n10);
        }
    }

    public void paintFlatBox(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        if (string == "checkbutton" && n2 == 2) {
            return;
        }
        Container container = synthContext.getComponent();
        String string2 = null;
        if ((container = container.getParent()) instanceof CellRendererPane) {
            container = container.getParent();
        }
        if (container != null && container instanceof JComponent) {
            string2 = this.getComponentType((JComponent)container);
        }
        if (!this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("FLAT_BOX", string, n2, -100, -100, -100, -100, string2))) {
            super.paintFlatBox(synthContext, graphics, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintFocus(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        if (!this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("FOCUS", string, n2, -100, -100, -100, -100, null))) {
            super.paintFocus(synthContext, graphics, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintHline(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        Object object;
        SynthStyle synthStyle = synthContext.getStyle();
        Container container = synthContext.getComponent();
        if ((container = container.getParent()) != null && container instanceof JPopupMenu && (object = ((JPopupMenu)container).getUI()) instanceof SynthUI) {
            SynthContext synthContext2 = ((SynthUI)object).getContext((JComponent)container);
            synthStyle = synthContext2.getStyle();
            synthContext2.dispose();
        }
        if ((object = ((BlueprintStyle)synthStyle).getInfo("HLINE", string, n2, -100, 0, -100, -100, null)) != null && ((BlueprintStyle.Info)object).getImage() != null) {
            this.themeBlueprintRender(synthContext, graphics, n3, n4, n5, n6, ((BlueprintStyle.Info)object).getImage(), ((BlueprintStyle.Info)object).getImageInsets(), this.COMPONENT_ALL, ((BlueprintStyle.Info)object).getStretch(), false, ((BlueprintStyle.Info)object).isBkgMask(), ((BlueprintStyle.Info)object).isRecolorable(), ((BlueprintStyle.Info)object).getColorizeColor());
        } else {
            super.paintHline(synthContext, graphics, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintVline(SynthContext synthContext, Graphics graphics, int n2, String string, int n3, int n4, int n5, int n6) {
        BlueprintStyle.Info info = ((BlueprintStyle)synthContext.getStyle()).getInfo("VLINE", string, n2, -100, 1, -100, -100, null);
        if (info != null && info.getImage() != null) {
            this.themeBlueprintRender(synthContext, graphics, n3, n4, n5, n6, info.getImage(), info.getImageInsets(), this.COMPONENT_ALL, info.getStretch(), false, info.isBkgMask(), info.isRecolorable(), info.getColorizeColor());
        } else {
            super.paintVline(synthContext, graphics, n2, string, n3, n4, n5, n6);
        }
    }

    private void themeBlueprintRender(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, Image object, Insets insets, int n6, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Color color) {
        int n7;
        int n8;
        int n9;
        int n10;
        Object object2;
        int n11;
        Object object3;
        Object object4;
        if (object == null) {
            return;
        }
        if (insets == null) {
            insets = GTKPainter.EMPTY_INSETS;
        }
        int n12 = ((Image)object).getWidth(null);
        int n13 = ((Image)object).getHeight(null);
        if (bl4) {
            object4 = new BufferedImage(n12, n13, 2);
            object3 = ((BufferedImage)object4).createGraphics();
            n11 = 0;
            object2 = synthContext.getComponent();
            for (n10 = 0; n11 == 0 && n10 <= 2; ++n10) {
                object2 = ((Component)object2).getParent();
                if (object2 != null) {
                    Color color2 = ((Component)object2).getBackground();
                    if (color2 == null || color2.equals(color) || color2.equals(Color.black) || object2 instanceof JFileChooser) continue;
                    color = color2;
                    n11 = 1;
                    continue;
                }
                n11 = 1;
            }
            if (color == null) {
                color = ((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState(), ColorType.BACKGROUND);
            }
            ((Graphics)object3).setColor(color);
            ((Graphics)object3).fillRect(0, 0, n12, n13);
            ((Graphics2D)object3).setComposite(AlphaComposite.DstIn);
            ((Graphics)object3).drawImage((Image)object, 0, 0, null);
            ((Graphics)object3).dispose();
            object = object4;
        } else if (bl5) {
            object4 = new BufferedImage(n12, n13, 2);
            object3 = ((BufferedImage)object4).createGraphics();
            ((Graphics2D)object3).setComposite(AlphaComposite.Src);
            ((Graphics)object3).drawImage((Image)object, 0, 0, null);
            ((Graphics)object3).dispose();
            n11 = color.getRed();
            n10 = color.getGreen();
            int n14 = color.getBlue();
            int n15 = color.getAlpha();
            Color color3 = this.RGBtoHLS(n11, n10, n14);
            n9 = color3.getRed();
            n8 = color3.getGreen();
            n7 = color3.getBlue();
            int[] nArray = null;
            nArray = ((BufferedImage)object4).getRaster().getPixels(0, 0, n12, n13, nArray);
            for (int i2 = 0; i2 < nArray.length; i2 += 4) {
                n11 = nArray[i2];
                n10 = nArray[i2 + 1];
                n14 = nArray[i2 + 2];
                color3 = this.RGBtoHLS(n11, n10, n14);
                n11 = n9;
                n10 = color3.getGreen();
                n14 = n7;
                color3 = this.HLStoRGB(n11, n10, n14);
                nArray[i2] = color3.getRed();
                nArray[i2 + 1] = color3.getGreen();
                nArray[i2 + 2] = color3.getBlue();
                nArray[i2 + 3] = Math.min(nArray[i2 + 3], n15);
            }
            ((BufferedImage)object4).getRaster().setPixels(0, 0, n12, n13, nArray);
            object = object4;
        }
        if (bl2) {
            // empty if block
        }
        if (n12 <= 0 || n13 <= 0) {
            return;
        }
        object3 = RENDERING_HINT;
        if (object3 != null && bl2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            object4 = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (object4 == null) {
                object4 = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object3);
        } else {
            object4 = null;
        }
        if (!bl2) {
            if (bl3) {
                this.blueprintRender((Image)object, graphics, 0, 0, n12, n13, n2 + n4 / 2 - n12 / 2, n3 + n5 / 2 - n13 / 2, n12, n13);
            } else {
                int n16 = 0;
                int n17 = n3 + n5;
                for (n10 = n3; n10 < n17; n10 += n13 - n16) {
                    int n18 = 0;
                    n9 = n2 + n4;
                    for (int i3 = n2; i3 < n9; i3 += n12 - n18) {
                        n8 = Math.min(n9, i3 + n12 - n18);
                        if (this.intersectsClip(i3, n10, n8, n7 = Math.min(n17, n10 + n13 - n16))) {
                            graphics.drawImage((Image)object, i3, n10, n8, n7, n18, n16, n18 + n8 - i3, n16 + n7 - n10, null);
                        }
                        n18 = 0;
                    }
                    n16 = 0;
                }
            }
        } else {
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            object2 = new int[4];
            int[] nArray3 = new int[4];
            nArray[0] = 0;
            nArray[1] = insets.left;
            nArray[2] = n12 - insets.right;
            nArray[3] = n12;
            nArray2[0] = 0;
            nArray2[1] = insets.top;
            nArray2[2] = n13 - insets.bottom;
            nArray2[3] = n13;
            object2[0] = n2;
            object2[1] = n2 + insets.left;
            object2[2] = n2 + n4 - insets.right;
            object2[3] = n2 + n4;
            nArray3[0] = n3;
            nArray3[1] = n3 + insets.top;
            nArray3[2] = n3 + n5 - insets.bottom;
            nArray3[3] = n3 + n5;
            if ((n6 & this.COMPONENT_ALL) != 0) {
                n6 = this.COMPONENT_ALL - 1 & ~n6;
            }
            if ((n6 & this.COMPONENT_NORTH_WEST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[0], nArray2[0], nArray[1] - nArray[0], nArray2[1] - nArray2[0], (int)object2[0], nArray3[0], (int)(object2[1] - object2[0]), nArray3[1] - nArray3[0]);
            }
            if ((n6 & this.COMPONENT_NORTH) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[1], nArray2[0], nArray[2] - nArray[1], nArray2[1] - nArray2[0], (int)object2[1], nArray3[0], (int)(object2[2] - object2[1]), nArray3[1] - nArray3[0]);
            }
            if ((n6 & this.COMPONENT_NORTH_EAST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[2], nArray2[0], nArray[3] - nArray[2], nArray2[1] - nArray2[0], (int)object2[2], nArray3[0], (int)(object2[3] - object2[2]), nArray3[1] - nArray3[0]);
            }
            if ((n6 & this.COMPONENT_WEST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[0], nArray2[1], nArray[1] - nArray[0], nArray2[2] - nArray2[1], (int)object2[0], nArray3[1], (int)(object2[1] - object2[0]), nArray3[2] - nArray3[1]);
            }
            if ((n6 & this.COMPONENT_CENTER) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[1], nArray2[1], nArray[2] - nArray[1], nArray2[2] - nArray2[1], (int)object2[1], nArray3[1], (int)(object2[2] - object2[1]), nArray3[2] - nArray3[1]);
            }
            if ((n6 & this.COMPONENT_EAST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[2], nArray2[1], nArray[3] - nArray[2], nArray2[2] - nArray2[1], (int)object2[2], nArray3[1], (int)(object2[3] - object2[2]), nArray3[2] - nArray3[1]);
            }
            if ((n6 & this.COMPONENT_SOUTH_WEST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[0], nArray2[2], nArray[1] - nArray[0], nArray2[3] - nArray2[2], (int)object2[0], nArray3[2], (int)(object2[1] - object2[0]), nArray3[3] - nArray3[2]);
            }
            if ((n6 & this.COMPONENT_SOUTH) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[1], nArray2[2], nArray[2] - nArray[1], nArray2[3] - nArray2[2], (int)object2[1], nArray3[2], (int)(object2[2] - object2[1]), nArray3[3] - nArray3[2]);
            }
            if ((n6 & this.COMPONENT_SOUTH_EAST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[2], nArray2[2], nArray[3] - nArray[2], nArray2[3] - nArray2[2], (int)object2[2], nArray3[2], (int)(object2[3] - object2[2]), nArray3[3] - nArray3[2]);
            }
        }
        if (object4 != null) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, object4);
        }
    }
}

