/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

class JDKClassLoader {
    private static final JDKClassLoaderCache classCache = new JDKClassLoaderCache(null);
    private static final Class[] NO_ARGS = new Class[0];
    private static final Method latestUserDefinedLoaderMethod = JDKClassLoader.getLatestUserDefinedLoaderMethod();
    static Class class$java$io$ObjectInputStream;

    JDKClassLoader() {
    }

    static Class[] access$100() {
        return NO_ARGS;
    }

    private static ClassLoader getLatestUserDefinedLoader() {
        try {
            return (ClassLoader)latestUserDefinedLoaderMethod.invoke(null, NO_ARGS);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error("java.io.ObjectInputStream latestUserDefinedLoader " + invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("java.io.ObjectInputStream latestUserDefinedLoader " + illegalAccessException);
        }
    }

    private static Method getLatestUserDefinedLoaderMethod() {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    Class clazz = class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = JDKClassLoader.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream;
                    method = clazz.getDeclaredMethod("latestUserDefinedLoader", JDKClassLoader.access$100());
                    method.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new Error("java.io.ObjectInputStream latestUserDefinedLoader " + noSuchMethodException);
                }
                return method;
            }
        });
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static Class loadClass(Class clazz, String string) throws ClassNotFoundException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            throw new ClassNotFoundException();
        }
        ClassLoader classLoader = clazz != null ? clazz.getClassLoader() : JDKClassLoader.getLatestUserDefinedLoader();
        Object object = classCache.createKey(string, classLoader);
        if (classCache.knownToFail(object)) {
            throw new ClassNotFoundException(string);
        }
        try {
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classCache.recordFailure(object);
            throw classNotFoundException;
        }
    }

    private static class JDKClassLoaderCache {
        private final Map cache = Collections.synchronizedMap(new WeakHashMap());
        private static final Object KNOWN_TO_FAIL = new Object();

        private JDKClassLoaderCache() {
        }

        JDKClassLoaderCache(1 var1_1) {
            this();
        }

        public final void recordFailure(Object object) {
            this.cache.put(object, KNOWN_TO_FAIL);
        }

        public final boolean knownToFail(Object object) {
            return this.cache.get(object) == KNOWN_TO_FAIL;
        }

        public final Object createKey(String string, ClassLoader classLoader) {
            return new CacheKey(string, classLoader);
        }

        private static class CacheKey {
            String className;
            ClassLoader loader;

            public int hashCode() {
                if (this.loader == null) {
                    return this.className.hashCode();
                }
                return this.className.hashCode() ^ this.loader.hashCode();
            }

            public boolean equals(Object object) {
                try {
                    if (object == null) {
                        return false;
                    }
                    CacheKey cacheKey = (CacheKey)object;
                    return this.className.equals(cacheKey.className) && this.loader == cacheKey.loader;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }

            public CacheKey(String string, ClassLoader classLoader) {
                this.className = string;
                this.loader = classLoader;
            }
        }
    }
}

